/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.annotation.Obsolete;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookiePathComparator;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.apache.http.message.BufferedHeader;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Obsolete
@ThreadSafe
public class RFC2109Spec
extends CookieSpecBase {
    static final String[] DATE_PATTERNS = new String[]{"EEE, dd MMM yyyy HH:mm:ss zzz", "EEE, dd-MMM-yy HH:mm:ss zzz", "EEE MMM d HH:mm:ss yyyy"};
    private final boolean oneHeader;

    /*
     * WARNING - void declaration
     */
    public RFC2109Spec(String[] datepatterns, boolean oneHeader) {
        super(new RFC2109VersionHandler(), new BasicPathHandler(), new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new BasicExpiresHandler(datepatterns != null ? (String[])var1_1.clone() : DATE_PATTERNS));
        void var2_2;
        void var1_1;
        this.oneHeader = var2_2;
    }

    public RFC2109Spec() {
        this(null, false);
    }

    /*
     * WARNING - void declaration
     */
    protected RFC2109Spec(boolean oneHeader, CommonCookieAttributeHandler ... handlers) {
        super((CommonCookieAttributeHandler[])var2_2);
        void var1_1;
        void var2_2;
        this.oneHeader = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        void var2_2;
        void var1_1;
        Args.notNull((Object)header, (String)"Header");
        Args.notNull((Object)origin, (String)"Cookie origin");
        if (!header.getName().equalsIgnoreCase("Set-Cookie")) {
            throw new MalformedCookieException("Unrecognized cookie header '" + header.toString() + "'");
        }
        HeaderElement[] elems = header.getElements();
        return this.parse((HeaderElement[])var1_1, (CookieOrigin)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        void var2_2;
        void var1_1;
        void var3_3;
        Args.notNull((Object)cookie, (String)"Cookie");
        String name = cookie.getName();
        if (name.indexOf(32) != -1) {
            throw new CookieRestrictionViolationException("Cookie name may not contain blanks");
        }
        if (var3_3.startsWith("$")) {
            throw new CookieRestrictionViolationException("Cookie name may not start with $");
        }
        super.validate((Cookie)var1_1, (CookieOrigin)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        void var1_1;
        ArrayList<Cookie> cookieList;
        Args.notEmpty(cookies, (String)"List of cookies");
        if (cookies.size() > 1) {
            cookieList = new ArrayList<Cookie>(cookies);
            Collections.sort(cookieList, CookiePathComparator.INSTANCE);
        }
        if (this.oneHeader) {
            return this.doFormatOneHeader(cookieList);
        }
        return this.doFormatManyHeaders((List<Cookie>)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private List<Header> doFormatOneHeader(List<Cookie> cookies) {
        void var3_3;
        int version = Integer.MAX_VALUE;
        for (Cookie cookie : cookies) {
            if (cookie.getVersion() >= version) continue;
            version = cookie.getVersion();
        }
        CharArrayBuffer buffer = new CharArrayBuffer(40 * cookies.size());
        buffer.append("Cookie");
        buffer.append(": ");
        buffer.append("$Version=");
        buffer.append(Integer.toString(version));
        for (Cookie cooky : cookies) {
            void var1_1;
            buffer.append("; ");
            this.formatCookieAsVer(buffer, (Cookie)var1_1, version);
        }
        ArrayList<Header> headers = new ArrayList<Header>(1);
        headers.add((Header)new BufferedHeader((CharArrayBuffer)var3_3));
        return headers;
    }

    /*
     * WARNING - void declaration
     */
    private List<Header> doFormatManyHeaders(List<Cookie> cookies) {
        void var2_2;
        ArrayList<BufferedHeader> headers = new ArrayList<BufferedHeader>(cookies.size());
        for (Cookie cookie : cookies) {
            void var3_3;
            int version = cookie.getVersion();
            CharArrayBuffer buffer = new CharArrayBuffer(40);
            buffer.append("Cookie: ");
            buffer.append("$Version=");
            buffer.append(Integer.toString(version));
            buffer.append("; ");
            this.formatCookieAsVer(buffer, (Cookie)var3_3, version);
            headers.add(new BufferedHeader(buffer));
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected void formatParamAsVer(CharArrayBuffer buffer, String name, String value, int version) {
        void var2_2;
        buffer.append((String)var2_2);
        buffer.append("=");
        if (value != null) {
            void var3_3;
            void var1_1;
            if (version > 0) {
                buffer.append('\"');
                buffer.append(value);
                buffer.append('\"');
                return;
            }
            var1_1.append((String)var3_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void formatCookieAsVer(CharArrayBuffer buffer, Cookie cookie, int version) {
        this.formatParamAsVer(buffer, cookie.getName(), cookie.getValue(), version);
        if (cookie.getPath() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("path")) {
            buffer.append("; ");
            this.formatParamAsVer(buffer, "$Path", cookie.getPath(), version);
        }
        if (cookie.getDomain() != null && cookie instanceof ClientCookie && ((ClientCookie)cookie).containsAttribute("domain")) {
            void var3_3;
            void var2_2;
            void var1_1;
            buffer.append("; ");
            this.formatParamAsVer((CharArrayBuffer)var1_1, "$Domain", var2_2.getDomain(), (int)var3_3);
        }
    }

    @Override
    public int getVersion() {
        return 1;
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "rfc2109";
    }
}

