/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Locale;
import org.apache.http.annotation.Immutable;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieRestrictionViolationException;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

@Immutable
public class RFC2109DomainHandler
implements CommonCookieAttributeHandler {
    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        void var2_2;
        void var1_1;
        Args.notNull((Object)cookie, (String)"Cookie");
        if (value == null) {
            throw new MalformedCookieException("Missing value for domain attribute");
        }
        if (value.trim().isEmpty()) {
            throw new MalformedCookieException("Blank value for domain attribute");
        }
        var1_1.setDomain((String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            throw new CookieRestrictionViolationException("Cookie domain may not be null");
        }
        if (!domain.equals(host)) {
            String string;
            int n = domain.indexOf(46);
            if (n == -1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain + "\" does not match the host \"" + host + "\"");
            }
            if (!domain.startsWith(".")) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain + "\" violates RFC 2109: domain must start with a dot");
            }
            int dotIndex = domain.indexOf(46, 1);
            if (dotIndex < 0 || n == domain.length() - 1) {
                throw new CookieRestrictionViolationException("Domain attribute \"" + domain + "\" violates RFC 2109: domain must contain an embedded dot");
            }
            if (!(host = host.toLowerCase(Locale.ROOT)).endsWith(domain)) {
                throw new CookieRestrictionViolationException("Illegal domain attribute \"" + domain + "\". Domain of origin: \"" + host + "\"");
            }
            if ((string = host.substring(0, string.length() - domain.length())).indexOf(46) != -1) {
                void var1_1;
                throw new CookieRestrictionViolationException("Domain attribute \"" + (String)var1_1 + "\" violates RFC 2109: host minus domain may not contain any dots");
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        void var1_1;
        void var2_2;
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        String host = origin.getHost();
        String domain = cookie.getDomain();
        if (domain == null) {
            return false;
        }
        return host.equals(domain) || domain.startsWith(".") && var2_2.endsWith((String)var1_1);
    }

    @Override
    public String getAttributeName() {
        return "domain";
    }
}

