/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.annotation.Immutable;
import org.apache.http.conn.util.PublicSuffixList;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

@Immutable
public class PublicSuffixDomainFilter
implements CommonCookieAttributeHandler {
    private final CommonCookieAttributeHandler handler;
    private final PublicSuffixMatcher publicSuffixMatcher;

    /*
     * WARNING - void declaration
     */
    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler, PublicSuffixMatcher publicSuffixMatcher) {
        void var2_2;
        void var1_1;
        this.handler = (CommonCookieAttributeHandler)Args.notNull((Object)var1_1, (String)"Cookie handler");
        this.publicSuffixMatcher = (PublicSuffixMatcher)Args.notNull((Object)var2_2, (String)"Public suffix matcher");
    }

    /*
     * WARNING - void declaration
     */
    public PublicSuffixDomainFilter(CommonCookieAttributeHandler handler, PublicSuffixList suffixList) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)handler, (String)"Cookie handler");
        Args.notNull((Object)suffixList, (String)"Public suffix list");
        this.handler = var1_1;
        this.publicSuffixMatcher = new PublicSuffixMatcher(suffixList.getRules(), var2_2.getExceptions());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        void var2_2;
        void var1_1;
        void var3_3;
        String domain = cookie.getDomain();
        if (!domain.equalsIgnoreCase("localhost") && this.publicSuffixMatcher.matches((String)var3_3)) {
            return false;
        }
        return this.handler.match((Cookie)var1_1, (CookieOrigin)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void parse(SetCookie cookie, String value) throws MalformedCookieException {
        void var2_2;
        void var1_1;
        this.handler.parse((SetCookie)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        void var2_2;
        void var1_1;
        this.handler.validate((Cookie)var1_1, (CookieOrigin)var2_2);
    }

    @Override
    public String getAttributeName() {
        return this.handler.getAttributeName();
    }

    /*
     * WARNING - void declaration
     */
    public static CommonCookieAttributeHandler decorate(CommonCookieAttributeHandler handler, PublicSuffixMatcher publicSuffixMatcher) {
        CommonCookieAttributeHandler commonCookieAttributeHandler;
        Args.notNull((Object)handler, (String)"Cookie attribute handler");
        if (publicSuffixMatcher != null) {
            void var1_1;
            return new PublicSuffixDomainFilter(handler, (PublicSuffixMatcher)var1_1);
        }
        return commonCookieAttributeHandler;
    }
}

