/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.BitSet;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.ParseException;
import org.apache.http.annotation.Immutable;
import org.apache.http.message.BasicHeaderElement;
import org.apache.http.message.BasicNameValuePair;
import org.apache.http.message.ParserCursor;
import org.apache.http.message.TokenParser;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@Immutable
public class NetscapeDraftHeaderParser {
    public static final NetscapeDraftHeaderParser DEFAULT = new NetscapeDraftHeaderParser();
    private static final char PARAM_DELIMITER = ';';
    private static final BitSet TOKEN_DELIMS = TokenParser.INIT_BITSET((int[])new int[]{61, 59});
    private static final BitSet VALUE_DELIMS = TokenParser.INIT_BITSET((int[])new int[]{59});
    private final TokenParser tokenParser = TokenParser.INSTANCE;

    /*
     * WARNING - void declaration
     */
    public HeaderElement parseHeader(CharArrayBuffer buffer, ParserCursor cursor) throws ParseException {
        void var3_3;
        Args.notNull((Object)buffer, (String)"Char array buffer");
        Args.notNull((Object)cursor, (String)"Parser cursor");
        NameValuePair nvp = this.parseNameValuePair(buffer, cursor);
        ArrayList<NameValuePair> params = new ArrayList<NameValuePair>();
        while (!cursor.atEnd()) {
            NameValuePair param = this.parseNameValuePair(buffer, cursor);
            params.add(param);
        }
        ArrayList<NameValuePair> arrayList = params;
        return new BasicHeaderElement(nvp.getName(), var3_3.getValue(), arrayList.toArray(new NameValuePair[arrayList.size()]));
    }

    /*
     * WARNING - void declaration
     */
    private NameValuePair parseNameValuePair(CharArrayBuffer buffer, ParserCursor cursor) {
        void var1_1;
        void var3_3;
        String name = this.tokenParser.parseToken(buffer, cursor, TOKEN_DELIMS);
        if (cursor.atEnd()) {
            return new BasicNameValuePair(name, null);
        }
        char delim = buffer.charAt(cursor.getPos());
        ParserCursor parserCursor = cursor;
        parserCursor.updatePos(parserCursor.getPos() + 1);
        if (delim != '=') {
            return new BasicNameValuePair(name, null);
        }
        String value = this.tokenParser.parseToken(buffer, cursor, VALUE_DELIMS);
        if (!cursor.atEnd()) {
            void var2_2;
            void v1 = var2_2;
            v1.updatePos(v1.getPos() + 1);
        }
        return new BasicNameValuePair((String)var3_3, (String)var1_1);
    }
}

