/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import org.apache.http.annotation.Immutable;
import org.apache.http.conn.util.PublicSuffixMatcher;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.CookieSpecProvider;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.DefaultCookieSpec;
import org.apache.http.impl.cookie.NetscapeDraftSpec;
import org.apache.http.impl.cookie.PublicSuffixDomainFilter;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.apache.http.impl.cookie.RFC2109Spec;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DomainAttributeHandler;
import org.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import org.apache.http.impl.cookie.RFC2965Spec;
import org.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import org.apache.http.protocol.HttpContext;

@Immutable
public class DefaultCookieSpecProvider
implements CookieSpecProvider {
    private final CompatibilityLevel compatibilityLevel;
    private final PublicSuffixMatcher publicSuffixMatcher;
    private final String[] datepatterns;
    private final boolean oneHeader;
    private volatile CookieSpec cookieSpec;

    /*
     * WARNING - void declaration
     */
    public DefaultCookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher, String[] datepatterns, boolean oneHeader) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.compatibilityLevel = compatibilityLevel != null ? var1_1 : CompatibilityLevel.DEFAULT;
        this.publicSuffixMatcher = var2_2;
        this.datepatterns = var3_3;
        this.oneHeader = oneHeader;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultCookieSpecProvider(CompatibilityLevel compatibilityLevel, PublicSuffixMatcher publicSuffixMatcher) {
        this((CompatibilityLevel)var1_1, (PublicSuffixMatcher)var2_2, null, false);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultCookieSpecProvider(PublicSuffixMatcher publicSuffixMatcher) {
        this(CompatibilityLevel.DEFAULT, (PublicSuffixMatcher)var1_1, null, false);
        void var1_1;
    }

    public DefaultCookieSpecProvider() {
        this(CompatibilityLevel.DEFAULT, null, null, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CookieSpec create(HttpContext context) {
        if (this.cookieSpec == null) {
            DefaultCookieSpecProvider defaultCookieSpecProvider = this;
            synchronized (defaultCookieSpecProvider) {
                if (this.cookieSpec == null) {
                    void var3_4;
                    void var2_2;
                    String[] stringArray;
                    RFC2965Spec strict = new RFC2965Spec(this.oneHeader, new RFC2965VersionAttributeHandler(), new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new RFC2965DomainAttributeHandler(), this.publicSuffixMatcher), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
                    RFC2109Spec obsoleteStrict = new RFC2109Spec(this.oneHeader, new RFC2109VersionHandler(), new BasicPathHandler(), PublicSuffixDomainFilter.decorate(new RFC2109DomainHandler(), this.publicSuffixMatcher), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler());
                    CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
                    commonCookieAttributeHandlerArray[0] = PublicSuffixDomainFilter.decorate(new BasicDomainHandler(), this.publicSuffixMatcher);
                    commonCookieAttributeHandlerArray[1] = this.compatibilityLevel == CompatibilityLevel.IE_MEDIUM_SECURITY ? new BasicPathHandler(){

                        @Override
                        public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
                        }
                    } : new BasicPathHandler();
                    commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
                    commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
                    if (this.datepatterns != null) {
                        stringArray = (String[])this.datepatterns.clone();
                    } else {
                        String[] stringArray2 = new String[1];
                        stringArray = stringArray2;
                        stringArray2[0] = "EEE, dd-MMM-yy HH:mm:ss z";
                    }
                    commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray);
                    NetscapeDraftSpec netscapeDraft = new NetscapeDraftSpec(commonCookieAttributeHandlerArray);
                    this.cookieSpec = new DefaultCookieSpec((RFC2965Spec)var2_2, (RFC2109Spec)var3_4, netscapeDraft);
                }
            }
        }
        return this.cookieSpec;
    }

    public static enum CompatibilityLevel {
        DEFAULT,
        IE_MEDIUM_SECURITY;

    }
}

