/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.List;
import org.apache.http.FormattedHeader;
import org.apache.http.Header;
import org.apache.http.HeaderElement;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.cookie.SetCookie2;
import org.apache.http.impl.cookie.BasicCommentHandler;
import org.apache.http.impl.cookie.BasicDomainHandler;
import org.apache.http.impl.cookie.BasicExpiresHandler;
import org.apache.http.impl.cookie.BasicMaxAgeHandler;
import org.apache.http.impl.cookie.BasicPathHandler;
import org.apache.http.impl.cookie.BasicSecureHandler;
import org.apache.http.impl.cookie.CookieSpecBase;
import org.apache.http.impl.cookie.NetscapeDraftHeaderParser;
import org.apache.http.impl.cookie.NetscapeDraftSpec;
import org.apache.http.impl.cookie.RFC2109DomainHandler;
import org.apache.http.impl.cookie.RFC2109Spec;
import org.apache.http.impl.cookie.RFC2109VersionHandler;
import org.apache.http.impl.cookie.RFC2965CommentUrlAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DiscardAttributeHandler;
import org.apache.http.impl.cookie.RFC2965DomainAttributeHandler;
import org.apache.http.impl.cookie.RFC2965PortAttributeHandler;
import org.apache.http.impl.cookie.RFC2965Spec;
import org.apache.http.impl.cookie.RFC2965VersionAttributeHandler;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@ThreadSafe
public class DefaultCookieSpec
implements CookieSpec {
    private final RFC2965Spec strict;
    private final RFC2109Spec obsoleteStrict;
    private final NetscapeDraftSpec netscapeDraft;

    /*
     * WARNING - void declaration
     */
    DefaultCookieSpec(RFC2965Spec strict, RFC2109Spec obsoleteStrict, NetscapeDraftSpec netscapeDraft) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.strict = var1_1;
        this.obsoleteStrict = var2_2;
        this.netscapeDraft = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultCookieSpec(String[] datepatterns, boolean oneHeader) {
        String[] stringArray;
        void var2_2;
        this.strict = new RFC2965Spec(oneHeader, new RFC2965VersionAttributeHandler(), new BasicPathHandler(), new RFC2965DomainAttributeHandler(), new RFC2965PortAttributeHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler(), new RFC2965CommentUrlAttributeHandler(), new RFC2965DiscardAttributeHandler());
        this.obsoleteStrict = new RFC2109Spec((boolean)var2_2, new RFC2109VersionHandler(), new BasicPathHandler(), new RFC2109DomainHandler(), new BasicMaxAgeHandler(), new BasicSecureHandler(), new BasicCommentHandler());
        CommonCookieAttributeHandler[] commonCookieAttributeHandlerArray = new CommonCookieAttributeHandler[5];
        commonCookieAttributeHandlerArray[0] = new BasicDomainHandler();
        commonCookieAttributeHandlerArray[1] = new BasicPathHandler();
        commonCookieAttributeHandlerArray[2] = new BasicSecureHandler();
        commonCookieAttributeHandlerArray[3] = new BasicCommentHandler();
        if (datepatterns != null) {
            void var1_1;
            stringArray = (String[])var1_1.clone();
        } else {
            String[] stringArray2 = new String[1];
            stringArray = stringArray2;
            stringArray2[0] = "EEE, dd-MMM-yy HH:mm:ss z";
        }
        commonCookieAttributeHandlerArray[4] = new BasicExpiresHandler(stringArray);
        this.netscapeDraft = new NetscapeDraftSpec(commonCookieAttributeHandlerArray);
    }

    public DefaultCookieSpec() {
        this(null, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Cookie> parse(Header header, CookieOrigin origin) throws MalformedCookieException {
        void var2_2;
        void var3_3;
        void var1_1;
        Args.notNull((Object)header, (String)"Header");
        Args.notNull((Object)origin, (String)"Cookie origin");
        HeaderElement[] helems = header.getElements();
        boolean versioned = false;
        boolean netscape = false;
        HeaderElement[] arr$ = helems;
        int len$ = helems.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HeaderElement helem = arr$[i$];
            if (helem.getParameterByName("version") != null) {
                versioned = true;
            }
            if (helem.getParameterByName("expires") == null) continue;
            netscape = true;
        }
        if (netscape || !versioned) {
            ParserCursor cursor;
            CharArrayBuffer buffer;
            NetscapeDraftHeaderParser parser = NetscapeDraftHeaderParser.DEFAULT;
            if (header instanceof FormattedHeader) {
                buffer = ((FormattedHeader)header).getBuffer();
                cursor = new ParserCursor(((FormattedHeader)header).getValuePos(), buffer.length());
            } else {
                String s = header.getValue();
                if (s == null) {
                    throw new MalformedCookieException("Header value is null");
                }
                buffer = new CharArrayBuffer(s.length());
                buffer.append(s);
                cursor = new ParserCursor(0, buffer.length());
            }
            helems = new HeaderElement[]{parser.parseHeader(buffer, cursor)};
            return this.netscapeDraft.parse(helems, origin);
        }
        if ("Set-Cookie2".equals(var1_1.getName())) {
            return this.strict.parse(helems, origin);
        }
        return this.obsoleteStrict.parse((HeaderElement[])var3_3, (CookieOrigin)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        void var2_2;
        void var1_1;
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        if (cookie.getVersion() > 0) {
            if (cookie instanceof SetCookie2) {
                ((CookieSpecBase)this.strict).validate(cookie, origin);
                return;
            }
            ((CookieSpecBase)this.obsoleteStrict).validate(cookie, origin);
            return;
        }
        this.netscapeDraft.validate((Cookie)var1_1, (CookieOrigin)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        if (cookie.getVersion() > 0) {
            if (cookie instanceof SetCookie2) {
                return ((CookieSpecBase)this.strict).match(cookie, origin);
            }
            return this.obsoleteStrict.match(cookie, origin);
        }
        return this.netscapeDraft.match((Cookie)var1_1, (CookieOrigin)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public List<Header> formatCookies(List<Cookie> cookies) {
        void var1_1;
        void var2_2;
        Args.notNull(cookies, (String)"List of cookies");
        int version = Integer.MAX_VALUE;
        boolean isSetCookie2 = true;
        for (Cookie cookie : cookies) {
            if (!(cookie instanceof SetCookie2)) {
                isSetCookie2 = false;
            }
            if (cookie.getVersion() >= version) continue;
            version = cookie.getVersion();
        }
        if (var2_2 > 0) {
            void var3_3;
            if (var3_3 != false) {
                return this.strict.formatCookies(cookies);
            }
            return this.obsoleteStrict.formatCookies(cookies);
        }
        return this.netscapeDraft.formatCookies((List<Cookie>)var1_1);
    }

    @Override
    public int getVersion() {
        return ((RFC2109Spec)this.strict).getVersion();
    }

    @Override
    public Header getVersionHeader() {
        return null;
    }

    public String toString() {
        return "default";
    }
}

