/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Locale;
import org.apache.http.HeaderElement;
import org.apache.http.NameValuePair;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.Cookie;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieOrigin;
import org.apache.http.cookie.MalformedCookieException;
import org.apache.http.impl.cookie.AbstractCookieSpec;
import org.apache.http.impl.cookie.BasicClientCookie;
import org.apache.http.util.Args;

@ThreadSafe
public abstract class CookieSpecBase
extends AbstractCookieSpec {
    public CookieSpecBase() {
    }

    /*
     * WARNING - void declaration
     */
    protected CookieSpecBase(HashMap<String, CookieAttributeHandler> map) {
        super((HashMap<String, CookieAttributeHandler>)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected CookieSpecBase(CommonCookieAttributeHandler ... handlers) {
        super((CommonCookieAttributeHandler[])var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected static String getDefaultPath(CookieOrigin origin) {
        Object object;
        Object defaultPath = origin.getPath();
        int lastSlashIndex = ((String)defaultPath).lastIndexOf(47);
        if (lastSlashIndex >= 0) {
            void var1_1;
            if (lastSlashIndex == 0) {
                lastSlashIndex = 1;
            }
            defaultPath = ((String)defaultPath).substring(0, (int)var1_1);
        }
        return object;
    }

    protected static String getDefaultDomain(CookieOrigin origin) {
        return origin.getHost();
    }

    /*
     * WARNING - void declaration
     */
    protected List<Cookie> parse(HeaderElement[] elems, CookieOrigin origin) throws MalformedCookieException {
        void var3_3;
        ArrayList<BasicClientCookie> cookies = new ArrayList<BasicClientCookie>(elems.length);
        HeaderElement[] arr$ = elems;
        int len$ = elems.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HeaderElement headerelement = arr$[i$];
            String name = headerelement.getName();
            String value = headerelement.getValue();
            if (name == null || name.isEmpty()) {
                throw new MalformedCookieException("Cookie name may not be empty");
            }
            BasicClientCookie cookie = new BasicClientCookie(name, value);
            cookie.setPath(CookieSpecBase.getDefaultPath(origin));
            cookie.setDomain(CookieSpecBase.getDefaultDomain(origin));
            NameValuePair[] attribs = headerelement.getParameters();
            for (int j = attribs.length - 1; j >= 0; --j) {
                NameValuePair attrib = attribs[j];
                String s = attrib.getName().toLowerCase(Locale.ROOT);
                cookie.setAttribute(s, attrib.getValue());
                CookieAttributeHandler handler = this.findAttribHandler(s);
                if (handler == null) continue;
                handler.parse(cookie, attrib.getValue());
            }
            cookies.add(cookie);
        }
        return var3_3;
    }

    @Override
    public void validate(Cookie cookie, CookieOrigin origin) throws MalformedCookieException {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        for (CookieAttributeHandler cookieAttributeHandler : this.getAttribHandlers()) {
            cookieAttributeHandler.validate(cookie, origin);
        }
    }

    @Override
    public boolean match(Cookie cookie, CookieOrigin origin) {
        Args.notNull((Object)cookie, (String)"Cookie");
        Args.notNull((Object)origin, (String)"Cookie origin");
        for (CookieAttributeHandler cookieAttributeHandler : this.getAttribHandlers()) {
            if (cookieAttributeHandler.match(cookie, origin)) continue;
            return false;
        }
        return true;
    }
}

