/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.io.Serializable;
import java.util.Date;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.cookie.ClientCookie;
import org.apache.http.cookie.SetCookie;
import org.apache.http.util.Args;

@NotThreadSafe
public class BasicClientCookie
implements Serializable,
Cloneable,
ClientCookie,
SetCookie {
    private static final long serialVersionUID = -3869795591041535538L;
    private final String name;
    private Map<String, String> attribs;
    private String value;
    private String cookieComment;
    private String cookieDomain;
    private Date cookieExpiryDate;
    private String cookiePath;
    private boolean isSecure;
    private int cookieVersion;
    private Date creationDate;

    /*
     * WARNING - void declaration
     */
    public BasicClientCookie(String name, String value) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)name, (String)"Name");
        this.name = var1_1;
        this.attribs = new HashMap<String, String>();
        this.value = var2_2;
    }

    @Override
    public String getName() {
        return this.name;
    }

    @Override
    public String getValue() {
        return this.value;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setValue(String value) {
        void var1_1;
        this.value = var1_1;
    }

    @Override
    public String getComment() {
        return this.cookieComment;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setComment(String comment) {
        void var1_1;
        this.cookieComment = var1_1;
    }

    @Override
    public String getCommentURL() {
        return null;
    }

    @Override
    public Date getExpiryDate() {
        return this.cookieExpiryDate;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setExpiryDate(Date expiryDate) {
        void var1_1;
        this.cookieExpiryDate = var1_1;
    }

    @Override
    public boolean isPersistent() {
        return this.cookieExpiryDate != null;
    }

    @Override
    public String getDomain() {
        return this.cookieDomain;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setDomain(String domain) {
        if (domain != null) {
            void var1_1;
            this.cookieDomain = var1_1.toLowerCase(Locale.ROOT);
            return;
        }
        this.cookieDomain = null;
    }

    @Override
    public String getPath() {
        return this.cookiePath;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setPath(String path) {
        void var1_1;
        this.cookiePath = var1_1;
    }

    @Override
    public boolean isSecure() {
        return this.isSecure;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setSecure(boolean secure) {
        void var1_1;
        this.isSecure = var1_1;
    }

    @Override
    public int[] getPorts() {
        return null;
    }

    @Override
    public int getVersion() {
        return this.cookieVersion;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setVersion(int version) {
        void var1_1;
        this.cookieVersion = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isExpired(Date date) {
        void var1_1;
        Args.notNull((Object)date, (String)"Date");
        return this.cookieExpiryDate != null && this.cookieExpiryDate.getTime() <= var1_1.getTime();
    }

    public Date getCreationDate() {
        return this.creationDate;
    }

    /*
     * WARNING - void declaration
     */
    public void setCreationDate(Date creationDate) {
        void var1_1;
        this.creationDate = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String name, String value) {
        void var2_2;
        void var1_1;
        this.attribs.put((String)var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getAttribute(String name) {
        void var1_1;
        return this.attribs.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean containsAttribute(String name) {
        void var1_1;
        return this.attribs.containsKey(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public boolean removeAttribute(String name) {
        void var1_1;
        return this.attribs.remove(var1_1) != null;
    }

    /*
     * WARNING - void declaration
     */
    public Object clone() throws CloneNotSupportedException {
        void var1_1;
        BasicClientCookie clone = (BasicClientCookie)super.clone();
        ((BasicClientCookie)super.clone()).attribs = new HashMap<String, String>(this.attribs);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder buffer = new StringBuilder();
        buffer.append("[version: ");
        buffer.append(Integer.toString(this.cookieVersion));
        buffer.append("]");
        buffer.append("[name: ");
        buffer.append(this.name);
        buffer.append("]");
        buffer.append("[value: ");
        buffer.append(this.value);
        buffer.append("]");
        buffer.append("[domain: ");
        buffer.append(this.cookieDomain);
        buffer.append("]");
        buffer.append("[path: ");
        buffer.append(this.cookiePath);
        buffer.append("]");
        buffer.append("[expiry: ");
        buffer.append(this.cookieExpiryDate);
        buffer.append("]");
        return var1_1.toString();
    }
}

