/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.cookie;

import java.util.Collection;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.cookie.CommonCookieAttributeHandler;
import org.apache.http.cookie.CookieAttributeHandler;
import org.apache.http.cookie.CookieSpec;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@ThreadSafe
public abstract class AbstractCookieSpec
implements CookieSpec {
    private final Map<String, CookieAttributeHandler> attribHandlerMap;

    public AbstractCookieSpec() {
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(10);
    }

    /*
     * WARNING - void declaration
     */
    protected AbstractCookieSpec(HashMap<String, CookieAttributeHandler> map) {
        void var1_1;
        Asserts.notNull(map, (String)"Attribute handler map");
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>((Map<String, CookieAttributeHandler>)var1_1);
    }

    protected AbstractCookieSpec(CommonCookieAttributeHandler ... handlers) {
        this.attribHandlerMap = new ConcurrentHashMap<String, CookieAttributeHandler>(handlers.length);
        CommonCookieAttributeHandler[] arr$ = handlers;
        int len$ = handlers.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            CommonCookieAttributeHandler handler = arr$[i$];
            this.attribHandlerMap.put(handler.getAttributeName(), handler);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public void registerAttribHandler(String name, CookieAttributeHandler handler) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)name, (String)"Attribute name");
        Args.notNull((Object)handler, (String)"Attribute handler");
        this.attribHandlerMap.put((String)var1_1, (CookieAttributeHandler)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    protected CookieAttributeHandler findAttribHandler(String name) {
        void var1_1;
        return this.attribHandlerMap.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected CookieAttributeHandler getAttribHandler(String name) {
        void var2_2;
        void var1_1;
        CookieAttributeHandler handler = this.findAttribHandler(name);
        Asserts.check((handler != null ? 1 : 0) != 0, (String)("Handler not registered for " + (String)var1_1 + " attribute"));
        return var2_2;
    }

    protected Collection<CookieAttributeHandler> getAttribHandlers() {
        return this.attribHandlerMap.values();
    }
}

