/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.params.ConnPerRouteBean;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPooledConnAdapter;
import org.apache.http.impl.conn.tsccm.ConnPoolByRoute;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
@ThreadSafe
public class ThreadSafeClientConnManager
implements ClientConnectionManager {
    private final Log log;
    protected final SchemeRegistry schemeRegistry;
    protected final AbstractConnPool connectionPool;
    protected final ConnPoolByRoute pool;
    protected final ClientConnectionOperator connOperator;
    protected final ConnPerRouteBean connPerRoute;

    /*
     * WARNING - void declaration
     */
    public ThreadSafeClientConnManager(SchemeRegistry schreg) {
        this((SchemeRegistry)var1_1, -1L, TimeUnit.MILLISECONDS);
        void var1_1;
    }

    public ThreadSafeClientConnManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    /*
     * WARNING - void declaration
     */
    public ThreadSafeClientConnManager(SchemeRegistry schreg, long connTTL, TimeUnit connTTLTimeUnit) {
        this((SchemeRegistry)var1_1, (long)var2_2, connTTLTimeUnit, new ConnPerRouteBean());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ThreadSafeClientConnManager(SchemeRegistry schreg, long connTTL, TimeUnit connTTLTimeUnit, ConnPerRouteBean connPerRoute) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)schreg, (String)"Scheme registry");
        this.log = LogFactory.getLog(this.getClass());
        this.schemeRegistry = schreg;
        this.connPerRoute = connPerRoute;
        this.connOperator = this.createConnectionOperator((SchemeRegistry)var1_1);
        this.pool = this.createConnectionPool((long)var2_2, connTTLTimeUnit);
        this.connectionPool = this.pool;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ThreadSafeClientConnManager(HttpParams params, SchemeRegistry schreg) {
        void var1_1;
        void var2_2;
        Args.notNull((Object)schreg, (String)"Scheme registry");
        this.log = LogFactory.getLog(this.getClass());
        this.schemeRegistry = schreg;
        this.connPerRoute = new ConnPerRouteBean();
        this.connOperator = this.createConnectionOperator((SchemeRegistry)var2_2);
        this.pool = (ConnPoolByRoute)this.createConnectionPool((HttpParams)var1_1);
        this.connectionPool = this.pool;
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected AbstractConnPool createConnectionPool(HttpParams params) {
        void var1_1;
        return new ConnPoolByRoute(this.connOperator, (HttpParams)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    protected ConnPoolByRoute createConnectionPool(long connTTL, TimeUnit connTTLTimeUnit) {
        void var3_2;
        void var1_1;
        return new ConnPoolByRoute(this.connOperator, this.connPerRoute, 20, (long)var1_1, (TimeUnit)var3_2);
    }

    /*
     * WARNING - void declaration
     */
    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        void var1_1;
        return new DefaultClientConnectionOperator((SchemeRegistry)var1_1);
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
        void var1_1;
        void var2_2;
        PoolEntryRequest poolRequest = ((AbstractConnPool)this.pool).requestPoolEntry(route, state);
        return new ClientConnectionRequest((PoolEntryRequest)var2_2, (HttpRoute)var1_1){
            final /* synthetic */ PoolEntryRequest val$poolRequest;
            final /* synthetic */ HttpRoute val$route;
            {
                this.val$poolRequest = poolEntryRequest;
                this.val$route = httpRoute;
            }

            @Override
            public void abortRequest() {
                this.val$poolRequest.abortRequest();
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                void var1_2;
                void var3_3;
                Args.notNull((Object)this.val$route, (String)"Route");
                if (ThreadSafeClientConnManager.this.log.isDebugEnabled()) {
                    ThreadSafeClientConnManager.this.log.debug((Object)("Get connection: " + this.val$route + ", timeout = " + timeout));
                }
                BasicPoolEntry entry = this.val$poolRequest.getPoolEntry(timeout, (TimeUnit)var3_3);
                return new BasicPooledConnAdapter(ThreadSafeClientConnManager.this, (AbstractPoolEntry)var1_2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
        Args.check((boolean)(conn instanceof BasicPooledConnAdapter), (String)"Connection class mismatch, connection not obtained from this manager");
        BasicPooledConnAdapter hca = (BasicPooledConnAdapter)conn;
        if (hca.getPoolEntry() != null) {
            Asserts.check((hca.getManager() == this ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
        }
        BasicPooledConnAdapter basicPooledConnAdapter = hca;
        synchronized (basicPooledConnAdapter) {
            boolean reusable;
            BasicPoolEntry entry = (BasicPoolEntry)hca.getPoolEntry();
            if (entry == null) {
                return;
            }
            try {
                if (hca.isOpen() && !hca.isMarkedReusable()) {
                    hca.shutdown();
                }
                reusable = hca.isMarkedReusable();
            }
            catch (IOException iox) {
                boolean reusable2;
                try {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Exception shutting down released connection.", (Throwable)iox);
                    }
                    reusable2 = hca.isMarkedReusable();
                }
                catch (Throwable throwable) {
                    void var2_3;
                    void var1_1;
                    boolean reusable3 = hca.isMarkedReusable();
                    if (this.log.isDebugEnabled()) {
                        if (reusable3) {
                            this.log.debug((Object)"Released connection is reusable.");
                        } else {
                            this.log.debug((Object)"Released connection is not reusable.");
                        }
                    }
                    var1_1.detach();
                    ((AbstractConnPool)this.pool).freeEntry(entry, reusable3, (long)var2_3, timeUnit);
                    throw throwable;
                }
                if (this.log.isDebugEnabled()) {
                    if (reusable2) {
                        this.log.debug((Object)"Released connection is reusable.");
                    } else {
                        this.log.debug((Object)"Released connection is not reusable.");
                    }
                }
                hca.detach();
                ((AbstractConnPool)this.pool).freeEntry(entry, reusable2, validDuration, timeUnit);
            }
            if (this.log.isDebugEnabled()) {
                if (reusable) {
                    this.log.debug((Object)"Released connection is reusable.");
                } else {
                    this.log.debug((Object)"Released connection is not reusable.");
                }
            }
            hca.detach();
            ((AbstractConnPool)this.pool).freeEntry(entry, reusable, validDuration, timeUnit);
            return;
        }
    }

    @Override
    public void shutdown() {
        this.log.debug((Object)"Shutting down");
        ((AbstractConnPool)this.pool).shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public int getConnectionsInPool(HttpRoute route) {
        void var1_1;
        return this.pool.getConnectionsInPool((HttpRoute)var1_1);
    }

    public int getConnectionsInPool() {
        return this.pool.getConnectionsInPool();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        void var3_2;
        void var1_1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + idleTimeout + " " + (Object)((Object)tunit)));
        }
        ((AbstractConnPool)this.pool).closeIdleConnections((long)var1_1, (TimeUnit)var3_2);
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        ((AbstractConnPool)this.pool).closeExpiredConnections();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotalConnections();
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxTotal(int max) {
        void var1_1;
        this.pool.setMaxTotalConnections((int)var1_1);
    }

    public int getDefaultMaxPerRoute() {
        return this.connPerRoute.getDefaultMaxPerRoute();
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultMaxPerRoute(int max) {
        void var1_1;
        this.connPerRoute.setDefaultMaxPerRoute((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getMaxForRoute(HttpRoute route) {
        void var1_1;
        return this.connPerRoute.getMaxForRoute((HttpRoute)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxForRoute(HttpRoute route, int max) {
        void var2_2;
        void var1_1;
        this.connPerRoute.setMaxForRoute((HttpRoute)var1_1, (int)var2_2);
    }
}

