/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.util.LinkedList;
import java.util.ListIterator;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.WaitingThread;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;
import org.apache.http.util.LangUtils;

@Deprecated
public class RouteSpecificPool {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final HttpRoute route;
    protected final int maxEntries;
    protected final ConnPerRoute connPerRoute;
    protected final LinkedList<BasicPoolEntry> freeEntries;
    protected final Queue<WaitingThread> waitingThreads;
    protected int numEntries;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public RouteSpecificPool(HttpRoute route, int maxEntries) {
        void var2_2;
        void var1_1;
        this.route = var1_1;
        this.maxEntries = var2_2;
        this.connPerRoute = new ConnPerRoute(){

            @Override
            public int getMaxForRoute(HttpRoute unused) {
                return RouteSpecificPool.this.maxEntries;
            }
        };
        this.freeEntries = new LinkedList();
        this.waitingThreads = new LinkedList<WaitingThread>();
        this.numEntries = 0;
    }

    /*
     * WARNING - void declaration
     */
    public RouteSpecificPool(HttpRoute route, ConnPerRoute connPerRoute) {
        void var1_1;
        void var2_2;
        this.route = route;
        this.connPerRoute = connPerRoute;
        this.maxEntries = var2_2.getMaxForRoute((HttpRoute)var1_1);
        this.freeEntries = new LinkedList();
        this.waitingThreads = new LinkedList<WaitingThread>();
        this.numEntries = 0;
    }

    public final HttpRoute getRoute() {
        return this.route;
    }

    public final int getMaxEntries() {
        return this.maxEntries;
    }

    public boolean isUnused() {
        return this.numEntries <= 0 && this.waitingThreads.isEmpty();
    }

    public int getCapacity() {
        return this.connPerRoute.getMaxForRoute(this.route) - this.numEntries;
    }

    public final int getEntryCount() {
        return this.numEntries;
    }

    /*
     * WARNING - void declaration
     */
    public BasicPoolEntry allocEntry(Object state) {
        if (!this.freeEntries.isEmpty()) {
            ListIterator<BasicPoolEntry> it = this.freeEntries.listIterator(this.freeEntries.size());
            while (it.hasPrevious()) {
                BasicPoolEntry entry = it.previous();
                if (entry.getState() != null && !LangUtils.equals((Object)state, (Object)entry.getState())) continue;
                it.remove();
                return entry;
            }
        }
        if (this.getCapacity() == 0 && !this.freeEntries.isEmpty()) {
            void var2_3;
            BasicPoolEntry entry = this.freeEntries.remove();
            entry.shutdownEntry();
            OperatedClientConnection conn = entry.getConnection();
            try {
                void var3_4;
                var3_4.close();
            }
            catch (IOException ex) {
                void var1_2;
                this.log.debug((Object)"I/O error closing connection", (Throwable)var1_2);
            }
            return var2_3;
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void freeEntry(BasicPoolEntry entry) {
        void var1_1;
        if (this.numEntries <= 0) {
            throw new IllegalStateException("No entry created for this pool. " + this.route);
        }
        if (this.numEntries <= this.freeEntries.size()) {
            throw new IllegalStateException("No entry allocated from this pool. " + this.route);
        }
        this.freeEntries.add((BasicPoolEntry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void createdEntry(BasicPoolEntry entry) {
        void var1_1;
        Args.check((boolean)this.route.equals(var1_1.getPlannedRoute()), (String)"Entry not planned for this pool");
        ++this.numEntries;
    }

    /*
     * WARNING - void declaration
     */
    public boolean deleteEntry(BasicPoolEntry entry) {
        void var1_2;
        boolean found = this.freeEntries.remove(entry);
        if (found) {
            --this.numEntries;
        }
        return (boolean)var1_2;
    }

    public void dropEntry() {
        Asserts.check((this.numEntries > 0 ? 1 : 0) != 0, (String)"There is no entry that could be dropped");
        --this.numEntries;
    }

    /*
     * WARNING - void declaration
     */
    public void queueThread(WaitingThread wt) {
        void var1_1;
        Args.notNull((Object)wt, (String)"Waiting thread");
        this.waitingThreads.add((WaitingThread)var1_1);
    }

    public boolean hasThread() {
        return !this.waitingThreads.isEmpty();
    }

    public WaitingThread nextThread() {
        return this.waitingThreads.peek();
    }

    /*
     * WARNING - void declaration
     */
    public void removeThread(WaitingThread wt) {
        void var1_1;
        if (wt == null) {
            return;
        }
        this.waitingThreads.remove(var1_1);
    }
}

