/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Map;
import java.util.Queue;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Condition;
import java.util.concurrent.locks.Lock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.params.ConnManagerParams;
import org.apache.http.conn.params.ConnPerRoute;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.tsccm.AbstractConnPool;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.impl.conn.tsccm.RouteSpecificPool;
import org.apache.http.impl.conn.tsccm.WaitingThread;
import org.apache.http.impl.conn.tsccm.WaitingThreadAborter;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
public class ConnPoolByRoute
extends AbstractConnPool {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Lock poolLock;
    protected final ClientConnectionOperator operator;
    protected final ConnPerRoute connPerRoute;
    protected final Set<BasicPoolEntry> leasedConnections;
    protected final Queue<BasicPoolEntry> freeConnections;
    protected final Queue<WaitingThread> waitingThreads;
    protected final Map<HttpRoute, RouteSpecificPool> routeToPool;
    private final long connTTL;
    private final TimeUnit connTTLTimeUnit;
    protected volatile boolean shutdown;
    protected volatile int maxTotalConnections;
    protected volatile int numConnections;

    /*
     * WARNING - void declaration
     */
    public ConnPoolByRoute(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections) {
        this((ClientConnectionOperator)var1_1, (ConnPerRoute)var2_2, (int)var3_3, -1L, TimeUnit.MILLISECONDS);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public ConnPoolByRoute(ClientConnectionOperator operator, ConnPerRoute connPerRoute, int maxTotalConnections, long connTTL, TimeUnit connTTLTimeUnit) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)operator, (String)"Connection operator");
        Args.notNull((Object)connPerRoute, (String)"Connections per route");
        this.poolLock = ((AbstractConnPool)this).poolLock;
        this.leasedConnections = ((AbstractConnPool)this).leasedConnections;
        this.operator = var1_1;
        this.connPerRoute = var2_2;
        this.maxTotalConnections = var3_3;
        this.freeConnections = this.createFreeConnQueue();
        this.waitingThreads = this.createWaitingThreadQueue();
        this.routeToPool = this.createRouteToPoolMap();
        this.connTTL = connTTL;
        this.connTTLTimeUnit = connTTLTimeUnit;
    }

    protected Lock getLock() {
        return this.poolLock;
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public ConnPoolByRoute(ClientConnectionOperator operator, HttpParams params) {
        this((ClientConnectionOperator)var1_1, ConnManagerParams.getMaxConnectionsPerRoute(params), ConnManagerParams.getMaxTotalConnections((HttpParams)var2_2));
        void var2_2;
        void var1_1;
    }

    protected Queue<BasicPoolEntry> createFreeConnQueue() {
        return new LinkedList<BasicPoolEntry>();
    }

    protected Queue<WaitingThread> createWaitingThreadQueue() {
        return new LinkedList<WaitingThread>();
    }

    protected Map<HttpRoute, RouteSpecificPool> createRouteToPoolMap() {
        return new HashMap<HttpRoute, RouteSpecificPool>();
    }

    /*
     * WARNING - void declaration
     */
    protected RouteSpecificPool newRouteSpecificPool(HttpRoute route) {
        void var1_1;
        return new RouteSpecificPool((HttpRoute)var1_1, this.connPerRoute);
    }

    /*
     * WARNING - void declaration
     */
    protected WaitingThread newWaitingThread(Condition cond, RouteSpecificPool rospl) {
        void var2_2;
        void var1_1;
        return new WaitingThread((Condition)var1_1, (RouteSpecificPool)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private void closeConnection(BasicPoolEntry entry) {
        OperatedClientConnection conn = entry.getConnection();
        if (conn != null) {
            try {
                conn.close();
                return;
            }
            catch (IOException ex) {
                void var1_2;
                this.log.debug((Object)"I/O error closing connection", (Throwable)var1_2);
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    protected RouteSpecificPool getRoutePool(HttpRoute route, boolean create) {
        void var3_4;
        this.poolLock.lock();
        try {
            void var2_3;
            RouteSpecificPool rospl = this.routeToPool.get(route);
            if (rospl == null && var2_3 != false) {
                void var1_1;
                rospl = this.newRouteSpecificPool(route);
                this.routeToPool.put((HttpRoute)var1_1, rospl);
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    public int getConnectionsInPool(HttpRoute route) {
        this.poolLock.lock();
        try {
            void var1_1;
            RouteSpecificPool rospl = this.getRoutePool(route, false);
            int n = rospl != null ? var1_1.getEntryCount() : 0;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public int getConnectionsInPool() {
        this.poolLock.lock();
        try {
            int n = this.numConnections;
            return n;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public PoolEntryRequest requestPoolEntry(HttpRoute route, Object state) {
        void var2_2;
        void var1_1;
        void var3_3;
        WaitingThreadAborter aborter = new WaitingThreadAborter();
        return new PoolEntryRequest((WaitingThreadAborter)var3_3, (HttpRoute)var1_1, var2_2){
            final /* synthetic */ WaitingThreadAborter val$aborter;
            final /* synthetic */ HttpRoute val$route;
            final /* synthetic */ Object val$state;
            {
                this.val$aborter = waitingThreadAborter;
                this.val$route = httpRoute;
                this.val$state = object;
            }

            @Override
            public void abortRequest() {
                ConnPoolByRoute.this.poolLock.lock();
                try {
                    this.val$aborter.abort();
                    return;
                }
                finally {
                    ConnPoolByRoute.this.poolLock.unlock();
                }
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public BasicPoolEntry getPoolEntry(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                void var3_2;
                void var1_1;
                return ConnPoolByRoute.this.getEntryBlocking(this.val$route, this.val$state, (long)var1_1, (TimeUnit)var3_2, this.val$aborter);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected BasicPoolEntry getEntryBlocking(HttpRoute route2, Object state, long timeout, TimeUnit tunit, WaitingThreadAborter aborter) throws ConnectionPoolTimeoutException, InterruptedException {
        void var3_6;
        Date deadline = null;
        if (timeout > 0L) {
            deadline = new Date(System.currentTimeMillis() + tunit.toMillis(timeout));
        }
        BasicPoolEntry entry = null;
        this.poolLock.lock();
        try {
            RouteSpecificPool rospl = this.getRoutePool(route2, true);
            WaitingThread waitingThread = null;
            while (entry == null) {
                boolean success;
                boolean hasCapacity;
                Asserts.check((!this.shutdown ? 1 : 0) != 0, (String)"Connection pool shut down");
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("[" + route2 + "] total kept alive: " + this.freeConnections.size() + ", total issued: " + this.leasedConnections.size() + ", total allocated: " + this.numConnections + " out of " + this.maxTotalConnections));
                }
                if ((entry = this.getFreeEntry(rospl, state)) != null) break;
                boolean bl = hasCapacity = rospl.getCapacity() > 0;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Available capacity: " + rospl.getCapacity() + " out of " + rospl.getMaxEntries() + " [" + route2 + "][" + state + "]"));
                }
                if (hasCapacity && this.numConnections < this.maxTotalConnections) {
                    entry = this.createEntry(rospl, this.operator);
                    continue;
                }
                if (hasCapacity && !this.freeConnections.isEmpty()) {
                    this.deleteLeastUsedEntry();
                    rospl = this.getRoutePool(route2, true);
                    entry = this.createEntry(rospl, this.operator);
                    continue;
                }
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Need to wait for connection [" + route2 + "][" + state + "]"));
                }
                if (waitingThread == null) {
                    ConnPoolByRoute connPoolByRoute = this;
                    waitingThread = connPoolByRoute.newWaitingThread(connPoolByRoute.poolLock.newCondition(), rospl);
                    aborter.setWaitingThread(waitingThread);
                }
                try {
                    rospl.queueThread(waitingThread);
                    this.waitingThreads.add(waitingThread);
                    success = waitingThread.await(deadline);
                    rospl.removeThread(waitingThread);
                }
                catch (Throwable route2) {
                    rospl.removeThread(waitingThread);
                    this.waitingThreads.remove(waitingThread);
                    throw route2;
                }
                this.waitingThreads.remove(waitingThread);
                if (success || deadline == null || deadline.getTime() > System.currentTimeMillis()) continue;
                throw new ConnectionPoolTimeoutException("Timeout waiting for connection from pool");
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return var3_6;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void freeEntry(BasicPoolEntry entry, boolean reusable, long validDuration, TimeUnit timeUnit) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing connection [" + route + "][" + entry.getState() + "]"));
        }
        this.poolLock.lock();
        try {
            if (this.shutdown) {
                this.closeConnection(entry);
                return;
            }
            this.leasedConnections.remove(entry);
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            if (reusable && rospl.getCapacity() >= 0) {
                void var3_5;
                if (this.log.isDebugEnabled()) {
                    void var2_4;
                    String s = validDuration > 0L ? "for " + validDuration + " " + (Object)((Object)timeUnit) : "indefinitely";
                    this.log.debug((Object)("Pooling connection [" + route + "][" + entry.getState() + "]; keep alive " + (String)var2_4));
                }
                rospl.freeEntry(entry);
                entry.updateExpiry((long)var3_5, timeUnit);
                this.freeConnections.add(entry);
            } else {
                void var1_1;
                this.closeConnection((BasicPoolEntry)var1_1);
                rospl.dropEntry();
                --this.numConnections;
            }
            this.notifyWaitingThread(rospl);
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected BasicPoolEntry getFreeEntry(RouteSpecificPool rospl, Object state) {
        void var3_4;
        BasicPoolEntry entry = null;
        this.poolLock.lock();
        try {
            boolean done = false;
            while (!done) {
                entry = rospl.allocEntry(state);
                if (entry != null) {
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("Getting free connection [" + rospl.getRoute() + "][" + state + "]"));
                    }
                    this.freeConnections.remove(entry);
                    if (entry.isExpired(System.currentTimeMillis())) {
                        if (this.log.isDebugEnabled()) {
                            this.log.debug((Object)("Closing expired free connection [" + rospl.getRoute() + "][" + state + "]"));
                        }
                        this.closeConnection(entry);
                        rospl.dropEntry();
                        --this.numConnections;
                        continue;
                    }
                    this.leasedConnections.add(entry);
                    done = true;
                    continue;
                }
                done = true;
                if (!this.log.isDebugEnabled()) continue;
                this.log.debug((Object)("No free connections [" + rospl.getRoute() + "][" + state + "]"));
            }
        }
        finally {
            this.poolLock.unlock();
        }
        return var3_4;
    }

    /*
     * WARNING - void declaration
     */
    protected BasicPoolEntry createEntry(RouteSpecificPool rospl, ClientConnectionOperator op) {
        void var2_3;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Creating new connection [" + rospl.getRoute() + "]"));
        }
        BasicPoolEntry entry = new BasicPoolEntry(op, rospl.getRoute(), this.connTTL, this.connTTLTimeUnit);
        this.poolLock.lock();
        try {
            void var1_1;
            var1_1.createdEntry(entry);
            ++this.numConnections;
            this.leasedConnections.add(entry);
        }
        finally {
            this.poolLock.unlock();
        }
        return var2_3;
    }

    /*
     * WARNING - void declaration
     */
    protected void deleteEntry(BasicPoolEntry entry) {
        HttpRoute route = entry.getPlannedRoute();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Deleting connection [" + route + "][" + entry.getState() + "]"));
        }
        this.poolLock.lock();
        try {
            void var3_4;
            void var1_1;
            this.closeConnection(entry);
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.deleteEntry((BasicPoolEntry)var1_1);
            --this.numConnections;
            if (var3_4.isUnused()) {
                void var2_3;
                this.routeToPool.remove(var2_3);
            }
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void deleteLeastUsedEntry() {
        this.poolLock.lock();
        try {
            BasicPoolEntry entry = this.freeConnections.remove();
            if (entry != null) {
                void var1_1;
                this.deleteEntry((BasicPoolEntry)var1_1);
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"No free connection to delete");
            }
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void handleLostEntry(HttpRoute route) {
        this.poolLock.lock();
        try {
            void var2_3;
            RouteSpecificPool rospl = this.getRoutePool(route, true);
            rospl.dropEntry();
            if (rospl.isUnused()) {
                void var1_1;
                this.routeToPool.remove(var1_1);
            }
            --this.numConnections;
            this.notifyWaitingThread((RouteSpecificPool)var2_3);
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void notifyWaitingThread(RouteSpecificPool rospl) {
        WaitingThread waitingThread = null;
        this.poolLock.lock();
        try {
            if (rospl != null && rospl.hasThread()) {
                void var1_1;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Notifying thread waiting on pool [" + rospl.getRoute() + "]"));
                }
                waitingThread = var1_1.nextThread();
            } else if (!this.waitingThreads.isEmpty()) {
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)"Notifying thread waiting on any pool");
                }
                waitingThread = this.waitingThreads.remove();
            } else if (this.log.isDebugEnabled()) {
                this.log.debug((Object)"Notifying no-one, there are no waiting threads");
            }
            if (waitingThread != null) {
                void var2_3;
                var2_3.wakeup();
            }
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void deleteClosedConnections() {
        this.poolLock.lock();
        try {
            Iterator iter = this.freeConnections.iterator();
            while (iter.hasNext()) {
                void var2_3;
                BasicPoolEntry entry = (BasicPoolEntry)iter.next();
                if (entry.getConnection().isOpen()) continue;
                iter.remove();
                this.deleteEntry((BasicPoolEntry)var2_3);
            }
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        void var3_4;
        long t;
        Args.notNull((Object)((Object)tunit), (String)"Time unit");
        long l = t = idletime > 0L ? idletime : 0L;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + t + " " + (Object)((Object)tunit)));
        }
        long deadline = System.currentTimeMillis() - var3_4.toMillis(t);
        this.poolLock.lock();
        try {
            Iterator iter = this.freeConnections.iterator();
            while (iter.hasNext()) {
                void var2_7;
                BasicPoolEntry entry = (BasicPoolEntry)iter.next();
                if (entry.getUpdated() > deadline) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Closing connection last used @ " + new Date(entry.getUpdated())));
                }
                iter.remove();
                this.deleteEntry((BasicPoolEntry)var2_7);
            }
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        long now = System.currentTimeMillis();
        this.poolLock.lock();
        try {
            Iterator iter = this.freeConnections.iterator();
            while (iter.hasNext()) {
                BasicPoolEntry entry = (BasicPoolEntry)iter.next();
                if (!entry.isExpired(now)) continue;
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Closing connection expired @ " + new Date(entry.getExpiry())));
                }
                iter.remove();
                this.deleteEntry(entry);
            }
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        this.poolLock.lock();
        try {
            if (this.shutdown) {
                return;
            }
            this.shutdown = true;
            Iterator<BasicPoolEntry> iter1 = this.leasedConnections.iterator();
            while (iter1.hasNext()) {
                BasicPoolEntry entry = iter1.next();
                iter1.remove();
                this.closeConnection(entry);
            }
            Iterator iter2 = this.freeConnections.iterator();
            while (iter2.hasNext()) {
                BasicPoolEntry entry = (BasicPoolEntry)iter2.next();
                iter2.remove();
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Closing connection [" + entry.getPlannedRoute() + "][" + entry.getState() + "]"));
                }
                this.closeConnection(entry);
            }
            Iterator iwth = this.waitingThreads.iterator();
            while (iwth.hasNext()) {
                void var2_3;
                WaitingThread waiter = (WaitingThread)iwth.next();
                iwth.remove();
                var2_3.wakeup();
            }
            this.routeToPool.clear();
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxTotalConnections(int max) {
        this.poolLock.lock();
        try {
            void var1_1;
            this.maxTotalConnections = var1_1;
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public int getMaxTotalConnections() {
        return this.maxTotalConnections;
    }
}

