/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn.tsccm;

import java.io.IOException;
import java.lang.ref.Reference;
import java.lang.ref.ReferenceQueue;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Set;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.locks.Lock;
import java.util.concurrent.locks.ReentrantLock;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.IdleConnectionHandler;
import org.apache.http.impl.conn.tsccm.BasicPoolEntry;
import org.apache.http.impl.conn.tsccm.BasicPoolEntryRef;
import org.apache.http.impl.conn.tsccm.PoolEntryRequest;
import org.apache.http.util.Args;

@Deprecated
public abstract class AbstractConnPool {
    private final Log log = LogFactory.getLog(this.getClass());
    protected final Lock poolLock;
    @GuardedBy(value="poolLock")
    protected Set<BasicPoolEntry> leasedConnections = new HashSet<BasicPoolEntry>();
    @GuardedBy(value="poolLock")
    protected int numConnections;
    protected volatile boolean isShutDown;
    protected Set<BasicPoolEntryRef> issuedConnections;
    protected ReferenceQueue<Object> refQueue;
    protected IdleConnectionHandler idleConnHandler = new IdleConnectionHandler();

    protected AbstractConnPool() {
        this.poolLock = new ReentrantLock();
    }

    public void enableConnectionGC() throws IllegalStateException {
    }

    /*
     * WARNING - void declaration
     */
    public final BasicPoolEntry getEntry(HttpRoute route, Object state, long timeout, TimeUnit tunit) throws ConnectionPoolTimeoutException, InterruptedException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.requestPoolEntry((HttpRoute)var1_1, var2_2).getPoolEntry((long)var3_3, tunit);
    }

    public abstract PoolEntryRequest requestPoolEntry(HttpRoute var1, Object var2);

    public abstract void freeEntry(BasicPoolEntry var1, boolean var2, long var3, TimeUnit var5);

    public void handleReference(Reference<?> ref) {
    }

    protected abstract void handleLostEntry(HttpRoute var1);

    /*
     * WARNING - void declaration
     */
    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        Args.notNull((Object)((Object)tunit), (String)"Time unit");
        this.poolLock.lock();
        try {
            void var1_1;
            void var3_3;
            this.idleConnHandler.closeIdleConnections(var3_3.toMillis((long)var1_1));
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public void closeExpiredConnections() {
        this.poolLock.lock();
        try {
            this.idleConnHandler.closeExpiredConnections();
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    public abstract void deleteClosedConnections();

    /*
     * WARNING - void declaration
     */
    public void shutdown() {
        this.poolLock.lock();
        try {
            if (this.isShutDown) {
                return;
            }
            Iterator<BasicPoolEntry> iter = this.leasedConnections.iterator();
            while (iter.hasNext()) {
                void var2_3;
                BasicPoolEntry entry = iter.next();
                iter.remove();
                this.closeConnection(var2_3.getConnection());
            }
            this.idleConnHandler.removeAll();
            this.isShutDown = true;
            return;
        }
        finally {
            this.poolLock.unlock();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void closeConnection(OperatedClientConnection conn) {
        if (conn != null) {
            try {
                conn.close();
                return;
            }
            catch (IOException ex) {
                void var1_2;
                this.log.debug((Object)"I/O error closing connection", (Throwable)var1_2);
            }
        }
    }
}

