/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.logging.Log;
import org.apache.http.annotation.Immutable;
import org.apache.http.util.Args;

@Immutable
public class Wire {
    private final Log log;
    private final String id;

    /*
     * WARNING - void declaration
     */
    public Wire(Log log, String id) {
        void var2_2;
        void var1_1;
        this.log = var1_1;
        this.id = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Wire(Log log) {
        this((Log)var1_1, "");
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private void wire(String header, InputStream instream) throws IOException {
        int ch;
        StringBuilder buffer = new StringBuilder();
        while ((ch = instream.read()) != -1) {
            if (ch == 13) {
                buffer.append("[\\r]");
                continue;
            }
            if (ch == 10) {
                buffer.append("[\\n]\"");
                buffer.insert(0, "\"");
                buffer.insert(0, header);
                this.log.debug((Object)(this.id + " " + buffer.toString()));
                buffer.setLength(0);
                continue;
            }
            if (ch < 32 || ch > 127) {
                buffer.append("[0x");
                buffer.append(Integer.toHexString(ch));
                buffer.append("]");
                continue;
            }
            buffer.append((char)ch);
        }
        if (buffer.length() > 0) {
            void var3_3;
            void var1_1;
            buffer.append('\"');
            buffer.insert(0, '\"');
            buffer.insert(0, (String)var1_1);
            this.log.debug((Object)(this.id + " " + var3_3.toString()));
        }
    }

    public boolean enabled() {
        return this.log.isDebugEnabled();
    }

    /*
     * WARNING - void declaration
     */
    public void output(InputStream outstream) throws IOException {
        void var1_1;
        Args.notNull((Object)outstream, (String)"Output");
        this.wire(">> ", (InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void input(InputStream instream) throws IOException {
        void var1_1;
        Args.notNull((Object)instream, (String)"Input");
        this.wire("<< ", (InputStream)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void output(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)b, (String)"Output");
        this.wire(">> ", new ByteArrayInputStream((byte[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void input(byte[] b, int off, int len) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)b, (String)"Input");
        this.wire("<< ", new ByteArrayInputStream((byte[])var1_1, (int)var2_2, (int)var3_3));
    }

    /*
     * WARNING - void declaration
     */
    public void output(byte[] b) throws IOException {
        void var1_1;
        Args.notNull((Object)b, (String)"Output");
        this.wire(">> ", new ByteArrayInputStream((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void input(byte[] b) throws IOException {
        void var1_1;
        Args.notNull((Object)b, (String)"Input");
        this.wire("<< ", new ByteArrayInputStream((byte[])var1_1));
    }

    /*
     * WARNING - void declaration
     */
    public void output(int b) throws IOException {
        void var1_1;
        this.output(new byte[]{(byte)var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public void input(int b) throws IOException {
        void var1_1;
        this.input(new byte[]{(byte)var1_1});
    }

    /*
     * WARNING - void declaration
     */
    public void output(String s) throws IOException {
        void var1_1;
        Args.notNull((Object)s, (String)"Output");
        this.output(var1_1.getBytes());
    }

    /*
     * WARNING - void declaration
     */
    public void input(String s) throws IOException {
        void var1_1;
        Args.notNull((Object)s, (String)"Input");
        this.input(var1_1.getBytes());
    }
}

