/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Immutable;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.impl.conn.DefaultRoutePlanner;
import org.apache.http.protocol.HttpContext;

@Immutable
public class SystemDefaultRoutePlanner
extends DefaultRoutePlanner {
    private final ProxySelector proxySelector;

    /*
     * WARNING - void declaration
     */
    public SystemDefaultRoutePlanner(SchemePortResolver schemePortResolver, ProxySelector proxySelector) {
        super((SchemePortResolver)var1_1);
        void var2_2;
        void var1_1;
        this.proxySelector = proxySelector != null ? var2_2 : ProxySelector.getDefault();
    }

    /*
     * WARNING - void declaration
     */
    public SystemDefaultRoutePlanner(ProxySelector proxySelector) {
        this(null, (ProxySelector)var1_1);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        void var2_2;
        try {
            URI targetURI = new URI(target.toURI());
        }
        catch (URISyntaxException ex) {
            throw new HttpException("Cannot convert host to URI: " + target, (Throwable)ex);
        }
        List<Proxy> proxies = this.proxySelector.select((URI)ex);
        Proxy p = this.chooseProxy(proxies);
        HttpHost result = null;
        if (p.type() == Proxy.Type.HTTP) {
            void var1_1;
            if (!(p.address() instanceof InetSocketAddress)) {
                throw new HttpException("Unable to handle non-Inet proxy address: " + p.address());
            }
            InetSocketAddress isa = (InetSocketAddress)p.address();
            result = new HttpHost(this.getHost(isa), var1_1.getPort());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    private String getHost(InetSocketAddress isa) {
        void var1_1;
        if (isa.isUnresolved()) {
            return isa.getHostName();
        }
        return var1_1.getAddress().getHostAddress();
    }

    /*
     * WARNING - void declaration
     */
    private Proxy chooseProxy(List<Proxy> proxies) {
        void var2_2;
        Proxy result = null;
        for (int i = 0; result == null && i < proxies.size(); ++i) {
            Proxy p = proxies.get(i);
            switch (p.type()) {
                case DIRECT: 
                case HTTP: {
                    result = p;
                }
            }
        }
        if (result == null) {
            result = Proxy.NO_PROXY;
        }
        return var2_2;
    }
}

