/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.AbstractPoolEntry;
import org.apache.http.impl.conn.AbstractPooledConnAdapter;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
@ThreadSafe
public class SingleClientConnManager
implements ClientConnectionManager {
    private final Log log = LogFactory.getLog(this.getClass());
    public static final String MISUSE_MESSAGE = "Invalid use of SingleClientConnManager: connection still allocated.\nMake sure to release the connection before allocating another one.";
    protected final SchemeRegistry schemeRegistry;
    protected final ClientConnectionOperator connOperator;
    protected final boolean alwaysShutDown;
    @GuardedBy(value="this")
    protected volatile PoolEntry uniquePoolEntry;
    @GuardedBy(value="this")
    protected volatile ConnAdapter managedConn;
    @GuardedBy(value="this")
    protected volatile long lastReleaseTime;
    @GuardedBy(value="this")
    protected volatile long connectionExpiresTime;
    protected volatile boolean isShutDown;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public SingleClientConnManager(HttpParams params, SchemeRegistry schreg) {
        this((SchemeRegistry)var2_2);
        void var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public SingleClientConnManager(SchemeRegistry schreg) {
        void var1_1;
        Args.notNull((Object)schreg, (String)"Scheme registry");
        this.schemeRegistry = schreg;
        this.connOperator = this.createConnectionOperator((SchemeRegistry)var1_1);
        this.uniquePoolEntry = new PoolEntry();
        this.managedConn = null;
        this.lastReleaseTime = -1L;
        this.alwaysShutDown = false;
        this.isShutDown = false;
    }

    public SingleClientConnManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    /*
     * WARNING - void declaration
     */
    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        void var1_1;
        return new DefaultClientConnectionOperator((SchemeRegistry)var1_1);
    }

    protected final void assertStillUp() throws IllegalStateException {
        Asserts.check((!this.isShutDown ? 1 : 0) != 0, (String)"Manager is shut down");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
        void var2_2;
        void var1_1;
        return new ClientConnectionRequest((HttpRoute)var1_1, var2_2){
            final /* synthetic */ HttpRoute val$route;
            final /* synthetic */ Object val$state;
            {
                this.val$route = httpRoute;
                this.val$state = object;
            }

            @Override
            public void abortRequest() {
            }

            @Override
            public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) {
                return SingleClientConnManager.this.getConnection(this.val$route, this.val$state);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    public ManagedClientConnection getConnection(HttpRoute route, Object state) {
        Args.notNull((Object)route, (String)"Route");
        this.assertStillUp();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get connection for route " + route));
        }
        SingleClientConnManager singleClientConnManager = this;
        synchronized (singleClientConnManager) {
            void var1_1;
            void var3_4;
            boolean tracker22;
            Asserts.check((this.managedConn == null ? 1 : 0) != 0, (String)MISUSE_MESSAGE);
            boolean recreate = false;
            boolean shutdown = false;
            this.closeExpiredConnections();
            if (this.uniquePoolEntry.connection.isOpen()) {
                RouteTracker tracker22 = this.uniquePoolEntry.tracker;
                tracker22 = tracker22 == null || !tracker22.toRoute().equals(route);
            } else {
                recreate = true;
            }
            if (tracker22) {
                recreate = true;
                try {
                    this.uniquePoolEntry.shutdown();
                }
                catch (IOException iox) {
                    this.log.debug((Object)"Problem shutting down connection.", (Throwable)iox);
                }
            }
            if (var3_4 != false) {
                this.uniquePoolEntry = new PoolEntry();
            }
            SingleClientConnManager singleClientConnManager2 = this;
            this.managedConn = singleClientConnManager2.new ConnAdapter(singleClientConnManager2.uniquePoolEntry, (HttpRoute)var1_1);
            return this.managedConn;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void releaseConnection(ManagedClientConnection conn, long validDuration, TimeUnit timeUnit) {
        ConnAdapter sca;
        Args.check((boolean)(conn instanceof ConnAdapter), (String)"Connection class mismatch, connection not obtained from this manager");
        this.assertStillUp();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing connection " + conn));
        }
        ConnAdapter connAdapter = sca = (ConnAdapter)conn;
        synchronized (sca) {
            ClientConnectionManager clientConnectionManager;
            block19: {
                if (sca.poolEntry == null) {
                    // ** MonitorExit[var5_8] (shouldn't be in output)
                    return;
                }
                clientConnectionManager = sca.getManager();
                Asserts.check((clientConnectionManager == this ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
                try {
                    if (!sca.isOpen() || !this.alwaysShutDown && sca.isMarkedReusable()) break block19;
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)"Released connection open but not reusable.");
                    }
                    sca.shutdown();
                }
                catch (IOException iox) {
                    block20: {
                        try {
                            if (!this.log.isDebugEnabled()) break block20;
                            this.log.debug((Object)"Exception shutting down released connection.", (Throwable)iox);
                        }
                        catch (Throwable throwable) {
                            SingleClientConnManager singleClientConnManager;
                            ((AbstractPooledConnAdapter)((Object)singleClientConnManager)).detach();
                            singleClientConnManager = this;
                            synchronized (singleClientConnManager) {
                                void var2_5;
                                this.managedConn = null;
                                this.lastReleaseTime = System.currentTimeMillis();
                                this.connectionExpiresTime = validDuration > 0L ? timeUnit.toMillis((long)var2_5) + this.lastReleaseTime : Long.MAX_VALUE;
                            }
                            throw throwable;
                        }
                    }
                    sca.detach();
                    SingleClientConnManager singleClientConnManager = this;
                    synchronized (singleClientConnManager) {
                        this.managedConn = null;
                        this.lastReleaseTime = System.currentTimeMillis();
                        this.connectionExpiresTime = validDuration > 0L ? timeUnit.toMillis(validDuration) + this.lastReleaseTime : Long.MAX_VALUE;
                    }
                }
            }
            sca.detach();
            clientConnectionManager = this;
            synchronized (clientConnectionManager) {
                this.managedConn = null;
                this.lastReleaseTime = System.currentTimeMillis();
                this.connectionExpiresTime = validDuration > 0L ? timeUnit.toMillis(validDuration) + this.lastReleaseTime : Long.MAX_VALUE;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeExpiredConnections() {
        void var1_1;
        long time = this.connectionExpiresTime;
        if (System.currentTimeMillis() >= var1_1) {
            this.closeIdleConnections(0L, TimeUnit.MILLISECONDS);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        this.assertStillUp();
        Args.notNull((Object)((Object)tunit), (String)"Time unit");
        SingleClientConnManager singleClientConnManager = this;
        synchronized (singleClientConnManager) {
            void var3_4;
            long cutoff;
            if (this.managedConn == null && this.uniquePoolEntry.connection.isOpen() && this.lastReleaseTime <= (cutoff = System.currentTimeMillis() - var3_4.toMillis(idletime))) {
                try {
                    this.uniquePoolEntry.close();
                }
                catch (IOException iox) {
                    void var1_2;
                    this.log.debug((Object)"Problem closing idle connection.", (Throwable)var1_2);
                }
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        this.isShutDown = true;
        SingleClientConnManager singleClientConnManager = this;
        synchronized (singleClientConnManager) {
            try {
                if (this.uniquePoolEntry != null) {
                    this.uniquePoolEntry.shutdown();
                }
            }
            catch (IOException iox) {
                void var2_2;
                this.log.debug((Object)"Problem while shutting down manager.", (Throwable)var2_2);
            }
            finally {
                this.uniquePoolEntry = null;
                this.managedConn = null;
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected void revokeConnection() {
        SingleClientConnManager singleClientConnManager;
        ConnAdapter conn = this.managedConn;
        if (conn == null) {
            return;
        }
        ((AbstractPooledConnAdapter)((Object)singleClientConnManager)).detach();
        singleClientConnManager = this;
        synchronized (singleClientConnManager) {
            try {
                this.uniquePoolEntry.shutdown();
            }
            catch (IOException iox) {
                void var2_2;
                this.log.debug((Object)"Problem while shutting down connection.", (Throwable)var2_2);
            }
            return;
        }
    }

    protected class ConnAdapter
    extends AbstractPooledConnAdapter {
        /*
         * WARNING - void declaration
         */
        protected ConnAdapter(PoolEntry entry, HttpRoute route) {
            void var3_3;
            super((ClientConnectionManager)SingleClientConnManager.this, entry);
            this.markReusable();
            var2_2.route = var3_3;
        }
    }

    protected class PoolEntry
    extends AbstractPoolEntry {
        protected PoolEntry() {
            super(SingleClientConnManager.this.connOperator, null);
        }

        protected void close() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.close();
            }
        }

        protected void shutdown() throws IOException {
            this.shutdownEntry();
            if (this.connection.isOpen()) {
                this.connection.shutdown();
            }
        }
    }
}

