/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.InetSocketAddress;
import java.net.Proxy;
import java.net.ProxySelector;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.params.ConnRouteParams;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
@NotThreadSafe
public class ProxySelectorRoutePlanner
implements HttpRoutePlanner {
    protected final SchemeRegistry schemeRegistry;
    protected ProxySelector proxySelector;

    /*
     * WARNING - void declaration
     */
    public ProxySelectorRoutePlanner(SchemeRegistry schreg, ProxySelector prosel) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)schreg, (String)"SchemeRegistry");
        this.schemeRegistry = var1_1;
        this.proxySelector = var2_2;
    }

    public ProxySelector getProxySelector() {
        return this.proxySelector;
    }

    /*
     * WARNING - void declaration
     */
    public void setProxySelector(ProxySelector prosel) {
        void var1_1;
        this.proxySelector = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public HttpRoute determineRoute(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        HttpRoute httpRoute;
        Args.notNull((Object)request, (String)"HTTP request");
        HttpRoute route = ConnRouteParams.getForcedRoute(request.getParams());
        if (route != null) {
            return route;
        }
        Asserts.notNull((Object)target, (String)"Target host");
        Object local = ConnRouteParams.getLocalAddress(request.getParams());
        HttpHost proxy = this.determineProxy(target, request, (HttpContext)context);
        context = this.schemeRegistry.getScheme(target.getSchemeName());
        boolean secure = context.isLayered();
        if (proxy == null) {
            local = new HttpRoute(target, (InetAddress)local, secure);
        } else {
            void var3_4;
            void var2_2;
            void var1_1;
            httpRoute = new HttpRoute((HttpHost)var1_1, (InetAddress)local, (HttpHost)var2_2, (boolean)var3_4);
        }
        return httpRoute;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpHost determineProxy(HttpHost target, HttpRequest request, HttpContext context) throws HttpException {
        void var2_2;
        void var3_3;
        URI targetURI;
        ProxySelector psel = this.proxySelector;
        if (psel == null) {
            psel = ProxySelector.getDefault();
        }
        if (psel == null) {
            return null;
        }
        try {
            targetURI = new URI(target.toURI());
        }
        catch (URISyntaxException usx) {
            throw new HttpException("Cannot convert host to URI: " + target, (Throwable)usx);
        }
        List<Proxy> proxies = usx.select(targetURI);
        Proxy p = this.chooseProxy(proxies, target, request, (HttpContext)var3_3);
        HttpHost result = null;
        if (p.type() == Proxy.Type.HTTP) {
            void var1_1;
            if (!(p.address() instanceof InetSocketAddress)) {
                throw new HttpException("Unable to handle non-Inet proxy address: " + p.address());
            }
            InetSocketAddress isa = (InetSocketAddress)p.address();
            result = new HttpHost(this.getHost(isa), var1_1.getPort());
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    protected String getHost(InetSocketAddress isa) {
        void var1_1;
        if (isa.isUnresolved()) {
            return isa.getHostName();
        }
        return var1_1.getAddress().getHostAddress();
    }

    /*
     * WARNING - void declaration
     */
    protected Proxy chooseProxy(List<Proxy> proxies, HttpHost target, HttpRequest request, HttpContext context) {
        void var2_2;
        Args.notEmpty(proxies, (String)"List of proxies");
        Proxy result = null;
        for (int i = 0; result == null && i < proxies.size(); ++i) {
            Proxy p = proxies.get(i);
            switch (p.type()) {
                case DIRECT: 
                case HTTP: {
                    result = p;
                }
            }
        }
        if (result == null) {
            result = Proxy.NO_PROXY;
        }
        return var2_2;
    }
}

