/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Map;
import java.util.Set;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.CPool;
import org.apache.http.impl.conn.CPoolEntry;
import org.apache.http.impl.conn.CPoolProxy;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.pool.ConnFactory;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@ThreadSafe
public class PoolingHttpClientConnectionManager
implements Closeable,
HttpClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final ConfigData configData = new ConfigData();
    private final CPool pool;
    private final HttpClientConnectionOperator connectionOperator;
    private final AtomicBoolean isShutDown;

    private static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
    }

    public PoolingHttpClientConnectionManager() {
        this(PoolingHttpClientConnectionManager.getDefaultRegistry());
    }

    /*
     * WARNING - void declaration
     */
    public PoolingHttpClientConnectionManager(long timeToLive, TimeUnit tunit) {
        this(PoolingHttpClientConnectionManager.getDefaultRegistry(), null, null, null, (long)var1_1, (TimeUnit)var3_2);
        void var3_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry) {
        this((Registry<ConnectionSocketFactory>)var1_1, null, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, DnsResolver dnsResolver) {
        this((Registry<ConnectionSocketFactory>)var1_1, null, (DnsResolver)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory) {
        this((Registry<ConnectionSocketFactory>)var1_1, (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)var2_2, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingHttpClientConnectionManager(HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory) {
        this(PoolingHttpClientConnectionManager.getDefaultRegistry(), (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)var1_1, null);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, DnsResolver dnsResolver) {
        this((Registry<ConnectionSocketFactory>)var1_1, (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)var2_2, null, (DnsResolver)var3_3, -1L, TimeUnit.MILLISECONDS);
        void var3_3;
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingHttpClientConnectionManager(Registry<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver, long timeToLive, TimeUnit tunit) {
        this(new DefaultHttpClientConnectionOperator((Lookup<ConnectionSocketFactory>)var1_1, (SchemePortResolver)var3_3, dnsResolver), (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)var2_2, timeToLive, tunit);
        void var2_2;
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, long timeToLive, TimeUnit tunit) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.pool = new CPool(new InternalConnectionFactory(this.configData, (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)var2_2), 2, 20, (long)var3_3, tunit);
        this.pool.setValidateAfterInactivity(2000);
        this.connectionOperator = (HttpClientConnectionOperator)Args.notNull((Object)var1_1, (String)"HttpClientConnectionOperator");
        this.isShutDown = new AtomicBoolean(false);
    }

    /*
     * WARNING - void declaration
     */
    PoolingHttpClientConnectionManager(CPool pool, Lookup<ConnectionSocketFactory> socketFactoryRegistry, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.pool = var1_1;
        this.connectionOperator = new DefaultHttpClientConnectionOperator((Lookup<ConnectionSocketFactory>)var2_2, (SchemePortResolver)var3_3, dnsResolver);
        this.isShutDown = new AtomicBoolean(false);
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    private String format(HttpRoute route, Object state) {
        void var3_3;
        void var1_1;
        StringBuilder buf = new StringBuilder();
        buf.append("[route: ").append(var1_1).append("]");
        if (state != null) {
            void var2_2;
            buf.append("[state: ").append(var2_2).append("]");
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String formatStats(HttpRoute route) {
        void var2_2;
        void var3_3;
        void var1_1;
        StringBuilder buf = new StringBuilder();
        PoolStats totals = this.pool.getTotalStats();
        PoolStats stats = this.pool.getStats(route);
        buf.append("[total kept alive: ").append(totals.getAvailable()).append("; ");
        buf.append("route allocated: ").append(stats.getLeased() + stats.getAvailable());
        buf.append(" of ").append(var1_1.getMax()).append("; ");
        buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
        buf.append(" of ").append(var3_3.getMax()).append("]");
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String format(CPoolEntry entry) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        buf.append("[id: ").append(entry.getId()).append("]");
        buf.append("[route: ").append(entry.getRoute()).append("]");
        Object state = entry.getState();
        if (state != null) {
            void var1_1;
            buf.append("[state: ").append(var1_1).append("]");
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ConnectionRequest requestConnection(HttpRoute route, Object state) {
        void var1_1;
        void var2_2;
        Args.notNull((Object)route, (String)"HTTP route");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request: " + this.format(route, state) + this.formatStats(route)));
        }
        Future future = this.pool.lease(route, var2_2, null);
        return new ConnectionRequest((Future)var1_1){
            final /* synthetic */ Future val$future;
            {
                this.val$future = future;
            }

            public boolean cancel() {
                return this.val$future.cancel(true);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public HttpClientConnection get(long timeout, TimeUnit tunit) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
                void var3_2;
                void var1_1;
                return PoolingHttpClientConnectionManager.this.leaseConnection(this.val$future, (long)var1_1, (TimeUnit)var3_2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    protected HttpClientConnection leaseConnection(Future<CPoolEntry> future, long timeout, TimeUnit tunit) throws InterruptedException, ExecutionException, ConnectionPoolTimeoutException {
        try {
            void var2_3;
            void var1_1;
            CPoolEntry entry = future.get(timeout, tunit);
            if (entry == null || var1_1.isCancelled()) {
                throw new InterruptedException();
            }
            Asserts.check((entry.getConnection() != null ? 1 : 0) != 0, (String)"Pool entry with no connection");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection leased: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
            }
            return CPoolProxy.newProxy((CPoolEntry)var2_3);
        }
        catch (TimeoutException timeoutException) {
            throw new ConnectionPoolTimeoutException("Timeout waiting for connection from pool");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void releaseConnection(HttpClientConnection managedConn, Object state, long keepalive, TimeUnit tunit) {
        Args.notNull((Object)managedConn, (String)"Managed connection");
        HttpClientConnection httpClientConnection = managedConn;
        synchronized (httpClientConnection) {
            ManagedHttpClientConnection conn;
            CPoolEntry entry;
            block8: {
                entry = CPoolProxy.detach(managedConn);
                if (entry == null) {
                    return;
                }
                conn = (ManagedHttpClientConnection)entry.getConnection();
                try {
                    void var2_3;
                    void var3_5;
                    if (!conn.isOpen()) break block8;
                    TimeUnit effectiveUnit = tunit != null ? tunit : TimeUnit.MILLISECONDS;
                    entry.setState(state);
                    entry.updateExpiry(keepalive, effectiveUnit);
                    if (!this.log.isDebugEnabled()) break block8;
                    String s = keepalive > 0L ? "for " + (double)effectiveUnit.toMillis((long)var3_5) / 1000.0 + " seconds" : "indefinitely";
                    this.log.debug((Object)("Connection " + this.format(entry) + " can be kept alive " + (String)var2_3));
                }
                catch (Throwable throwable) {
                    this.pool.release(entry, conn.isOpen() && entry.isRouteComplete());
                    if (this.log.isDebugEnabled()) {
                        void var1_1;
                        this.log.debug((Object)("Connection released: " + this.format(entry) + this.formatStats((HttpRoute)var1_1.getRoute())));
                    }
                    throw throwable;
                }
            }
            this.pool.release(entry, conn.isOpen() && entry.isRouteComplete());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection released: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void connect(HttpClientConnection managedConn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        void var2_2;
        void var3_4;
        void var1_1;
        Args.notNull((Object)managedConn, (String)"Managed Connection");
        Args.notNull((Object)route, (String)"HTTP route");
        HttpClientConnection httpClientConnection = managedConn;
        synchronized (httpClientConnection) {
            CPoolEntry cPoolEntry = CPoolProxy.getPoolEntry(managedConn);
            ManagedHttpClientConnection conn = (ManagedHttpClientConnection)cPoolEntry.getConnection();
        }
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        InetSocketAddress localAddress = route.getLocalSocketAddress();
        SocketConfig socketConfig = this.configData.getSocketConfig(host);
        if (socketConfig == null) {
            socketConfig = this.configData.getDefaultSocketConfig();
        }
        if (socketConfig == null) {
            socketConfig = SocketConfig.DEFAULT;
        }
        this.connectionOperator.connect((ManagedHttpClientConnection)var1_1, host, localAddress, (int)var3_4, (SocketConfig)var2_2, context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void upgrade(HttpClientConnection managedConn, HttpRoute route, HttpContext context) throws IOException {
        void var3_4;
        void var2_3;
        void var1_1;
        Args.notNull((Object)managedConn, (String)"Managed Connection");
        Args.notNull((Object)route, (String)"HTTP route");
        HttpClientConnection httpClientConnection = managedConn;
        synchronized (httpClientConnection) {
            managedConn = CPoolProxy.getPoolEntry(managedConn);
            ManagedHttpClientConnection conn = (ManagedHttpClientConnection)managedConn.getConnection();
        }
        this.connectionOperator.upgrade((ManagedHttpClientConnection)var1_1, var2_3.getTargetHost(), (HttpContext)var3_4);
    }

    @Override
    public void routeComplete(HttpClientConnection managedConn, HttpRoute route, HttpContext context) throws IOException {
        HttpClientConnection httpClientConnection;
        Args.notNull((Object)managedConn, (String)"Managed Connection");
        Args.notNull((Object)httpClientConnection, (String)"HTTP route");
        httpClientConnection = managedConn;
        synchronized (httpClientConnection) {
            CPoolEntry cPoolEntry;
            cPoolEntry = CPoolProxy.getPoolEntry((HttpClientConnection)cPoolEntry);
            cPoolEntry.markRouteComplete();
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        if (this.isShutDown.compareAndSet(false, true)) {
            this.log.debug((Object)"Connection manager is shutting down");
            try {
                this.pool.shutdown();
            }
            catch (IOException ex) {
                void var1_1;
                this.log.debug((Object)"I/O exception shutting down connection manager", (Throwable)var1_1);
            }
            this.log.debug((Object)"Connection manager shut down");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        void var3_2;
        void var1_1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + idleTimeout + " " + (Object)((Object)tunit)));
        }
        this.pool.closeIdle((long)var1_1, (TimeUnit)var3_2);
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpired();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxTotal(int max) {
        void var1_1;
        this.pool.setMaxTotal((int)var1_1);
    }

    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultMaxPerRoute(int max) {
        void var1_1;
        this.pool.setDefaultMaxPerRoute((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getMaxPerRoute(HttpRoute route) {
        void var1_1;
        return this.pool.getMaxPerRoute(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxPerRoute(HttpRoute route, int max) {
        void var2_2;
        void var1_1;
        this.pool.setMaxPerRoute(var1_1, (int)var2_2);
    }

    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    /*
     * WARNING - void declaration
     */
    public PoolStats getStats(HttpRoute route) {
        void var1_1;
        return this.pool.getStats(var1_1);
    }

    public Set<HttpRoute> getRoutes() {
        return this.pool.getRoutes();
    }

    public SocketConfig getDefaultSocketConfig() {
        return this.configData.getDefaultSocketConfig();
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultSocketConfig(SocketConfig defaultSocketConfig) {
        void var1_1;
        this.configData.setDefaultSocketConfig((SocketConfig)var1_1);
    }

    public ConnectionConfig getDefaultConnectionConfig() {
        return this.configData.getDefaultConnectionConfig();
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultConnectionConfig(ConnectionConfig defaultConnectionConfig) {
        void var1_1;
        this.configData.setDefaultConnectionConfig((ConnectionConfig)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public SocketConfig getSocketConfig(HttpHost host) {
        void var1_1;
        return this.configData.getSocketConfig((HttpHost)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setSocketConfig(HttpHost host, SocketConfig socketConfig) {
        void var2_2;
        void var1_1;
        this.configData.setSocketConfig((HttpHost)var1_1, (SocketConfig)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public ConnectionConfig getConnectionConfig(HttpHost host) {
        void var1_1;
        return this.configData.getConnectionConfig((HttpHost)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setConnectionConfig(HttpHost host, ConnectionConfig connectionConfig) {
        void var2_2;
        void var1_1;
        this.configData.setConnectionConfig((HttpHost)var1_1, (ConnectionConfig)var2_2);
    }

    public int getValidateAfterInactivity() {
        return this.pool.getValidateAfterInactivity();
    }

    /*
     * WARNING - void declaration
     */
    public void setValidateAfterInactivity(int ms) {
        void var1_1;
        this.pool.setValidateAfterInactivity((int)var1_1);
    }

    static class InternalConnectionFactory
    implements ConnFactory<HttpRoute, ManagedHttpClientConnection> {
        private final ConfigData configData;
        private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;

        /*
         * WARNING - void declaration
         */
        InternalConnectionFactory(ConfigData configData, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory) {
            void var2_2;
            void var1_1;
            this.configData = configData != null ? var1_1 : new ConfigData();
            this.connFactory = connFactory != null ? var2_2 : ManagedHttpClientConnectionFactory.INSTANCE;
        }

        /*
         * WARNING - void declaration
         */
        public ManagedHttpClientConnection create(HttpRoute route) throws IOException {
            void var2_2;
            void var1_1;
            ConnectionConfig config = null;
            if (route.getProxyHost() != null) {
                config = this.configData.getConnectionConfig(route.getProxyHost());
            }
            if (config == null) {
                config = this.configData.getConnectionConfig(route.getTargetHost());
            }
            if (config == null) {
                config = this.configData.getDefaultConnectionConfig();
            }
            if (config == null) {
                config = ConnectionConfig.DEFAULT;
            }
            return this.connFactory.create((HttpRoute)var1_1, (ConnectionConfig)var2_2);
        }
    }

    static class ConfigData {
        private final Map<HttpHost, SocketConfig> socketConfigMap = new ConcurrentHashMap<HttpHost, SocketConfig>();
        private final Map<HttpHost, ConnectionConfig> connectionConfigMap = new ConcurrentHashMap<HttpHost, ConnectionConfig>();
        private volatile SocketConfig defaultSocketConfig;
        private volatile ConnectionConfig defaultConnectionConfig;

        ConfigData() {
        }

        public SocketConfig getDefaultSocketConfig() {
            return this.defaultSocketConfig;
        }

        /*
         * WARNING - void declaration
         */
        public void setDefaultSocketConfig(SocketConfig defaultSocketConfig) {
            void var1_1;
            this.defaultSocketConfig = var1_1;
        }

        public ConnectionConfig getDefaultConnectionConfig() {
            return this.defaultConnectionConfig;
        }

        /*
         * WARNING - void declaration
         */
        public void setDefaultConnectionConfig(ConnectionConfig defaultConnectionConfig) {
            void var1_1;
            this.defaultConnectionConfig = var1_1;
        }

        /*
         * WARNING - void declaration
         */
        public SocketConfig getSocketConfig(HttpHost host) {
            void var1_1;
            return this.socketConfigMap.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setSocketConfig(HttpHost host, SocketConfig socketConfig) {
            void var2_2;
            void var1_1;
            this.socketConfigMap.put((HttpHost)var1_1, (SocketConfig)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        public ConnectionConfig getConnectionConfig(HttpHost host) {
            void var1_1;
            return this.connectionConfigMap.get(var1_1);
        }

        /*
         * WARNING - void declaration
         */
        public void setConnectionConfig(HttpHost host, ConnectionConfig connectionConfig) {
            void var2_2;
            void var1_1;
            this.connectionConfigMap.put((HttpHost)var1_1, (ConnectionConfig)var2_2);
        }
    }
}

