/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ConnectionPoolTimeoutException;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.HttpConnPool;
import org.apache.http.impl.conn.HttpPoolEntry;
import org.apache.http.impl.conn.ManagedClientConnectionImpl;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.conn.SystemDefaultDnsResolver;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.pool.PoolStats;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
@ThreadSafe
public class PoolingClientConnectionManager
implements ClientConnectionManager,
ConnPoolControl<HttpRoute> {
    private final Log log = LogFactory.getLog(this.getClass());
    private final SchemeRegistry schemeRegistry;
    private final HttpConnPool pool;
    private final ClientConnectionOperator operator;
    private final DnsResolver dnsResolver;

    /*
     * WARNING - void declaration
     */
    public PoolingClientConnectionManager(SchemeRegistry schreg) {
        this((SchemeRegistry)var1_1, -1L, TimeUnit.MILLISECONDS);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingClientConnectionManager(SchemeRegistry schreg, DnsResolver dnsResolver) {
        this((SchemeRegistry)var1_1, -1L, TimeUnit.MILLISECONDS, (DnsResolver)var2_2);
        void var2_2;
        void var1_1;
    }

    public PoolingClientConnectionManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    /*
     * WARNING - void declaration
     */
    public PoolingClientConnectionManager(SchemeRegistry schemeRegistry, long timeToLive, TimeUnit tunit) {
        this((SchemeRegistry)var1_1, (long)var2_2, tunit, new SystemDefaultDnsResolver());
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public PoolingClientConnectionManager(SchemeRegistry schemeRegistry, long timeToLive, TimeUnit tunit, DnsResolver dnsResolver) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)schemeRegistry, (String)"Scheme registry");
        Args.notNull((Object)dnsResolver, (String)"DNS resolver");
        this.schemeRegistry = schemeRegistry;
        this.dnsResolver = dnsResolver;
        this.operator = this.createConnectionOperator((SchemeRegistry)var1_1);
        this.pool = new HttpConnPool(this.log, this.operator, 2, 20, (long)var2_2, tunit);
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
            return;
        }
        finally {
            super.finalize();
        }
    }

    /*
     * WARNING - void declaration
     */
    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        void var1_1;
        return new DefaultClientConnectionOperator((SchemeRegistry)var1_1, this.dnsResolver);
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    /*
     * WARNING - void declaration
     */
    private String format(HttpRoute route, Object state) {
        void var3_3;
        void var1_1;
        StringBuilder buf = new StringBuilder();
        buf.append("[route: ").append(var1_1).append("]");
        if (state != null) {
            void var2_2;
            buf.append("[state: ").append(var2_2).append("]");
        }
        return var3_3.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String formatStats(HttpRoute route) {
        void var2_2;
        void var3_3;
        void var1_1;
        StringBuilder buf = new StringBuilder();
        PoolStats totals = this.pool.getTotalStats();
        PoolStats stats = this.pool.getStats(route);
        buf.append("[total kept alive: ").append(totals.getAvailable()).append("; ");
        buf.append("route allocated: ").append(stats.getLeased() + stats.getAvailable());
        buf.append(" of ").append(var1_1.getMax()).append("; ");
        buf.append("total allocated: ").append(totals.getLeased() + totals.getAvailable());
        buf.append(" of ").append(var3_3.getMax()).append("]");
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    private String format(HttpPoolEntry entry) {
        void var2_2;
        StringBuilder buf = new StringBuilder();
        buf.append("[id: ").append(entry.getId()).append("]");
        buf.append("[route: ").append(entry.getRoute()).append("]");
        Object state = entry.getState();
        if (state != null) {
            void var1_1;
            buf.append("[state: ").append(var1_1).append("]");
        }
        return var2_2.toString();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
        void var1_1;
        void var2_2;
        Args.notNull((Object)route, (String)"HTTP route");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection request: " + this.format(route, state) + this.formatStats(route)));
        }
        Future future = this.pool.lease(route, var2_2);
        return new ClientConnectionRequest((Future)var1_1){
            final /* synthetic */ Future val$future;
            {
                this.val$future = future;
            }

            @Override
            public void abortRequest() {
                this.val$future.cancel(true);
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
                void var3_2;
                void var1_1;
                return PoolingClientConnectionManager.this.leaseConnection(this.val$future, (long)var1_1, (TimeUnit)var3_2);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    ManagedClientConnection leaseConnection(Future<HttpPoolEntry> future, long timeout, TimeUnit tunit) throws InterruptedException, ConnectionPoolTimeoutException {
        try {
            HttpPoolEntry entry = future.get(timeout, tunit);
            if (entry == null || future.isCancelled()) {
                throw new InterruptedException();
            }
            Asserts.check((entry.getConnection() != null ? 1 : 0) != 0, (String)"Pool entry with no connection");
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection leased: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
            }
            PoolingClientConnectionManager poolingClientConnectionManager = this;
            return new ManagedClientConnectionImpl(poolingClientConnectionManager, poolingClientConnectionManager.operator, entry);
        }
        catch (ExecutionException executionException) {
            void var2_4;
            ExecutionException ex = executionException;
            Throwable cause = executionException.getCause();
            if (cause == null) {
                void var1_1;
                cause = var1_1;
            }
            this.log.error((Object)"Unexpected exception leasing connection from pool", (Throwable)var2_4);
            throw new InterruptedException();
        }
        catch (TimeoutException timeoutException) {
            throw new ConnectionPoolTimeoutException("Timeout waiting for connection from pool");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void releaseConnection(ManagedClientConnection conn, long keepalive, TimeUnit tunit) {
        Args.check((boolean)(conn instanceof ManagedClientConnectionImpl), (String)"Connection class mismatch, connection not obtained from this manager");
        ManagedClientConnectionImpl managedConn = (ManagedClientConnectionImpl)conn;
        Asserts.check((managedConn.getManager() == this ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
        ManagedClientConnectionImpl managedClientConnectionImpl = managedConn;
        synchronized (managedClientConnectionImpl) {
            HttpPoolEntry entry;
            block12: {
                entry = managedConn.detach();
                if (entry == null) {
                    return;
                }
                try {
                    block11: {
                        if (managedConn.isOpen() && !managedConn.isMarkedReusable()) {
                            try {
                                managedConn.shutdown();
                            }
                            catch (IOException iox) {
                                if (!this.log.isDebugEnabled()) break block11;
                                this.log.debug((Object)"I/O exception shutting down released connection", (Throwable)iox);
                            }
                        }
                    }
                    if (!managedConn.isMarkedReusable()) break block12;
                    entry.updateExpiry(keepalive, tunit != null ? tunit : TimeUnit.MILLISECONDS);
                    if (this.log.isDebugEnabled()) {
                        void var2_3;
                        String s = keepalive > 0L ? "for " + (long)var2_3 + " " + (Object)((Object)tunit) : "indefinitely";
                        this.log.debug((Object)("Connection " + this.format(entry) + " can be kept alive " + s));
                    }
                }
                catch (Throwable throwable) {
                    void var1_1;
                    this.pool.release(entry, var1_1.isMarkedReusable());
                    throw throwable;
                }
            }
            this.pool.release(entry, managedConn.isMarkedReusable());
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection released: " + this.format(entry) + this.formatStats((HttpRoute)entry.getRoute())));
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void shutdown() {
        this.log.debug((Object)"Connection manager is shutting down");
        try {
            this.pool.shutdown();
        }
        catch (IOException ex) {
            void var1_1;
            this.log.debug((Object)"I/O exception shutting down connection manager", (Throwable)var1_1);
        }
        this.log.debug((Object)"Connection manager shut down");
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeIdleConnections(long idleTimeout, TimeUnit tunit) {
        void var3_2;
        void var1_1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Closing connections idle longer than " + idleTimeout + " " + (Object)((Object)tunit)));
        }
        this.pool.closeIdle((long)var1_1, (TimeUnit)var3_2);
    }

    @Override
    public void closeExpiredConnections() {
        this.log.debug((Object)"Closing expired connections");
        this.pool.closeExpired();
    }

    public int getMaxTotal() {
        return this.pool.getMaxTotal();
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxTotal(int max) {
        void var1_1;
        this.pool.setMaxTotal((int)var1_1);
    }

    public int getDefaultMaxPerRoute() {
        return this.pool.getDefaultMaxPerRoute();
    }

    /*
     * WARNING - void declaration
     */
    public void setDefaultMaxPerRoute(int max) {
        void var1_1;
        this.pool.setDefaultMaxPerRoute((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getMaxPerRoute(HttpRoute route) {
        void var1_1;
        return this.pool.getMaxPerRoute(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setMaxPerRoute(HttpRoute route, int max) {
        void var2_2;
        void var1_1;
        this.pool.setMaxPerRoute(var1_1, (int)var2_2);
    }

    public PoolStats getTotalStats() {
        return this.pool.getTotalStats();
    }

    /*
     * WARNING - void declaration
     */
    public PoolStats getStats(HttpRoute route) {
        void var1_1;
        return this.pool.getStats(var1_1);
    }
}

