/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.RouteTracker;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.impl.conn.HttpPoolEntry;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
@NotThreadSafe
class ManagedClientConnectionImpl
implements ManagedClientConnection {
    private final ClientConnectionManager manager;
    private final ClientConnectionOperator operator;
    private volatile HttpPoolEntry poolEntry;
    private volatile boolean reusable;
    private volatile long duration;

    /*
     * WARNING - void declaration
     */
    ManagedClientConnectionImpl(ClientConnectionManager manager, ClientConnectionOperator operator, HttpPoolEntry entry) {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)manager, (String)"Connection manager");
        Args.notNull((Object)operator, (String)"Connection operator");
        Args.notNull((Object)((Object)entry), (String)"HTTP pool entry");
        this.manager = var1_1;
        this.operator = var2_2;
        this.poolEntry = var3_3;
        this.reusable = false;
        this.duration = Long.MAX_VALUE;
    }

    @Override
    public String getId() {
        return null;
    }

    HttpPoolEntry getPoolEntry() {
        return this.poolEntry;
    }

    /*
     * WARNING - void declaration
     */
    HttpPoolEntry detach() {
        void var1_1;
        HttpPoolEntry local = this.poolEntry;
        this.poolEntry = null;
        return var1_1;
    }

    public ClientConnectionManager getManager() {
        return this.manager;
    }

    /*
     * WARNING - void declaration
     */
    private OperatedClientConnection getConnection() {
        void var1_1;
        HttpPoolEntry local = this.poolEntry;
        if (local == null) {
            return null;
        }
        return (OperatedClientConnection)var1_1.getConnection();
    }

    /*
     * WARNING - void declaration
     */
    private OperatedClientConnection ensureConnection() {
        void var1_1;
        HttpPoolEntry local = this.poolEntry;
        if (local == null) {
            throw new ConnectionShutdownException();
        }
        return (OperatedClientConnection)var1_1.getConnection();
    }

    /*
     * WARNING - void declaration
     */
    private HttpPoolEntry ensurePoolEntry() {
        void var1_1;
        HttpPoolEntry local = this.poolEntry;
        if (local == null) {
            throw new ConnectionShutdownException();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws IOException {
        HttpPoolEntry local = this.poolEntry;
        if (local != null) {
            void var2_2;
            void var1_1;
            OperatedClientConnection conn = (OperatedClientConnection)local.getConnection();
            var1_1.getTracker().reset();
            var2_2.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void shutdown() throws IOException {
        HttpPoolEntry local = this.poolEntry;
        if (local != null) {
            void var2_2;
            void var1_1;
            OperatedClientConnection conn = (OperatedClientConnection)local.getConnection();
            var1_1.getTracker().reset();
            var2_2.shutdown();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isOpen() {
        OperatedClientConnection conn = this.getConnection();
        if (conn != null) {
            void var1_1;
            return var1_1.isOpen();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isStale() {
        OperatedClientConnection conn = this.getConnection();
        if (conn != null) {
            void var1_1;
            return var1_1.isStale();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setSocketTimeout(int timeout) {
        void var1_1;
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        operatedClientConnection.setSocketTimeout((int)var1_1);
    }

    public int getSocketTimeout() {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.getSocketTimeout();
    }

    public HttpConnectionMetrics getMetrics() {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.getMetrics();
    }

    public void flush() throws IOException {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        operatedClientConnection.flush();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isResponseAvailable(int timeout) throws IOException {
        void var1_1;
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.isResponseAvailable((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        void var1_1;
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        operatedClientConnection.receiveResponseEntity((HttpResponse)var1_1);
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.receiveResponseHeader();
    }

    /*
     * WARNING - void declaration
     */
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        void var1_1;
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        operatedClientConnection.sendRequestEntity((HttpEntityEnclosingRequest)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        void var1_1;
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        operatedClientConnection.sendRequestHeader((HttpRequest)var1_1);
    }

    public InetAddress getLocalAddress() {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.getLocalAddress();
    }

    public int getLocalPort() {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.getRemoteAddress();
    }

    public int getRemotePort() {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.getRemotePort();
    }

    @Override
    public boolean isSecure() {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.isSecure();
    }

    @Override
    public void bind(Socket socket) throws IOException {
        throw new UnsupportedOperationException();
    }

    @Override
    public Socket getSocket() {
        OperatedClientConnection operatedClientConnection = this.ensureConnection();
        return operatedClientConnection.getSocket();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLSession getSSLSession() {
        void var2_2;
        OperatedClientConnection conn = this.ensureConnection();
        SSLSession result = null;
        Socket sock = conn.getSocket();
        if (sock instanceof SSLSocket) {
            void var1_1;
            result = ((SSLSocket)var1_1).getSession();
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String id) {
        OperatedClientConnection conn = this.ensureConnection();
        if (conn instanceof HttpContext) {
            void var1_1;
            void var2_2;
            return ((HttpContext)var2_2).getAttribute((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object removeAttribute(String id) {
        OperatedClientConnection conn = this.ensureConnection();
        if (conn instanceof HttpContext) {
            void var1_1;
            void var2_2;
            return ((HttpContext)var2_2).removeAttribute((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String id, Object obj) {
        OperatedClientConnection conn = this.ensureConnection();
        if (conn instanceof HttpContext) {
            void var2_2;
            void var1_1;
            void var3_3;
            ((HttpContext)var3_3).setAttribute((String)var1_1, (Object)var2_2);
        }
    }

    @Override
    public HttpRoute getRoute() {
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        return httpPoolEntry.getEffectiveRoute();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void open(HttpRoute route, HttpContext context, HttpParams params) throws IOException {
        void var3_5;
        void var2_4;
        OperatedClientConnection conn;
        Args.notNull((Object)route, (String)"Route");
        Args.notNull((Object)params, (String)"HTTP parameters");
        ManagedClientConnectionImpl managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            if (this.poolEntry == null) {
                throw new ConnectionShutdownException();
            }
            RouteTracker tracker = this.poolEntry.getTracker();
            Asserts.notNull((Object)tracker, (String)"Route tracker");
            Asserts.check((!tracker.isConnected() ? 1 : 0) != 0, (String)"Connection already open");
            conn = (OperatedClientConnection)this.poolEntry.getConnection();
        }
        HttpHost proxy = route.getProxyHost();
        this.operator.openConnection(conn, proxy != null ? proxy : route.getTargetHost(), route.getLocalAddress(), (HttpContext)var2_4, (HttpParams)var3_5);
        ManagedClientConnectionImpl managedClientConnectionImpl2 = this;
        synchronized (managedClientConnectionImpl2) {
            if (this.poolEntry == null) {
                throw new InterruptedIOException();
            }
            RouteTracker tracker = this.poolEntry.getTracker();
            if (proxy == null) {
                tracker.connectTarget(conn.isSecure());
            } else {
                void var1_1;
                var1_1.connectProxy(proxy, conn.isSecure());
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tunnelTarget(boolean secure, HttpParams params) throws IOException {
        void var2_4;
        RouteTracker routeTracker;
        OperatedClientConnection conn;
        Args.notNull((Object)params, (String)"HTTP parameters");
        ManagedClientConnectionImpl managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            if (this.poolEntry == null) {
                throw new ConnectionShutdownException();
            }
            RouteTracker tracker = this.poolEntry.getTracker();
            Asserts.notNull((Object)tracker, (String)"Route tracker");
            Asserts.check((boolean)tracker.isConnected(), (String)"Connection not open");
            Asserts.check((!tracker.isTunnelled() ? 1 : 0) != 0, (String)"Connection is already tunnelled");
            HttpHost target = tracker.getTargetHost();
            conn = (OperatedClientConnection)this.poolEntry.getConnection();
        }
        conn.update(null, (HttpHost)routeTracker, secure, (HttpParams)var2_4);
        managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            void var1_1;
            if (this.poolEntry == null) {
                throw new InterruptedIOException();
            }
            routeTracker = this.poolEntry.getTracker();
            routeTracker.tunnelTarget((boolean)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void tunnelProxy(HttpHost next, boolean secure, HttpParams params) throws IOException {
        void var3_5;
        OperatedClientConnection conn;
        Args.notNull((Object)next, (String)"Next proxy");
        Args.notNull((Object)params, (String)"HTTP parameters");
        ManagedClientConnectionImpl managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            if (this.poolEntry == null) {
                throw new ConnectionShutdownException();
            }
            RouteTracker tracker = this.poolEntry.getTracker();
            Asserts.notNull((Object)tracker, (String)"Route tracker");
            Asserts.check((boolean)tracker.isConnected(), (String)"Connection not open");
            conn = (OperatedClientConnection)this.poolEntry.getConnection();
        }
        conn.update(null, next, secure, (HttpParams)var3_5);
        managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            void var2_4;
            void var1_1;
            if (this.poolEntry == null) {
                throw new InterruptedIOException();
            }
            RouteTracker routeTracker = this.poolEntry.getTracker();
            routeTracker.tunnelProxy((HttpHost)var1_1, (boolean)var2_4);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void layerProtocol(HttpContext context, HttpParams params) throws IOException {
        void var2_4;
        void var1_1;
        RouteTracker routeTracker;
        OperatedClientConnection conn;
        Args.notNull((Object)params, (String)"HTTP parameters");
        ManagedClientConnectionImpl managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            if (this.poolEntry == null) {
                throw new ConnectionShutdownException();
            }
            RouteTracker tracker = this.poolEntry.getTracker();
            Asserts.notNull((Object)tracker, (String)"Route tracker");
            Asserts.check((boolean)tracker.isConnected(), (String)"Connection not open");
            Asserts.check((boolean)tracker.isTunnelled(), (String)"Protocol layering without a tunnel not supported");
            Asserts.check((!tracker.isLayered() ? 1 : 0) != 0, (String)"Multiple protocol layering not supported");
            HttpHost target = tracker.getTargetHost();
            conn = (OperatedClientConnection)this.poolEntry.getConnection();
        }
        this.operator.updateSecureConnection(conn, (HttpHost)routeTracker, (HttpContext)var1_1, (HttpParams)var2_4);
        managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            if (this.poolEntry == null) {
                throw new InterruptedIOException();
            }
            routeTracker = this.poolEntry.getTracker();
            routeTracker.layerProtocol(conn.isSecure());
            return;
        }
    }

    @Override
    public Object getState() {
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        return httpPoolEntry.getState();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setState(Object state) {
        void var1_1;
        HttpPoolEntry httpPoolEntry = this.ensurePoolEntry();
        httpPoolEntry.setState(var1_1);
    }

    @Override
    public void markReusable() {
        this.reusable = true;
    }

    @Override
    public void unmarkReusable() {
        this.reusable = false;
    }

    @Override
    public boolean isMarkedReusable() {
        return this.reusable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setIdleDuration(long duration, TimeUnit unit) {
        if (duration > 0L) {
            void var1_1;
            void var3_2;
            this.duration = var3_2.toMillis((long)var1_1);
            return;
        }
        this.duration = -1L;
    }

    @Override
    public void releaseConnection() {
        ManagedClientConnectionImpl managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            if (this.poolEntry == null) {
                return;
            }
            ManagedClientConnectionImpl managedClientConnectionImpl2 = this;
            this.manager.releaseConnection(managedClientConnectionImpl2, managedClientConnectionImpl2.duration, TimeUnit.MILLISECONDS);
            this.poolEntry = null;
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void abortConnection() {
        ManagedClientConnectionImpl managedClientConnectionImpl = this;
        synchronized (managedClientConnectionImpl) {
            if (this.poolEntry == null) {
                return;
            }
            this.reusable = false;
            OperatedClientConnection conn = (OperatedClientConnection)this.poolEntry.getConnection();
            try {
                void var2_2;
                var2_2.shutdown();
            }
            catch (IOException iOException) {}
            ManagedClientConnectionImpl managedClientConnectionImpl2 = this;
            this.manager.releaseConnection(managedClientConnectionImpl2, managedClientConnectionImpl2.duration, TimeUnit.MILLISECONDS);
            this.poolEntry = null;
            return;
        }
    }
}

