/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import org.apache.commons.logging.Log;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.conn.DefaultManagedHttpClientConnection;
import org.apache.http.impl.conn.LoggingInputStream;
import org.apache.http.impl.conn.LoggingOutputStream;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;

@NotThreadSafe
class LoggingManagedHttpClientConnection
extends DefaultManagedHttpClientConnection {
    private final Log log;
    private final Log headerlog;
    private final Wire wire;

    /*
     * WARNING - void declaration
     */
    public LoggingManagedHttpClientConnection(String id, Log log, Log headerlog, Log wirelog, int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super(id, buffersize, fragmentSizeHint, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        void var1_1;
        void var3_3;
        void var2_2;
        this.log = var2_2;
        this.headerlog = var3_3;
        this.wire = new Wire(wirelog, (String)var1_1);
    }

    public void close() throws IOException {
        if (super.isOpen()) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)(this.getId() + ": Close connection"));
            }
            super.close();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void setSocketTimeout(int timeout) {
        void var1_1;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getId() + ": set socket timeout to " + timeout));
        }
        super.setSocketTimeout((int)var1_1);
    }

    @Override
    public void shutdown() throws IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)(this.getId() + ": Shutdown connection"));
        }
        super.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    protected InputStream getSocketInputStream(Socket socket) throws IOException {
        void var1_1;
        InputStream in = super.getSocketInputStream(socket);
        if (this.wire.enabled()) {
            in = new LoggingInputStream(in, this.wire);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected OutputStream getSocketOutputStream(Socket socket) throws IOException {
        void var1_1;
        OutputStream out = super.getSocketOutputStream(socket);
        if (this.wire.enabled()) {
            out = new LoggingOutputStream(out, this.wire);
        }
        return var1_1;
    }

    protected void onResponseReceived(HttpResponse response) {
        if (response != null && this.headerlog.isDebugEnabled()) {
            this.headerlog.debug((Object)(this.getId() + " << " + response.getStatusLine().toString()));
            Header[] arr$ = response = response.getAllHeaders();
            int len$ = response.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Header header = arr$[i$];
                this.headerlog.debug((Object)(this.getId() + " << " + header.toString()));
            }
        }
    }

    protected void onRequestSubmitted(HttpRequest request) {
        if (request != null && this.headerlog.isDebugEnabled()) {
            this.headerlog.debug((Object)(this.getId() + " >> " + request.getRequestLine().toString()));
            Header[] arr$ = request = request.getAllHeaders();
            int len$ = request.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Header header = arr$[i$];
                this.headerlog.debug((Object)(this.getId() + " >> " + header.toString()));
            }
        }
    }
}

