/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InputStream;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.conn.Wire;

@NotThreadSafe
class LoggingInputStream
extends InputStream {
    private final InputStream in;
    private final Wire wire;

    /*
     * WARNING - void declaration
     */
    public LoggingInputStream(InputStream in, Wire wire) {
        void var2_2;
        void var1_1;
        this.in = var1_1;
        this.wire = var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read() throws IOException {
        try {
            int b = this.in.read();
            if (b == -1) {
                this.wire.input("end of stream");
            } else {
                this.wire.input(b);
            }
            return b;
        }
        catch (IOException ex) {
            void var1_2;
            this.wire.input("[read] I/O error: " + ex.getMessage());
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b) throws IOException {
        try {
            int bytesRead = this.in.read(b);
            if (bytesRead == -1) {
                this.wire.input("end of stream");
            } else if (bytesRead > 0) {
                void var1_1;
                this.wire.input((byte[])var1_1, 0, bytesRead);
            }
            return bytesRead;
        }
        catch (IOException ex) {
            void var2_3;
            this.wire.input("[read] I/O error: " + ex.getMessage());
            throw var2_3;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        try {
            int bytesRead = this.in.read(b, off, len);
            if (bytesRead == -1) {
                this.wire.input("end of stream");
            } else if (bytesRead > 0) {
                void var2_2;
                void var1_1;
                this.wire.input((byte[])var1_1, (int)var2_2, bytesRead);
            }
            return bytesRead;
        }
        catch (IOException ex) {
            void var3_4;
            this.wire.input("[read] I/O error: " + ex.getMessage());
            throw var3_4;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public long skip(long n) throws IOException {
        try {
            return super.skip(n);
        }
        catch (IOException ex) {
            void var1_2;
            this.wire.input("[skip] I/O error: " + ex.getMessage());
            throw var1_2;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public int available() throws IOException {
        try {
            return this.in.available();
        }
        catch (IOException ex) {
            void var1_1;
            this.wire.input("[available] I/O error : " + ex.getMessage());
            throw var1_1;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void mark(int readlimit) {
        void var1_1;
        super.mark((int)var1_1);
    }

    @Override
    public void reset() throws IOException {
        super.reset();
    }

    @Override
    public boolean markSupported() {
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void close() throws IOException {
        try {
            this.in.close();
            return;
        }
        catch (IOException ex) {
            void var1_1;
            this.wire.input("[close] I/O error: " + ex.getMessage());
            throw var1_1;
        }
    }
}

