/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.net.InetAddress;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.conn.DnsResolver;
import org.apache.http.util.Args;

public class InMemoryDnsResolver
implements DnsResolver {
    private final Log log = LogFactory.getLog(InMemoryDnsResolver.class);
    private final Map<String, InetAddress[]> dnsMap = new ConcurrentHashMap<String, InetAddress[]>();

    /*
     * WARNING - void declaration
     */
    public void add(String host, InetAddress ... ips) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)host, (String)"Host name");
        Args.notNull((Object)ips, (String)"Array of IP addresses");
        this.dnsMap.put((String)var1_1, (InetAddress[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public InetAddress[] resolve(String host) throws UnknownHostException {
        void var2_2;
        Object[] resolvedAddresses = this.dnsMap.get(host);
        if (this.log.isInfoEnabled()) {
            this.log.info((Object)("Resolving " + host + " to " + Arrays.deepToString(resolvedAddresses)));
        }
        if (resolvedAddresses == null) {
            void var1_1;
            throw new UnknownHostException((String)var1_1 + " cannot be resolved");
        }
        return var2_2;
    }
}

