/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpConnection;

@Deprecated
public class IdleConnectionHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<HttpConnection, TimeValues> connectionToTimes = new HashMap<HttpConnection, TimeValues>();

    /*
     * WARNING - void declaration
     */
    public void add(HttpConnection connection, long validDuration, TimeUnit unit) {
        void var2_2;
        void var1_1;
        long timeAdded = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Adding connection at: " + timeAdded));
        }
        this.connectionToTimes.put((HttpConnection)var1_1, new TimeValues(timeAdded, (long)var2_2, unit));
    }

    /*
     * WARNING - void declaration
     */
    public boolean remove(HttpConnection connection) {
        void var1_1;
        TimeValues times = this.connectionToTimes.remove(connection);
        if (times == null) {
            this.log.warn((Object)"Removing a connection that never existed!");
            return true;
        }
        return System.currentTimeMillis() <= ((TimeValues)var1_1).timeExpires;
    }

    public void removeAll() {
        this.connectionToTimes.clear();
    }

    public void closeIdleConnections(long idleTime) {
        long idleTimeout = System.currentTimeMillis() - idleTime;
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking for connections, idle timeout: " + idleTimeout));
        }
        for (Map.Entry<HttpConnection, TimeValues> entry : this.connectionToTimes.entrySet()) {
            HttpConnection conn = entry.getKey();
            TimeValues timeValues = entry.getValue();
            long connectionTime = timeValues.timeAdded;
            if (connectionTime > idleTimeout) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Closing idle connection, connection time: " + connectionTime));
            }
            try {
                conn.close();
            }
            catch (IOException iOException) {
                this.log.debug((Object)"I/O error closing connection", (Throwable)iOException);
            }
        }
    }

    public void closeExpiredConnections() {
        long now = System.currentTimeMillis();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Checking for expired connections, now: " + now));
        }
        for (Map.Entry<HttpConnection, TimeValues> entry : this.connectionToTimes.entrySet()) {
            HttpConnection conn = entry.getKey();
            TimeValues times = entry.getValue();
            if (times.timeExpires > now) continue;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Closing connection, expired @: " + times.timeExpires));
            }
            try {
                conn.close();
            }
            catch (IOException ex) {
                this.log.debug((Object)"I/O error closing connection", (Throwable)ex);
            }
        }
    }

    private static class TimeValues {
        private final long timeAdded;
        private final long timeExpires;

        /*
         * WARNING - void declaration
         */
        TimeValues(long now, long validDuration, TimeUnit validUnit) {
            this.timeAdded = now;
            if (validDuration > 0L) {
                void var3_2;
                void var1_1;
                this.timeExpires = var1_1 + validUnit.toMillis((long)var3_2);
                return;
            }
            this.timeExpires = Long.MAX_VALUE;
        }
    }
}

