/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.nio.charset.CharsetDecoder;
import java.nio.charset.CharsetEncoder;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.entity.ContentLengthStrategy;
import org.apache.http.impl.DefaultBHttpClientConnection;
import org.apache.http.io.HttpMessageParserFactory;
import org.apache.http.io.HttpMessageWriterFactory;
import org.apache.http.protocol.HttpContext;

@NotThreadSafe
public class DefaultManagedHttpClientConnection
extends DefaultBHttpClientConnection
implements ManagedHttpClientConnection,
HttpContext {
    private final String id;
    private final Map<String, Object> attributes;
    private volatile boolean shutdown;

    /*
     * WARNING - void declaration
     */
    public DefaultManagedHttpClientConnection(String id, int buffersize, int fragmentSizeHint, CharsetDecoder chardecoder, CharsetEncoder charencoder, MessageConstraints constraints, ContentLengthStrategy incomingContentStrategy, ContentLengthStrategy outgoingContentStrategy, HttpMessageWriterFactory<HttpRequest> requestWriterFactory, HttpMessageParserFactory<HttpResponse> responseParserFactory) {
        super((int)var2_2, (int)var3_3, chardecoder, charencoder, constraints, incomingContentStrategy, outgoingContentStrategy, requestWriterFactory, responseParserFactory);
        void var1_1;
        void var3_3;
        void var2_2;
        this.id = var1_1;
        this.attributes = new ConcurrentHashMap<String, Object>();
    }

    /*
     * WARNING - void declaration
     */
    public DefaultManagedHttpClientConnection(String id, int buffersize) {
        void var1_1;
        void var2_2;
        void v0 = var2_2;
        this((String)var1_1, (int)v0, (int)v0, null, null, null, null, null, null, null);
    }

    @Override
    public String getId() {
        return this.id;
    }

    public void shutdown() throws IOException {
        this.shutdown = true;
        super.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String id) {
        void var1_1;
        return this.attributes.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object removeAttribute(String id) {
        void var1_1;
        return this.attributes.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String id, Object obj) {
        void var2_2;
        void var1_1;
        this.attributes.put((String)var1_1, var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind(Socket socket) throws IOException {
        void var1_1;
        if (this.shutdown) {
            socket.close();
            throw new InterruptedIOException("Connection already shutdown");
        }
        super.bind((Socket)var1_1);
    }

    @Override
    public Socket getSocket() {
        return super.getSocket();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLSession getSSLSession() {
        Socket socket = super.getSocket();
        if (socket instanceof SSLSocket) {
            void var1_1;
            return ((SSLSocket)var1_1).getSession();
        }
        return null;
    }
}

