/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpException;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.NoHttpResponseException;
import org.apache.http.ProtocolException;
import org.apache.http.StatusLine;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.config.MessageConstraints;
import org.apache.http.impl.DefaultHttpResponseFactory;
import org.apache.http.impl.io.AbstractMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.message.LineParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.params.HttpParams;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;

@NotThreadSafe
public class DefaultHttpResponseParser
extends AbstractMessageParser<HttpResponse> {
    private final Log log = LogFactory.getLog(((Object)((Object)this)).getClass());
    private final HttpResponseFactory responseFactory;
    private final CharArrayBuffer lineBuf;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser parser, HttpResponseFactory responseFactory, HttpParams params) {
        super((SessionInputBuffer)var1_1, (LineParser)var2_2, params);
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)responseFactory, (String)"Response factory");
        this.responseFactory = var3_3;
        this.lineBuf = new CharArrayBuffer(128);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpResponseParser(SessionInputBuffer buffer, LineParser lineParser, HttpResponseFactory responseFactory, MessageConstraints constraints) {
        super((SessionInputBuffer)var1_1, (LineParser)var2_2, constraints);
        void var3_3;
        void var2_2;
        void var1_1;
        this.responseFactory = responseFactory != null ? var3_3 : DefaultHttpResponseFactory.INSTANCE;
        this.lineBuf = new CharArrayBuffer(128);
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpResponseParser(SessionInputBuffer buffer, MessageConstraints constraints) {
        this((SessionInputBuffer)var1_1, null, null, (MessageConstraints)var2_2);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpResponseParser(SessionInputBuffer buffer) {
        this((SessionInputBuffer)var1_1, null, null, MessageConstraints.DEFAULT);
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpResponse parseHead(SessionInputBuffer sessionBuffer) throws IOException, HttpException {
        void var3_3;
        int count = 0;
        while (true) {
            block7: {
                block6: {
                    this.lineBuf.clear();
                    int i = sessionBuffer.readLine(this.lineBuf);
                    if (i == -1 && count == 0) {
                        throw new NoHttpResponseException("The target server failed to respond");
                    }
                    ParserCursor cursor = new ParserCursor(0, this.lineBuf.length());
                    if (this.lineParser.hasProtocolVersion(this.lineBuf, cursor)) break;
                    if (i == -1) break block6;
                    DefaultHttpResponseParser defaultHttpResponseParser = this;
                    if (!defaultHttpResponseParser.reject(defaultHttpResponseParser.lineBuf, count)) break block7;
                }
                throw new ProtocolException("The server failed to respond with a valid HTTP response");
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Garbage in response: " + this.lineBuf.toString()));
            }
            ++count;
        }
        StatusLine statusline = this.lineParser.parseStatusLine(this.lineBuf, (ParserCursor)var3_3);
        return this.responseFactory.newHttpResponse(statusline, null);
    }

    protected boolean reject(CharArrayBuffer line, int count) {
        return false;
    }
}

