/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.Socket;
import java.util.HashMap;
import java.util.Map;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.HttpResponseFactory;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.impl.SocketHttpClientConnection;
import org.apache.http.impl.conn.DefaultHttpResponseParser;
import org.apache.http.impl.conn.LoggingSessionInputBuffer;
import org.apache.http.impl.conn.LoggingSessionOutputBuffer;
import org.apache.http.impl.conn.Wire;
import org.apache.http.io.HttpMessageParser;
import org.apache.http.io.SessionInputBuffer;
import org.apache.http.io.SessionOutputBuffer;
import org.apache.http.params.BasicHttpParams;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Deprecated
@NotThreadSafe
public class DefaultClientConnection
extends SocketHttpClientConnection
implements ManagedHttpClientConnection,
OperatedClientConnection,
HttpContext {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Log headerLog = LogFactory.getLog((String)"org.apache.http.headers");
    private final Log wireLog = LogFactory.getLog((String)"org.apache.http.wire");
    private volatile Socket socket;
    private HttpHost targetHost;
    private boolean connSecure;
    private volatile boolean shutdown;
    private final Map<String, Object> attributes = new HashMap<String, Object>();

    @Override
    public String getId() {
        return null;
    }

    @Override
    public final HttpHost getTargetHost() {
        return this.targetHost;
    }

    @Override
    public final boolean isSecure() {
        return this.connSecure;
    }

    @Override
    public final Socket getSocket() {
        return this.socket;
    }

    @Override
    public SSLSession getSSLSession() {
        if (this.socket instanceof SSLSocket) {
            return ((SSLSocket)this.socket).getSession();
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void opening(Socket sock, HttpHost target) throws IOException {
        void var2_2;
        this.assertNotOpen();
        this.socket = sock;
        this.targetHost = var2_2;
        if (this.shutdown) {
            void var1_1;
            var1_1.close();
            throw new InterruptedIOException("Connection already shutdown");
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void openCompleted(boolean secure, HttpParams params) throws IOException {
        void var2_2;
        void var1_1;
        Args.notNull((Object)params, (String)"Parameters");
        this.assertNotOpen();
        this.connSecure = var1_1;
        DefaultClientConnection defaultClientConnection = this;
        defaultClientConnection.bind(defaultClientConnection.socket, (HttpParams)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    public void shutdown() throws IOException {
        this.shutdown = true;
        try {
            Socket sock;
            super.shutdown();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection " + this + " shut down"));
            }
            if ((sock = this.socket) != null) {
                sock.close();
            }
            return;
        }
        catch (IOException ex) {
            void var1_2;
            this.log.debug((Object)"I/O error shutting down connection", (Throwable)var1_2);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws IOException {
        try {
            super.close();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection " + this + " closed"));
            }
            return;
        }
        catch (IOException ex) {
            void var1_1;
            this.log.debug((Object)"I/O error closing connection", (Throwable)var1_1);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    protected SessionInputBuffer createSessionInputBuffer(Socket socket, int buffersize, HttpParams params) throws IOException {
        void var1_1;
        int n;
        SessionInputBuffer inbuffer = super.createSessionInputBuffer(socket, buffersize > 0 ? n : 8192, params);
        if (this.wireLog.isDebugEnabled()) {
            void var3_3;
            inbuffer = new LoggingSessionInputBuffer(inbuffer, new Wire(this.wireLog), HttpProtocolParams.getHttpElementCharset((HttpParams)var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected SessionOutputBuffer createSessionOutputBuffer(Socket socket, int buffersize, HttpParams params) throws IOException {
        void var1_1;
        int n;
        SessionOutputBuffer outbuffer = super.createSessionOutputBuffer(socket, buffersize > 0 ? n : 8192, params);
        if (this.wireLog.isDebugEnabled()) {
            void var3_3;
            outbuffer = new LoggingSessionOutputBuffer(outbuffer, new Wire(this.wireLog), HttpProtocolParams.getHttpElementCharset((HttpParams)var3_3));
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected HttpMessageParser<HttpResponse> createResponseParser(SessionInputBuffer buffer, HttpResponseFactory responseFactory, HttpParams params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultHttpResponseParser((SessionInputBuffer)var1_1, null, (HttpResponseFactory)var2_2, (HttpParams)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind(Socket socket) throws IOException {
        void var1_1;
        this.bind((Socket)var1_1, (HttpParams)new BasicHttpParams());
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void update(Socket sock, HttpHost target, boolean secure, HttpParams params) throws IOException {
        void var3_3;
        void var2_2;
        this.assertOpen();
        Args.notNull((Object)target, (String)"Target host");
        Args.notNull((Object)params, (String)"Parameters");
        if (sock != null) {
            void var1_1;
            this.socket = sock;
            this.bind((Socket)var1_1, params);
        }
        this.targetHost = var2_2;
        this.connSecure = var3_3;
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        void var1_1;
        HttpResponse response = super.receiveResponseHeader();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Receiving response: " + response.getStatusLine()));
        }
        if (this.headerLog.isDebugEnabled()) {
            Header[] headerArray;
            this.headerLog.debug((Object)("<< " + response.getStatusLine().toString()));
            Header[] arr$ = headerArray = response.getAllHeaders();
            int len$ = headerArray.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Header header = arr$[i$];
                this.headerLog.debug((Object)("<< " + header.toString()));
            }
        }
        return var1_1;
    }

    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Sending request: " + request.getRequestLine()));
        }
        super.sendRequestHeader((HttpRequest)request);
        if (this.headerLog.isDebugEnabled()) {
            this.headerLog.debug((Object)(">> " + request.getRequestLine().toString()));
            Header[] arr$ = request = request.getAllHeaders();
            int len$ = request.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                Header header = arr$[i$];
                this.headerLog.debug((Object)(">> " + header.toString()));
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String id) {
        void var1_1;
        return this.attributes.get(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public Object removeAttribute(String id) {
        void var1_1;
        return this.attributes.remove(var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String id, Object obj) {
        void var2_2;
        void var1_1;
        this.attributes.put((String)var1_1, var2_2);
    }
}

