/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.net.InetAddress;
import java.net.Socket;
import javax.net.ssl.SSLSession;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.impl.conn.CPoolEntry;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.protocol.HttpContext;

@NotThreadSafe
class CPoolProxy
implements ManagedHttpClientConnection,
HttpContext {
    private volatile CPoolEntry poolEntry;

    /*
     * WARNING - void declaration
     */
    CPoolProxy(CPoolEntry entry) {
        void var1_1;
        this.poolEntry = var1_1;
    }

    CPoolEntry getPoolEntry() {
        return this.poolEntry;
    }

    /*
     * WARNING - void declaration
     */
    CPoolEntry detach() {
        void var1_1;
        CPoolEntry local = this.poolEntry;
        this.poolEntry = null;
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    ManagedHttpClientConnection getConnection() {
        void var1_1;
        CPoolEntry local = this.poolEntry;
        if (local == null) {
            return null;
        }
        return (ManagedHttpClientConnection)var1_1.getConnection();
    }

    /*
     * WARNING - void declaration
     */
    ManagedHttpClientConnection getValidConnection() {
        void var1_1;
        ManagedHttpClientConnection conn = this.getConnection();
        if (conn == null) {
            throw new ConnectionShutdownException();
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void close() throws IOException {
        CPoolEntry local = this.poolEntry;
        if (local != null) {
            void var1_1;
            var1_1.closeConnection();
        }
    }

    /*
     * WARNING - void declaration
     */
    public void shutdown() throws IOException {
        CPoolEntry local = this.poolEntry;
        if (local != null) {
            void var1_1;
            var1_1.shutdownConnection();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isOpen() {
        CPoolEntry local = this.poolEntry;
        if (local != null) {
            void var1_1;
            return !var1_1.isClosed();
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    public boolean isStale() {
        ManagedHttpClientConnection conn = this.getConnection();
        if (conn != null) {
            void var1_1;
            return var1_1.isStale();
        }
        return true;
    }

    /*
     * WARNING - void declaration
     */
    public void setSocketTimeout(int timeout) {
        void var1_1;
        this.getValidConnection().setSocketTimeout((int)var1_1);
    }

    public int getSocketTimeout() {
        return this.getValidConnection().getSocketTimeout();
    }

    @Override
    public String getId() {
        return this.getValidConnection().getId();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void bind(Socket socket) throws IOException {
        void var1_1;
        this.getValidConnection().bind((Socket)var1_1);
    }

    @Override
    public Socket getSocket() {
        return this.getValidConnection().getSocket();
    }

    @Override
    public SSLSession getSSLSession() {
        return this.getValidConnection().getSSLSession();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isResponseAvailable(int timeout) throws IOException {
        void var1_1;
        return this.getValidConnection().isResponseAvailable((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        void var1_1;
        this.getValidConnection().sendRequestHeader((HttpRequest)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        void var1_1;
        this.getValidConnection().sendRequestEntity((HttpEntityEnclosingRequest)var1_1);
    }

    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        return this.getValidConnection().receiveResponseHeader();
    }

    /*
     * WARNING - void declaration
     */
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        void var1_1;
        this.getValidConnection().receiveResponseEntity((HttpResponse)var1_1);
    }

    public void flush() throws IOException {
        this.getValidConnection().flush();
    }

    public HttpConnectionMetrics getMetrics() {
        return this.getValidConnection().getMetrics();
    }

    public InetAddress getLocalAddress() {
        return this.getValidConnection().getLocalAddress();
    }

    public int getLocalPort() {
        return this.getValidConnection().getLocalPort();
    }

    public InetAddress getRemoteAddress() {
        return this.getValidConnection().getRemoteAddress();
    }

    public int getRemotePort() {
        return this.getValidConnection().getRemotePort();
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String id) {
        ManagedHttpClientConnection conn = this.getValidConnection();
        if (conn instanceof HttpContext) {
            void var1_1;
            void var2_2;
            return ((HttpContext)var2_2).getAttribute((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String id, Object obj) {
        ManagedHttpClientConnection conn = this.getValidConnection();
        if (conn instanceof HttpContext) {
            void var2_2;
            void var1_1;
            void var3_3;
            ((HttpContext)var3_3).setAttribute((String)var1_1, (Object)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    public Object removeAttribute(String id) {
        ManagedHttpClientConnection conn = this.getValidConnection();
        if (conn instanceof HttpContext) {
            void var1_1;
            void var2_2;
            return ((HttpContext)var2_2).removeAttribute((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public String toString() {
        void var1_1;
        StringBuilder sb = new StringBuilder("CPoolProxy{");
        ManagedHttpClientConnection conn = this.getConnection();
        if (conn != null) {
            void var2_2;
            sb.append(var2_2);
        } else {
            sb.append("detached");
        }
        sb.append('}');
        return var1_1.toString();
    }

    public static HttpClientConnection newProxy(CPoolEntry poolEntry) {
        CPoolEntry cPoolEntry;
        return new CPoolProxy(cPoolEntry);
    }

    private static CPoolProxy getProxy(HttpClientConnection conn) {
        HttpClientConnection httpClientConnection;
        if (!CPoolProxy.class.isInstance(conn)) {
            throw new IllegalStateException("Unexpected connection proxy class: " + conn.getClass());
        }
        return (CPoolProxy)CPoolProxy.class.cast(httpClientConnection);
    }

    public static CPoolEntry getPoolEntry(HttpClientConnection proxy) {
        Object object;
        Object entry = CPoolProxy.getProxy(proxy).getPoolEntry();
        if (entry == null) {
            throw new ConnectionShutdownException();
        }
        return object;
    }

    public static CPoolEntry detach(HttpClientConnection conn) {
        return CPoolProxy.getProxy(conn).detach();
    }
}

