/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import org.apache.commons.logging.Log;
import org.apache.http.HttpClientConnection;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.pool.PoolEntry;

@ThreadSafe
class CPoolEntry
extends PoolEntry<HttpRoute, ManagedHttpClientConnection> {
    private final Log log;
    private volatile boolean routeComplete;

    /*
     * WARNING - void declaration
     */
    public CPoolEntry(Log log, String id, HttpRoute route, ManagedHttpClientConnection conn, long timeToLive, TimeUnit tunit) {
        super((String)var2_2, (Object)var3_3, (Object)conn, timeToLive, tunit);
        void var1_1;
        void var3_3;
        void var2_2;
        this.log = var1_1;
    }

    public void markRouteComplete() {
        this.routeComplete = true;
    }

    public boolean isRouteComplete() {
        return this.routeComplete;
    }

    public void closeConnection() throws IOException {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        httpClientConnection.close();
    }

    public void shutdownConnection() throws IOException {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        httpClientConnection.shutdown();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isExpired(long now) {
        void var1_2;
        boolean expired = super.isExpired(now);
        if (expired && this.log.isDebugEnabled()) {
            this.log.debug((Object)("Connection " + (Object)((Object)this) + " expired @ " + new Date(this.getExpiry())));
        }
        return (boolean)var1_2;
    }

    public boolean isClosed() {
        HttpClientConnection httpClientConnection = (HttpClientConnection)this.getConnection();
        return !httpClientConnection.isOpen();
    }

    /*
     * WARNING - void declaration
     */
    public void close() {
        try {
            this.closeConnection();
            return;
        }
        catch (IOException ex) {
            void var1_1;
            this.log.debug((Object)"I/O error closing connection", (Throwable)var1_1);
            return;
        }
    }
}

