/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.conn.CPoolEntry;
import org.apache.http.pool.AbstractConnPool;
import org.apache.http.pool.ConnFactory;

@ThreadSafe
class CPool
extends AbstractConnPool<HttpRoute, ManagedHttpClientConnection, CPoolEntry> {
    private static final AtomicLong COUNTER = new AtomicLong();
    private final Log log = LogFactory.getLog(CPool.class);
    private final long timeToLive;
    private final TimeUnit tunit;

    /*
     * WARNING - void declaration
     */
    public CPool(ConnFactory<HttpRoute, ManagedHttpClientConnection> connFactory, int defaultMaxPerRoute, int maxTotal, long timeToLive, TimeUnit tunit) {
        super((ConnFactory)var1_1, (int)var2_2, (int)var3_3);
        void var3_3;
        void var2_2;
        void var1_1;
        this.timeToLive = timeToLive;
        this.tunit = tunit;
    }

    /*
     * WARNING - void declaration
     */
    protected CPoolEntry createEntry(HttpRoute route, ManagedHttpClientConnection conn) {
        void var2_2;
        void var1_1;
        void var3_3;
        String id = Long.toString(COUNTER.getAndIncrement());
        return new CPoolEntry(this.log, (String)var3_3, (HttpRoute)var1_1, (ManagedHttpClientConnection)var2_2, this.timeToLive, this.tunit);
    }

    protected boolean validate(CPoolEntry entry) {
        return !((ManagedHttpClientConnection)entry.getConnection()).isStale();
    }
}

