/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.Closeable;
import java.io.IOException;
import java.net.InetSocketAddress;
import java.util.Date;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.HttpHost;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.config.ConnectionConfig;
import org.apache.http.config.Lookup;
import org.apache.http.config.Registry;
import org.apache.http.config.RegistryBuilder;
import org.apache.http.config.SocketConfig;
import org.apache.http.conn.ConnectionRequest;
import org.apache.http.conn.DnsResolver;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.conn.HttpClientConnectionOperator;
import org.apache.http.conn.HttpConnectionFactory;
import org.apache.http.conn.ManagedHttpClientConnection;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.socket.ConnectionSocketFactory;
import org.apache.http.conn.socket.PlainConnectionSocketFactory;
import org.apache.http.conn.ssl.SSLConnectionSocketFactory;
import org.apache.http.impl.conn.DefaultHttpClientConnectionOperator;
import org.apache.http.impl.conn.ManagedHttpClientConnectionFactory;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;
import org.apache.http.util.LangUtils;

@ThreadSafe
public class BasicHttpClientConnectionManager
implements Closeable,
HttpClientConnectionManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private final HttpClientConnectionOperator connectionOperator;
    private final HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory;
    @GuardedBy(value="this")
    private ManagedHttpClientConnection conn;
    @GuardedBy(value="this")
    private HttpRoute route;
    @GuardedBy(value="this")
    private Object state;
    @GuardedBy(value="this")
    private long updated;
    @GuardedBy(value="this")
    private long expiry;
    @GuardedBy(value="this")
    private boolean leased;
    @GuardedBy(value="this")
    private SocketConfig socketConfig;
    @GuardedBy(value="this")
    private ConnectionConfig connConfig;
    private final AtomicBoolean isShutdown;

    private static Registry<ConnectionSocketFactory> getDefaultRegistry() {
        return RegistryBuilder.create().register("http", (Object)PlainConnectionSocketFactory.getSocketFactory()).register("https", (Object)SSLConnectionSocketFactory.getSocketFactory()).build();
    }

    /*
     * WARNING - void declaration
     */
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory, SchemePortResolver schemePortResolver, DnsResolver dnsResolver) {
        this(new DefaultHttpClientConnectionOperator((Lookup<ConnectionSocketFactory>)var1_1, (SchemePortResolver)var3_3, dnsResolver), (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)var2_2);
        void var2_2;
        void var3_3;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BasicHttpClientConnectionManager(HttpClientConnectionOperator httpClientConnectionOperator, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory) {
        void var2_2;
        void var1_1;
        this.connectionOperator = (HttpClientConnectionOperator)Args.notNull((Object)var1_1, (String)"Connection operator");
        this.connFactory = connFactory != null ? var2_2 : ManagedHttpClientConnectionFactory.INSTANCE;
        this.expiry = Long.MAX_VALUE;
        this.socketConfig = SocketConfig.DEFAULT;
        this.connConfig = ConnectionConfig.DEFAULT;
        this.isShutdown = new AtomicBoolean(false);
    }

    /*
     * WARNING - void declaration
     */
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry, HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection> connFactory) {
        this((Lookup<ConnectionSocketFactory>)var1_1, (HttpConnectionFactory<HttpRoute, ManagedHttpClientConnection>)var2_2, null, null);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public BasicHttpClientConnectionManager(Lookup<ConnectionSocketFactory> socketFactoryRegistry) {
        this((Lookup<ConnectionSocketFactory>)var1_1, null, null, null);
        void var1_1;
    }

    public BasicHttpClientConnectionManager() {
        this((Lookup<ConnectionSocketFactory>)BasicHttpClientConnectionManager.getDefaultRegistry(), null, null, null);
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public void close() {
        this.shutdown();
    }

    HttpRoute getRoute() {
        return this.route;
    }

    Object getState() {
        return this.state;
    }

    public synchronized SocketConfig getSocketConfig() {
        return this.socketConfig;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setSocketConfig(SocketConfig socketConfig) {
        void var1_1;
        this.socketConfig = socketConfig != null ? var1_1 : SocketConfig.DEFAULT;
    }

    public synchronized ConnectionConfig getConnectionConfig() {
        return this.connConfig;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setConnectionConfig(ConnectionConfig connConfig) {
        void var1_1;
        this.connConfig = connConfig != null ? var1_1 : ConnectionConfig.DEFAULT;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ConnectionRequest requestConnection(HttpRoute route, Object state) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)route, (String)"Route");
        return new ConnectionRequest((HttpRoute)var1_1, var2_2){
            final /* synthetic */ HttpRoute val$route;
            final /* synthetic */ Object val$state;
            {
                this.val$route = httpRoute;
                this.val$state = object;
            }

            public boolean cancel() {
                return false;
            }

            @Override
            public HttpClientConnection get(long timeout, TimeUnit tunit) {
                return BasicHttpClientConnectionManager.this.getConnection(this.val$route, this.val$state);
            }
        };
    }

    /*
     * WARNING - void declaration
     */
    private void closeConnection() {
        if (this.conn != null) {
            block3: {
                this.log.debug((Object)"Closing connection");
                try {
                    this.conn.close();
                }
                catch (IOException iox) {
                    void var1_1;
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug((Object)"I/O exception closing connection", (Throwable)var1_1);
                }
            }
            this.conn = null;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownConnection() {
        if (this.conn != null) {
            block3: {
                this.log.debug((Object)"Shutting down connection");
                try {
                    this.conn.shutdown();
                }
                catch (IOException iox) {
                    void var1_1;
                    if (!this.log.isDebugEnabled()) break block3;
                    this.log.debug((Object)"I/O exception shutting down connection", (Throwable)var1_1);
                }
            }
            this.conn = null;
        }
    }

    private void checkExpiry() {
        if (this.conn != null && System.currentTimeMillis() >= this.expiry) {
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Connection expired @ " + new Date(this.expiry)));
            }
            this.closeConnection();
        }
    }

    /*
     * WARNING - void declaration
     */
    synchronized HttpClientConnection getConnection(HttpRoute route, Object state) {
        void var2_2;
        Asserts.check((!this.isShutdown.get() ? 1 : 0) != 0, (String)"Connection manager has been shut down");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Get connection for route " + route));
        }
        Asserts.check((!this.leased ? 1 : 0) != 0, (String)"Connection is still allocated");
        if (!LangUtils.equals((Object)this.route, (Object)route) || !LangUtils.equals((Object)this.state, (Object)state)) {
            this.closeConnection();
        }
        this.route = route;
        this.state = var2_2;
        this.checkExpiry();
        if (this.conn == null) {
            void var1_1;
            this.conn = this.connFactory.create((HttpRoute)var1_1, this.connConfig);
        }
        this.leased = true;
        return this.conn;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void releaseConnection(HttpClientConnection conn, Object state, long keepalive, TimeUnit tunit) {
        Args.notNull((Object)conn, (String)"Connection");
        Asserts.check((conn == this.conn ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Releasing connection " + conn));
        }
        if (this.isShutdown.get()) {
            return;
        }
        try {
            this.updated = System.currentTimeMillis();
            if (!this.conn.isOpen()) {
                this.conn = null;
                this.route = null;
                this.conn = null;
                this.expiry = Long.MAX_VALUE;
            } else {
                void var3_4;
                void var2_3;
                this.state = var2_3;
                if (this.log.isDebugEnabled()) {
                    void var1_1;
                    String s = keepalive > 0L ? "for " + keepalive + " " + (Object)((Object)tunit) : "indefinitely";
                    this.log.debug((Object)("Connection can be kept alive " + (String)var1_1));
                }
                this.expiry = keepalive > 0L ? this.updated + tunit.toMillis((long)var3_4) : Long.MAX_VALUE;
            }
            return;
        }
        finally {
            this.leased = false;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void connect(HttpClientConnection conn, HttpRoute route, int connectTimeout, HttpContext context) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)conn, (String)"Connection");
        Args.notNull((Object)route, (String)"HTTP route");
        Asserts.check((conn == this.conn ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
        HttpHost host = route.getProxyHost() != null ? route.getProxyHost() : route.getTargetHost();
        InetSocketAddress localAddress = route.getLocalSocketAddress();
        this.connectionOperator.connect(this.conn, (HttpHost)var1_1, (InetSocketAddress)var2_2, (int)var3_3, this.socketConfig, context);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void upgrade(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
        void var3_3;
        void var2_2;
        void var1_1;
        Args.notNull((Object)conn, (String)"Connection");
        Args.notNull((Object)route, (String)"HTTP route");
        Asserts.check((var1_1 == this.conn ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
        this.connectionOperator.upgrade(this.conn, var2_2.getTargetHost(), (HttpContext)var3_3);
    }

    @Override
    public void routeComplete(HttpClientConnection conn, HttpRoute route, HttpContext context) throws IOException {
    }

    @Override
    public synchronized void closeExpiredConnections() {
        if (this.isShutdown.get()) {
            return;
        }
        if (!this.leased) {
            this.checkExpiry();
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public synchronized void closeIdleConnections(long idletime, TimeUnit tunit) {
        Args.notNull((Object)((Object)tunit), (String)"Time unit");
        if (this.isShutdown.get()) {
            return;
        }
        if (!this.leased) {
            long deadline;
            void var1_1;
            void var3_2;
            long time = var3_2.toMillis((long)var1_1);
            if (time < 0L) {
                time = 0L;
            }
            if (this.updated <= (deadline = System.currentTimeMillis() - time)) {
                this.closeConnection();
            }
        }
    }

    @Override
    public synchronized void shutdown() {
        if (this.isShutdown.compareAndSet(false, true)) {
            this.shutdownConnection();
        }
    }
}

