/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.atomic.AtomicLong;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpClientConnection;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionOperator;
import org.apache.http.conn.ClientConnectionRequest;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.impl.conn.DefaultClientConnectionOperator;
import org.apache.http.impl.conn.HttpPoolEntry;
import org.apache.http.impl.conn.ManagedClientConnectionImpl;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
@ThreadSafe
public class BasicClientConnectionManager
implements ClientConnectionManager {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final AtomicLong COUNTER = new AtomicLong();
    public static final String MISUSE_MESSAGE = "Invalid use of BasicClientConnManager: connection still allocated.\nMake sure to release the connection before allocating another one.";
    private final SchemeRegistry schemeRegistry;
    private final ClientConnectionOperator connOperator;
    @GuardedBy(value="this")
    private HttpPoolEntry poolEntry;
    @GuardedBy(value="this")
    private ManagedClientConnectionImpl conn;
    @GuardedBy(value="this")
    private volatile boolean shutdown;

    /*
     * WARNING - void declaration
     */
    public BasicClientConnectionManager(SchemeRegistry schreg) {
        void var1_1;
        Args.notNull((Object)schreg, (String)"Scheme registry");
        this.schemeRegistry = schreg;
        this.connOperator = this.createConnectionOperator((SchemeRegistry)var1_1);
    }

    public BasicClientConnectionManager() {
        this(SchemeRegistryFactory.createDefault());
    }

    protected void finalize() throws Throwable {
        try {
            this.shutdown();
            return;
        }
        finally {
            super.finalize();
        }
    }

    @Override
    public SchemeRegistry getSchemeRegistry() {
        return this.schemeRegistry;
    }

    /*
     * WARNING - void declaration
     */
    protected ClientConnectionOperator createConnectionOperator(SchemeRegistry schreg) {
        void var1_1;
        return new DefaultClientConnectionOperator((SchemeRegistry)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final ClientConnectionRequest requestConnection(HttpRoute route, Object state) {
        void var2_2;
        void var1_1;
        return new ClientConnectionRequest((HttpRoute)var1_1, var2_2){
            final /* synthetic */ HttpRoute val$route;
            final /* synthetic */ Object val$state;
            {
                this.val$route = httpRoute;
                this.val$state = object;
            }

            @Override
            public void abortRequest() {
            }

            @Override
            public ManagedClientConnection getConnection(long timeout, TimeUnit tunit) {
                return BasicClientConnectionManager.this.getConnection(this.val$route, this.val$state);
            }
        };
    }

    private void assertNotShutdown() {
        Asserts.check((!this.shutdown ? 1 : 0) != 0, (String)"Connection manager has been shut down");
    }

    /*
     * WARNING - void declaration
     */
    ManagedClientConnection getConnection(HttpRoute route, Object state) {
        Args.notNull((Object)route, (String)"Route");
        BasicClientConnectionManager basicClientConnectionManager = this;
        synchronized (basicClientConnectionManager) {
            long now;
            this.assertNotShutdown();
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Get connection for route " + route));
            }
            Asserts.check((this.conn == null ? 1 : 0) != 0, (String)MISUSE_MESSAGE);
            if (this.poolEntry != null && !this.poolEntry.getPlannedRoute().equals(route)) {
                this.poolEntry.close();
                this.poolEntry = null;
            }
            if (this.poolEntry == null) {
                void var1_1;
                String id = Long.toString(COUNTER.getAndIncrement());
                OperatedClientConnection opconn = this.connOperator.createConnection();
                this.poolEntry = new HttpPoolEntry(this.log, id, (HttpRoute)var1_1, opconn, 0L, TimeUnit.MILLISECONDS);
            }
            if (this.poolEntry.isExpired(now = System.currentTimeMillis())) {
                this.poolEntry.close();
                this.poolEntry.getTracker().reset();
            }
            BasicClientConnectionManager basicClientConnectionManager2 = this;
            this.conn = new ManagedClientConnectionImpl(basicClientConnectionManager2, basicClientConnectionManager2.connOperator, this.poolEntry);
            return this.conn;
        }
    }

    /*
     * WARNING - void declaration
     */
    private void shutdownConnection(HttpClientConnection conn) {
        try {
            conn.shutdown();
            return;
        }
        catch (IOException iox) {
            if (this.log.isDebugEnabled()) {
                void var1_2;
                this.log.debug((Object)"I/O exception shutting down connection", (Throwable)var1_2);
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void releaseConnection(ManagedClientConnection conn, long keepalive, TimeUnit tunit) {
        ManagedClientConnectionImpl managedConn;
        Args.check((boolean)(conn instanceof ManagedClientConnectionImpl), (String)"Connection class mismatch, connection not obtained from this manager");
        ManagedClientConnectionImpl managedClientConnectionImpl = managedConn = (ManagedClientConnectionImpl)conn;
        synchronized (managedConn) {
            ClientConnectionManager clientConnectionManager;
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Releasing connection " + clientConnectionManager));
            }
            if (managedConn.getPoolEntry() == null) {
                // ** MonitorExit[var6_9] (shouldn't be in output)
                return;
            }
            clientConnectionManager = managedConn.getManager();
            Asserts.check((clientConnectionManager == this ? 1 : 0) != 0, (String)"Connection not obtained from this manager");
            clientConnectionManager = this;
            synchronized (clientConnectionManager) {
                if (this.shutdown) {
                    this.shutdownConnection(managedConn);
                    // MONITOREXIT @DISABLED, blocks:[0, 1, 3, 4, 11] lbl17 : MonitorExitStatement: MONITOREXIT : var1_1
                    // ** MonitorExit[var6_9] (shouldn't be in output)
                    return;
                }
                try {
                    if (managedConn.isOpen() && !managedConn.isMarkedReusable()) {
                        this.shutdownConnection(managedConn);
                    }
                    if (managedConn.isMarkedReusable()) {
                        this.poolEntry.updateExpiry(keepalive, tunit != null ? tunit : TimeUnit.MILLISECONDS);
                        if (this.log.isDebugEnabled()) {
                            void var2_4;
                            String s = keepalive > 0L ? "for " + keepalive + " " + (Object)((Object)tunit) : "indefinitely";
                            this.log.debug((Object)("Connection can be kept alive " + (String)var2_4));
                        }
                    }
                }
                finally {
                    managedConn.detach();
                    this.conn = null;
                    if (this.poolEntry.isClosed()) {
                        this.poolEntry = null;
                    }
                }
            }
            // ** MonitorExit[var6_9] (shouldn't be in output)
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeExpiredConnections() {
        BasicClientConnectionManager basicClientConnectionManager = this;
        synchronized (basicClientConnectionManager) {
            void var2_2;
            this.assertNotShutdown();
            long now = System.currentTimeMillis();
            if (this.poolEntry != null && this.poolEntry.isExpired((long)var2_2)) {
                this.poolEntry.close();
                this.poolEntry.getTracker().reset();
            }
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void closeIdleConnections(long idletime, TimeUnit tunit) {
        Args.notNull((Object)((Object)tunit), (String)"Time unit");
        BasicClientConnectionManager basicClientConnectionManager = this;
        synchronized (basicClientConnectionManager) {
            void var1_1;
            void var3_3;
            this.assertNotShutdown();
            long time = var3_3.toMillis((long)var1_1);
            if (time < 0L) {
                time = 0L;
            }
            long deadline = System.currentTimeMillis() - time;
            if (this.poolEntry != null && this.poolEntry.getUpdated() <= deadline) {
                this.poolEntry.close();
                this.poolEntry.getTracker().reset();
            }
            return;
        }
    }

    @Override
    public void shutdown() {
        BasicClientConnectionManager basicClientConnectionManager = this;
        synchronized (basicClientConnectionManager) {
            this.shutdown = true;
            try {
                if (this.poolEntry != null) {
                    this.poolEntry.close();
                }
            }
            finally {
                this.poolEntry = null;
                this.conn = null;
            }
            return;
        }
    }
}

