/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.conn;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.InetAddress;
import java.net.Socket;
import java.util.concurrent.TimeUnit;
import javax.net.ssl.SSLSession;
import javax.net.ssl.SSLSocket;
import org.apache.http.HttpConnectionMetrics;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpException;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ManagedClientConnection;
import org.apache.http.conn.OperatedClientConnection;
import org.apache.http.impl.conn.ConnectionShutdownException;
import org.apache.http.protocol.HttpContext;

@Deprecated
@NotThreadSafe
public abstract class AbstractClientConnAdapter
implements ManagedClientConnection,
HttpContext {
    private final ClientConnectionManager connManager;
    private volatile OperatedClientConnection wrappedConnection;
    private volatile boolean markedReusable;
    private volatile boolean released;
    private volatile long duration;

    /*
     * WARNING - void declaration
     */
    protected AbstractClientConnAdapter(ClientConnectionManager mgr, OperatedClientConnection conn) {
        void var2_2;
        void var1_1;
        this.connManager = var1_1;
        this.wrappedConnection = var2_2;
        this.markedReusable = false;
        this.released = false;
        this.duration = Long.MAX_VALUE;
    }

    protected synchronized void detach() {
        this.wrappedConnection = null;
        this.duration = Long.MAX_VALUE;
    }

    protected OperatedClientConnection getWrappedConnection() {
        return this.wrappedConnection;
    }

    protected ClientConnectionManager getManager() {
        return this.connManager;
    }

    @Deprecated
    protected final void assertNotAborted() throws InterruptedIOException {
        if (this.isReleased()) {
            throw new InterruptedIOException("Connection has been shut down");
        }
    }

    protected boolean isReleased() {
        return this.released;
    }

    /*
     * WARNING - void declaration
     */
    protected final void assertValid(OperatedClientConnection wrappedConn) throws ConnectionShutdownException {
        void var1_1;
        if (this.isReleased() || var1_1 == null) {
            throw new ConnectionShutdownException();
        }
    }

    /*
     * WARNING - void declaration
     */
    public boolean isOpen() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        if (conn == null) {
            return false;
        }
        return var1_1.isOpen();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isStale() {
        void var1_1;
        if (this.isReleased()) {
            return true;
        }
        OperatedClientConnection conn = this.getWrappedConnection();
        if (conn == null) {
            return true;
        }
        return var1_1.isStale();
    }

    /*
     * WARNING - void declaration
     */
    public void setSocketTimeout(int timeout) {
        void var1_1;
        void var2_2;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        var2_2.setSocketTimeout((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public int getSocketTimeout() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return var1_1.getSocketTimeout();
    }

    /*
     * WARNING - void declaration
     */
    public HttpConnectionMetrics getMetrics() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return var1_1.getMetrics();
    }

    /*
     * WARNING - void declaration
     */
    public void flush() throws IOException {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        var1_1.flush();
    }

    /*
     * WARNING - void declaration
     */
    public boolean isResponseAvailable(int timeout) throws IOException {
        void var1_1;
        void var2_2;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return var2_2.isResponseAvailable((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void receiveResponseEntity(HttpResponse response) throws HttpException, IOException {
        void var1_1;
        void var2_2;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        var2_2.receiveResponseEntity((HttpResponse)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public HttpResponse receiveResponseHeader() throws HttpException, IOException {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        return var1_1.receiveResponseHeader();
    }

    /*
     * WARNING - void declaration
     */
    public void sendRequestEntity(HttpEntityEnclosingRequest request) throws HttpException, IOException {
        void var1_1;
        void var2_2;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        var2_2.sendRequestEntity((HttpEntityEnclosingRequest)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public void sendRequestHeader(HttpRequest request) throws HttpException, IOException {
        void var1_1;
        void var2_2;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        this.unmarkReusable();
        var2_2.sendRequestHeader((HttpRequest)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public InetAddress getLocalAddress() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return var1_1.getLocalAddress();
    }

    /*
     * WARNING - void declaration
     */
    public int getLocalPort() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return var1_1.getLocalPort();
    }

    /*
     * WARNING - void declaration
     */
    public InetAddress getRemoteAddress() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return var1_1.getRemoteAddress();
    }

    /*
     * WARNING - void declaration
     */
    public int getRemotePort() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return var1_1.getRemotePort();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isSecure() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        return var1_1.isSecure();
    }

    @Override
    public void bind(Socket socket) throws IOException {
        throw new UnsupportedOperationException();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Socket getSocket() {
        void var1_1;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (!this.isOpen()) {
            return null;
        }
        return var1_1.getSocket();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public SSLSession getSSLSession() {
        void var2_2;
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (!this.isOpen()) {
            return null;
        }
        SSLSession result = null;
        Socket sock = conn.getSocket();
        if (sock instanceof SSLSocket) {
            void var1_1;
            result = ((SSLSocket)var1_1).getSession();
        }
        return var2_2;
    }

    @Override
    public void markReusable() {
        this.markedReusable = true;
    }

    @Override
    public void unmarkReusable() {
        this.markedReusable = false;
    }

    @Override
    public boolean isMarkedReusable() {
        return this.markedReusable;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setIdleDuration(long duration, TimeUnit unit) {
        if (duration > 0L) {
            void var1_1;
            void var3_2;
            this.duration = var3_2.toMillis((long)var1_1);
            return;
        }
        this.duration = -1L;
    }

    @Override
    public synchronized void releaseConnection() {
        if (this.released) {
            return;
        }
        this.released = true;
        AbstractClientConnAdapter abstractClientConnAdapter = this;
        this.connManager.releaseConnection(abstractClientConnAdapter, abstractClientConnAdapter.duration, TimeUnit.MILLISECONDS);
    }

    @Override
    public synchronized void abortConnection() {
        if (this.released) {
            return;
        }
        this.released = true;
        this.unmarkReusable();
        try {
            this.shutdown();
        }
        catch (IOException iOException) {}
        AbstractClientConnAdapter abstractClientConnAdapter = this;
        this.connManager.releaseConnection(abstractClientConnAdapter, abstractClientConnAdapter.duration, TimeUnit.MILLISECONDS);
    }

    /*
     * WARNING - void declaration
     */
    public Object getAttribute(String id) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (conn instanceof HttpContext) {
            void var1_1;
            void var2_2;
            return ((HttpContext)var2_2).getAttribute((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public Object removeAttribute(String id) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (conn instanceof HttpContext) {
            void var1_1;
            void var2_2;
            return ((HttpContext)var2_2).removeAttribute((String)var1_1);
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    public void setAttribute(String id, Object obj) {
        OperatedClientConnection conn = this.getWrappedConnection();
        this.assertValid(conn);
        if (conn instanceof HttpContext) {
            void var2_2;
            void var1_1;
            void var3_3;
            ((HttpContext)var3_3).setAttribute((String)var1_1, (Object)var2_2);
        }
    }
}

