/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.Authenticator;
import java.net.PasswordAuthentication;
import java.util.Locale;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.HttpHost;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.NTCredentials;
import org.apache.http.auth.UsernamePasswordCredentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.util.Args;

@ThreadSafe
public class SystemDefaultCredentialsProvider
implements CredentialsProvider {
    private static final Map<String, String> SCHEME_MAP = new ConcurrentHashMap<String, String>();
    private final BasicCredentialsProvider internal = new BasicCredentialsProvider();

    /*
     * WARNING - void declaration
     */
    private static String translateScheme(String key) {
        String string;
        if (key == null) {
            return null;
        }
        String s = SCHEME_MAP.get(key);
        if (s != null) {
            void var1_1;
            return var1_1;
        }
        return string;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        void var2_2;
        void var1_1;
        this.internal.setCredentials((AuthScope)var1_1, (Credentials)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static PasswordAuthentication getSystemCreds(AuthScope authscope, Authenticator.RequestorType requestorType) {
        void var1_1;
        AuthScope authScope;
        void var3_3;
        void var2_2;
        String hostname = authscope.getHost();
        int port = authscope.getPort();
        HttpHost origin = authscope.getOrigin();
        String protocol = origin != null ? origin.getSchemeName() : (port == 443 ? "https" : "http");
        return Authenticator.requestPasswordAuthentication((String)var2_2, null, (int)var3_3, protocol, null, SystemDefaultCredentialsProvider.translateScheme(authScope.getScheme()), null, (Authenticator.RequestorType)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Credentials getCredentials(AuthScope authscope) {
        Args.notNull((Object)authscope, (String)"Auth scope");
        Credentials localcreds = this.internal.getCredentials(authscope);
        if (localcreds != null) {
            return localcreds;
        }
        if (authscope.getHost() != null) {
            PasswordAuthentication systemcreds = SystemDefaultCredentialsProvider.getSystemCreds(authscope, Authenticator.RequestorType.SERVER);
            if (systemcreds == null) {
                systemcreds = SystemDefaultCredentialsProvider.getSystemCreds(authscope, Authenticator.RequestorType.PROXY);
            }
            if (systemcreds != null) {
                void var2_2;
                void var1_1;
                String domain = System.getProperty("http.auth.ntlm.domain");
                if (domain != null) {
                    void var3_3;
                    return new NTCredentials(systemcreds.getUserName(), new String(systemcreds.getPassword()), null, (String)var3_3);
                }
                if ("NTLM".equalsIgnoreCase(var1_1.getScheme())) {
                    return new NTCredentials(systemcreds.getUserName(), new String(systemcreds.getPassword()), null, null);
                }
                return new UsernamePasswordCredentials(systemcreds.getUserName(), new String(var2_2.getPassword()));
            }
        }
        return null;
    }

    @Override
    public void clear() {
        this.internal.clear();
    }

    static {
        SCHEME_MAP.put("Basic".toUpperCase(Locale.ROOT), "Basic");
        SCHEME_MAP.put("Digest".toUpperCase(Locale.ROOT), "Digest");
        SCHEME_MAP.put("NTLM".toUpperCase(Locale.ROOT), "NTLM");
        SCHEME_MAP.put("Negotiate".toUpperCase(Locale.ROOT), "SPNEGO");
        SCHEME_MAP.put("Kerberos".toUpperCase(Locale.ROOT), "Kerberos");
    }
}

