/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.http.HttpRequest;
import org.apache.http.ProtocolException;
import org.apache.http.ProtocolVersion;
import org.apache.http.RequestLine;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.message.AbstractHttpMessage;
import org.apache.http.message.BasicRequestLine;
import org.apache.http.params.HttpParams;
import org.apache.http.params.HttpProtocolParams;
import org.apache.http.util.Args;

@Deprecated
@NotThreadSafe
public class RequestWrapper
extends AbstractHttpMessage
implements HttpUriRequest {
    private final HttpRequest original;
    private URI uri;
    private String method;
    private ProtocolVersion version;
    private int execCount;

    /*
     * WARNING - void declaration
     */
    public RequestWrapper(HttpRequest request) throws ProtocolException {
        Args.notNull((Object)request, (String)"HTTP request");
        this.original = request;
        this.setParams(request.getParams());
        this.setHeaders(request.getAllHeaders());
        if (request instanceof HttpUriRequest) {
            this.uri = ((HttpUriRequest)request).getURI();
            this.method = ((HttpUriRequest)request).getMethod();
            this.version = null;
        } else {
            void var1_1;
            void var2_3;
            RequestLine requestLine = request.getRequestLine();
            try {
                this.uri = new URI(requestLine.getUri());
            }
            catch (URISyntaxException ex) {
                void var1_2;
                throw new ProtocolException("Invalid request URI: " + requestLine.getUri(), (Throwable)var1_2);
            }
            this.method = var2_3.getMethod();
            this.version = var1_1.getProtocolVersion();
        }
        this.execCount = 0;
    }

    public void resetHeaders() {
        this.headergroup.clear();
        RequestWrapper requestWrapper = this;
        requestWrapper.setHeaders(requestWrapper.original.getAllHeaders());
    }

    @Override
    public String getMethod() {
        return this.method;
    }

    /*
     * WARNING - void declaration
     */
    public void setMethod(String method) {
        void var1_1;
        Args.notNull((Object)method, (String)"Method name");
        this.method = var1_1;
    }

    public ProtocolVersion getProtocolVersion() {
        if (this.version == null) {
            this.version = HttpProtocolParams.getVersion((HttpParams)this.getParams());
        }
        return this.version;
    }

    /*
     * WARNING - void declaration
     */
    public void setProtocolVersion(ProtocolVersion version) {
        void var1_1;
        this.version = var1_1;
    }

    @Override
    public URI getURI() {
        return this.uri;
    }

    /*
     * WARNING - void declaration
     */
    public void setURI(URI uri) {
        void var1_1;
        this.uri = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public RequestLine getRequestLine() {
        void var1_1;
        void var2_2;
        ProtocolVersion ver = this.getProtocolVersion();
        String uritext = null;
        if (this.uri != null) {
            uritext = this.uri.toASCIIString();
        }
        if (uritext == null || uritext.isEmpty()) {
            uritext = "/";
        }
        return new BasicRequestLine(this.getMethod(), (String)var2_2, (ProtocolVersion)var1_1);
    }

    @Override
    public void abort() throws UnsupportedOperationException {
        throw new UnsupportedOperationException();
    }

    @Override
    public boolean isAborted() {
        return false;
    }

    public HttpRequest getOriginal() {
        return this.original;
    }

    public boolean isRepeatable() {
        return true;
    }

    public int getExecCount() {
        return this.execCount;
    }

    public void incrementExecCount() {
        ++this.execCount;
    }
}

