/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.concurrent.ThreadFactory;
import java.util.concurrent.TimeUnit;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.http.util.Args;

public final class IdleConnectionEvictor {
    private final HttpClientConnectionManager connectionManager;
    private final ThreadFactory threadFactory;
    private final Thread thread;
    private final long sleepTimeMs;
    private final long maxIdleTimeMs;
    private volatile Exception exception;

    /*
     * WARNING - void declaration
     */
    public IdleConnectionEvictor(HttpClientConnectionManager connectionManager, ThreadFactory threadFactory, long sleepTime, TimeUnit sleepTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        void var1_1;
        void var3_3;
        void var2_2;
        this.connectionManager = (HttpClientConnectionManager)Args.notNull((Object)connectionManager, (String)"Connection manager");
        this.threadFactory = threadFactory != null ? var2_2 : new DefaultThreadFactory();
        this.sleepTimeMs = sleepTimeUnit != null ? sleepTimeUnit.toMillis(sleepTime) : var3_3;
        this.maxIdleTimeMs = maxIdleTimeUnit != null ? maxIdleTimeUnit.toMillis(maxIdleTime) : maxIdleTime;
        this.thread = this.threadFactory.newThread(new Runnable((HttpClientConnectionManager)var1_1){
            final /* synthetic */ HttpClientConnectionManager val$connectionManager;
            {
                this.val$connectionManager = httpClientConnectionManager;
            }

            /*
             * WARNING - void declaration
             */
            @Override
            public void run() {
                try {
                    while (!Thread.currentThread().isInterrupted()) {
                        Thread.sleep(IdleConnectionEvictor.this.sleepTimeMs);
                        this.val$connectionManager.closeExpiredConnections();
                        if (IdleConnectionEvictor.this.maxIdleTimeMs <= 0L) continue;
                        this.val$connectionManager.closeIdleConnections(IdleConnectionEvictor.this.maxIdleTimeMs, TimeUnit.MILLISECONDS);
                    }
                    return;
                }
                catch (Exception ex) {
                    void var1_1;
                    IdleConnectionEvictor.access$202(IdleConnectionEvictor.this, (Exception)var1_1);
                    return;
                }
            }
        });
    }

    /*
     * WARNING - void declaration
     */
    public IdleConnectionEvictor(HttpClientConnectionManager connectionManager, long sleepTime, TimeUnit sleepTimeUnit, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this((HttpClientConnectionManager)var1_1, null, (long)var2_2, sleepTimeUnit, maxIdleTime, maxIdleTimeUnit);
        void var2_2;
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public IdleConnectionEvictor(HttpClientConnectionManager connectionManager, long maxIdleTime, TimeUnit maxIdleTimeUnit) {
        this((HttpClientConnectionManager)var1_1, null, maxIdleTime > 0L ? maxIdleTime : 5L, maxIdleTimeUnit != null ? maxIdleTimeUnit : TimeUnit.SECONDS, (long)var2_2, maxIdleTimeUnit);
        void var2_2;
        void var1_1;
    }

    public final void start() {
        this.thread.start();
    }

    public final void shutdown() {
        this.thread.interrupt();
    }

    public final boolean isRunning() {
        return this.thread.isAlive();
    }

    /*
     * WARNING - void declaration
     */
    public final void awaitTermination(long time, TimeUnit tunit) throws InterruptedException {
        void var1_1;
        void var3_2;
        this.thread.join(((TimeUnit)((Object)(tunit != null ? var3_2 : TimeUnit.MILLISECONDS))).toMillis((long)var1_1));
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Exception access$202(IdleConnectionEvictor x0, Exception x1) {
        void var1_1;
        x0.exception = var1_1;
        return x0.exception;
    }

    static class DefaultThreadFactory
    implements ThreadFactory {
        DefaultThreadFactory() {
        }

        /*
         * WARNING - void declaration
         */
        @Override
        public Thread newThread(Runnable r) {
            void var1_1;
            Thread t = new Thread(r, "Connection evictor");
            t.setDaemon(true);
            return var1_1;
        }
    }
}

