/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.concurrent.Callable;
import java.util.concurrent.atomic.AtomicBoolean;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.concurrent.FutureCallback;
import org.apache.http.impl.client.FutureRequestExecutionMetrics;
import org.apache.http.protocol.HttpContext;

class HttpRequestTaskCallable<V>
implements Callable<V> {
    private final HttpUriRequest request;
    private final HttpClient httpclient;
    private final AtomicBoolean cancelled = new AtomicBoolean(false);
    private final long scheduled = System.currentTimeMillis();
    private long started = -1L;
    private long ended = -1L;
    private final HttpContext context;
    private final ResponseHandler<V> responseHandler;
    private final FutureCallback<V> callback;
    private final FutureRequestExecutionMetrics metrics;

    /*
     * WARNING - void declaration
     */
    HttpRequestTaskCallable(HttpClient httpClient, HttpUriRequest request, HttpContext context, ResponseHandler<V> responseHandler, FutureCallback<V> callback, FutureRequestExecutionMetrics metrics) {
        void var3_3;
        void var2_2;
        void var1_1;
        this.httpclient = var1_1;
        this.responseHandler = responseHandler;
        this.request = var2_2;
        this.context = var3_3;
        this.callback = callback;
        this.metrics = metrics;
    }

    public long getScheduled() {
        return this.scheduled;
    }

    public long getStarted() {
        return this.started;
    }

    public long getEnded() {
        return this.ended;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public V call() throws Exception {
        if (!this.cancelled.get()) {
            try {
                V result;
                block8: {
                    this.metrics.getActiveConnections().incrementAndGet();
                    this.started = System.currentTimeMillis();
                    try {
                        this.metrics.getScheduledConnections().decrementAndGet();
                        result = this.httpclient.execute(this.request, this.responseHandler, this.context);
                        this.ended = System.currentTimeMillis();
                        this.metrics.getSuccessfulConnections().increment(this.started);
                        if (this.callback == null) break block8;
                        this.callback.completed(result);
                    }
                    catch (Exception e) {
                        void var1_2;
                        this.metrics.getFailedConnections().increment(this.started);
                        this.ended = System.currentTimeMillis();
                        if (this.callback != null) {
                            this.callback.failed(e);
                        }
                        throw var1_2;
                    }
                }
                return result;
            }
            finally {
                this.metrics.getRequests().increment(this.started);
                this.metrics.getTasks().increment(this.started);
                this.metrics.getActiveConnections().decrementAndGet();
            }
        }
        throw new IllegalStateException("call has been cancelled for request " + this.request.getURI());
    }

    public void cancel() {
        this.cancelled.set(true);
        if (this.callback != null) {
            this.callback.cancelled();
        }
    }
}

