/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.concurrent.atomic.AtomicLong;

public final class FutureRequestExecutionMetrics {
    private final AtomicLong activeConnections = new AtomicLong();
    private final AtomicLong scheduledConnections = new AtomicLong();
    private final DurationCounter successfulConnections = new DurationCounter();
    private final DurationCounter failedConnections = new DurationCounter();
    private final DurationCounter requests = new DurationCounter();
    private final DurationCounter tasks = new DurationCounter();

    FutureRequestExecutionMetrics() {
    }

    final AtomicLong getActiveConnections() {
        return this.activeConnections;
    }

    final AtomicLong getScheduledConnections() {
        return this.scheduledConnections;
    }

    final DurationCounter getSuccessfulConnections() {
        return this.successfulConnections;
    }

    final DurationCounter getFailedConnections() {
        return this.failedConnections;
    }

    final DurationCounter getRequests() {
        return this.requests;
    }

    final DurationCounter getTasks() {
        return this.tasks;
    }

    public final long getActiveConnectionCount() {
        return this.activeConnections.get();
    }

    public final long getScheduledConnectionCount() {
        return this.scheduledConnections.get();
    }

    public final long getSuccessfulConnectionCount() {
        return this.successfulConnections.count();
    }

    public final long getSuccessfulConnectionAverageDuration() {
        return this.successfulConnections.averageDuration();
    }

    public final long getFailedConnectionCount() {
        return this.failedConnections.count();
    }

    public final long getFailedConnectionAverageDuration() {
        return this.failedConnections.averageDuration();
    }

    public final long getRequestCount() {
        return this.requests.count();
    }

    public final long getRequestAverageDuration() {
        return this.requests.averageDuration();
    }

    public final long getTaskCount() {
        return this.tasks.count();
    }

    public final long getTaskAverageDuration() {
        return this.tasks.averageDuration();
    }

    /*
     * WARNING - void declaration
     */
    public final String toString() {
        void var1_1;
        StringBuilder builder = new StringBuilder();
        builder.append("[activeConnections=").append(this.activeConnections).append(", scheduledConnections=").append(this.scheduledConnections).append(", successfulConnections=").append(this.successfulConnections).append(", failedConnections=").append(this.failedConnections).append(", requests=").append(this.requests).append(", tasks=").append(this.tasks).append("]");
        return var1_1.toString();
    }

    static class DurationCounter {
        private final AtomicLong count = new AtomicLong(0L);
        private final AtomicLong cumulativeDuration = new AtomicLong(0L);

        DurationCounter() {
        }

        /*
         * WARNING - void declaration
         */
        public void increment(long startTime) {
            void var1_1;
            this.count.incrementAndGet();
            this.cumulativeDuration.addAndGet(System.currentTimeMillis() - var1_1);
        }

        public long count() {
            return this.count.get();
        }

        /*
         * WARNING - void declaration
         */
        public long averageDuration() {
            long counter = this.count.get();
            if (counter > 0L) {
                void var1_1;
                return this.cumulativeDuration.get() / var1_1;
            }
            return 0L;
        }

        /*
         * WARNING - void declaration
         */
        public String toString() {
            void var1_1;
            StringBuilder builder = new StringBuilder();
            builder.append("[count=").append(this.count()).append(", averageDuration=").append(this.averageDuration()).append("]");
            return var1_1.toString();
        }
    }
}

