/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.net.URI;
import java.net.URISyntaxException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpResponse;
import org.apache.http.ProtocolException;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.CircularRedirectException;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.impl.client.RedirectLocations;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.Asserts;

@Deprecated
@Immutable
public class DefaultRedirectHandler
implements RedirectHandler {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String REDIRECT_LOCATIONS = "http.protocol.redirect-locations";

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isRedirectRequested(HttpResponse response22, HttpContext context) {
        Args.notNull((Object)response22, (String)"HTTP response");
        int response22 = response22.getStatusLine().getStatusCode();
        switch (response22) {
            case 301: 
            case 302: 
            case 307: {
                void var1_3;
                void var2_4;
                HttpRequest response22 = (HttpRequest)var2_4.getAttribute("http.request");
                String method = response22.getRequestLine().getMethod();
                return method.equalsIgnoreCase("GET") || var1_3.equalsIgnoreCase("HEAD");
            }
            case 303: {
                return true;
            }
        }
        return false;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public URI getLocationURI(HttpResponse response, HttpContext context) throws ProtocolException {
        void var1_1;
        URI uri;
        Args.notNull((Object)response, (String)"HTTP response");
        Header locationHeader = response.getFirstHeader("location");
        if (locationHeader == null) {
            throw new ProtocolException("Received redirect response " + response.getStatusLine() + " but no location header");
        }
        String location = locationHeader.getValue();
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Redirect requested to location '" + location + "'"));
        }
        try {
            uri = new URI(location);
        }
        catch (URISyntaxException ex) {
            throw new ProtocolException("Invalid redirect URI: " + location, (Throwable)ex);
        }
        HttpParams params = ex.getParams();
        if (!uri.isAbsolute()) {
            if (params.isParameterTrue("http.protocol.reject-relative-redirect")) {
                throw new ProtocolException("Relative redirect location '" + uri + "' not allowed");
            }
            Object target = (HttpHost)context.getAttribute("http.target_host");
            Asserts.notNull((Object)target, (String)"Target host");
            Object request = (HttpRequest)context.getAttribute("http.request");
            try {
                request = new URI(request.getRequestLine().getUri());
                target = URIUtils.rewriteURI((URI)request, target, true);
                uri = URIUtils.resolve((URI)target, uri);
            }
            catch (URISyntaxException ex) {
                throw new ProtocolException(ex.getMessage(), (Throwable)ex);
            }
        }
        if (var1_1.isParameterFalse("http.protocol.allow-circular-redirects")) {
            void var3_4;
            URI uRI;
            RedirectLocations redirectLocations = (RedirectLocations)context.getAttribute(REDIRECT_LOCATIONS);
            if (redirectLocations == null) {
                void var2_3;
                redirectLocations = new RedirectLocations();
                var2_3.setAttribute(REDIRECT_LOCATIONS, (Object)redirectLocations);
            }
            if (uri.getFragment() != null) {
                try {
                    HttpHost target = new HttpHost(uri.getHost(), uri.getPort(), uri.getScheme());
                    URI redirectURI = URIUtils.rewriteURI(uri, target, true);
                }
                catch (URISyntaxException ex) {
                    throw new ProtocolException(ex.getMessage(), (Throwable)ex);
                }
            } else {
                uRI = uri;
            }
            if (redirectLocations.contains(uRI)) {
                throw new CircularRedirectException("Circular redirect to '" + uRI + "'");
            }
            var3_4.add(uRI);
        }
        return uri;
    }
}

