/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.io.InterruptedIOException;
import java.net.ConnectException;
import java.net.UnknownHostException;
import java.util.Arrays;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import javax.net.ssl.SSLException;
import org.apache.http.HttpEntityEnclosingRequest;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.Immutable;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.protocol.HttpClientContext;
import org.apache.http.impl.client.RequestWrapper;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Immutable
public class DefaultHttpRequestRetryHandler
implements HttpRequestRetryHandler {
    public static final DefaultHttpRequestRetryHandler INSTANCE = new DefaultHttpRequestRetryHandler();
    private final int retryCount;
    private final boolean requestSentRetryEnabled;
    private final Set<Class<? extends IOException>> nonRetriableClasses;

    /*
     * WARNING - void declaration
     */
    protected DefaultHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled, Collection<Class<? extends IOException>> clazzes) {
        void var3_5;
        this.retryCount = retryCount;
        this.requestSentRetryEnabled = requestSentRetryEnabled;
        this.nonRetriableClasses = new HashSet<Class<? extends IOException>>();
        for (Class clazz : var3_5) {
            void var2_4;
            this.nonRetriableClasses.add((Class<? extends IOException>)var2_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    public DefaultHttpRequestRetryHandler(int retryCount, boolean requestSentRetryEnabled) {
        this((int)var1_1, (boolean)var2_2, Arrays.asList(InterruptedIOException.class, UnknownHostException.class, ConnectException.class, SSLException.class));
        void var2_2;
        void var1_1;
    }

    public DefaultHttpRequestRetryHandler() {
        this(3, false);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean retryRequest(IOException exception, int executionCount, HttpContext context) {
        void var2_3;
        void var3_4;
        Args.notNull((Object)exception, (String)"Exception parameter");
        Args.notNull((Object)context, (String)"HTTP context");
        if (executionCount > this.retryCount) {
            return false;
        }
        if (this.nonRetriableClasses.contains(exception.getClass())) {
            return false;
        }
        for (Class<? extends IOException> clazz : this.nonRetriableClasses) {
            if (!clazz.isInstance(exception)) continue;
            return false;
        }
        HttpClientContext clientContext = HttpClientContext.adapt((HttpContext)var3_4);
        HttpRequest request = clientContext.getRequest();
        if (this.requestIsAborted(request)) {
            return false;
        }
        if (this.handleAsIdempotent(request)) {
            return true;
        }
        return !var2_3.isRequestSent() || this.requestSentRetryEnabled;
    }

    public boolean isRequestSentRetryEnabled() {
        return this.requestSentRetryEnabled;
    }

    public int getRetryCount() {
        return this.retryCount;
    }

    protected boolean handleAsIdempotent(HttpRequest request) {
        return !(request instanceof HttpEntityEnclosingRequest);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected boolean requestIsAborted(HttpRequest request) {
        void var2_2;
        HttpRequest req = request;
        if (request instanceof RequestWrapper) {
            void var1_1;
            req = ((RequestWrapper)var1_1).getOriginal();
        }
        return req instanceof HttpUriRequest && ((HttpUriRequest)var2_2).isAborted();
    }
}

