/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.Closeable;
import java.io.IOException;
import java.net.URI;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpEntity;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.HttpClient;
import org.apache.http.client.ResponseHandler;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.methods.HttpUriRequest;
import org.apache.http.client.utils.URIUtils;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.EntityUtils;

@ThreadSafe
public abstract class CloseableHttpClient
implements Closeable,
HttpClient {
    private final Log log = LogFactory.getLog(this.getClass());

    protected abstract CloseableHttpResponse doExecute(HttpHost var1, HttpRequest var2, HttpContext var3) throws IOException, ClientProtocolException;

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.doExecute((HttpHost)var1_1, (HttpRequest)var2_2, (HttpContext)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseableHttpResponse execute(HttpUriRequest request, HttpContext context) throws IOException, ClientProtocolException {
        void var2_2;
        void var1_1;
        Args.notNull((Object)request, (String)"HTTP request");
        return this.doExecute(CloseableHttpClient.determineTarget(request), (HttpRequest)var1_1, (HttpContext)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static HttpHost determineTarget(HttpUriRequest request) throws ClientProtocolException {
        void var1_1;
        HttpHost target = null;
        URI requestURI = request.getURI();
        if (requestURI.isAbsolute() && (target = URIUtils.extractHost(requestURI)) == null) {
            URI uRI;
            throw new ClientProtocolException("URI does not specify a valid host name: " + uRI);
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseableHttpResponse execute(HttpUriRequest request) throws IOException, ClientProtocolException {
        void var1_1;
        return this.execute((HttpUriRequest)var1_1, (HttpContext)null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public CloseableHttpResponse execute(HttpHost target, HttpRequest request) throws IOException, ClientProtocolException {
        void var2_2;
        void var1_1;
        return this.doExecute((HttpHost)var1_1, (HttpRequest)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        void var2_2;
        void var1_1;
        return this.execute((HttpUriRequest)var1_1, (ResponseHandler<? extends T>)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T execute(HttpUriRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        void var3_3;
        void var2_2;
        void var1_1;
        HttpHost target = CloseableHttpClient.determineTarget(request);
        return this.execute(target, (HttpRequest)var1_1, (ResponseHandler<? extends T>)var2_2, (HttpContext)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler) throws IOException, ClientProtocolException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.execute((HttpHost)var1_1, (HttpRequest)var2_2, (ResponseHandler<? extends T>)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public <T> T execute(HttpHost target, HttpRequest request, ResponseHandler<? extends T> responseHandler, HttpContext context) throws IOException, ClientProtocolException {
        Args.notNull(responseHandler, (String)"Response handler");
        CloseableHttpResponse response = this.execute(target, request, context);
        try {
            T result = responseHandler.handleResponse(response);
            responseHandler = response.getEntity();
            EntityUtils.consume((HttpEntity)responseHandler);
            responseHandler = result;
        }
        catch (ClientProtocolException t) {
            try {
                void var2_3;
                HttpEntity entity = response.getEntity();
                try {
                    EntityUtils.consume((HttpEntity)entity);
                }
                catch (Exception t2) {
                    void var3_6;
                    this.log.warn((Object)"Error consuming content after an exception.", (Throwable)var3_6);
                }
                throw var2_3;
            }
            catch (Throwable throwable) {
                void var1_1;
                var1_1.close();
                throw throwable;
            }
        }
        response.close();
        return (T)responseHandler;
    }
}

