/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.Credentials;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.util.Args;

@ThreadSafe
public class BasicCredentialsProvider
implements CredentialsProvider {
    private final ConcurrentHashMap<AuthScope, Credentials> credMap = new ConcurrentHashMap();

    /*
     * WARNING - void declaration
     */
    @Override
    public void setCredentials(AuthScope authscope, Credentials credentials) {
        void var2_2;
        void var1_1;
        Args.notNull((Object)authscope, (String)"Authentication scope");
        this.credMap.put((AuthScope)var1_1, (Credentials)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    private static Credentials matchCredentials(Map<AuthScope, Credentials> map, AuthScope authscope) {
        void var2_2;
        Credentials creds = map.get(authscope);
        if (creds == null) {
            int bestMatchFactor = -1;
            AuthScope bestMatch = null;
            for (AuthScope current : map.keySet()) {
                int factor = authscope.match(current);
                if (factor <= bestMatchFactor) continue;
                bestMatchFactor = factor;
                bestMatch = current;
            }
            if (bestMatch != null) {
                Map<AuthScope, Credentials> map2;
                creds = map2.get(bestMatch);
            }
        }
        return var2_2;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Credentials getCredentials(AuthScope authscope) {
        void var1_1;
        Args.notNull((Object)authscope, (String)"Authentication scope");
        return BasicCredentialsProvider.matchCredentials(this.credMap, (AuthScope)var1_1);
    }

    @Override
    public void clear() {
        this.credMap.clear();
    }

    public String toString() {
        return this.credMap.toString();
    }
}

