/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.Serializable;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.HttpHost;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.auth.AuthScheme;
import org.apache.http.client.AuthCache;
import org.apache.http.conn.SchemePortResolver;
import org.apache.http.conn.UnsupportedSchemeException;
import org.apache.http.impl.conn.DefaultSchemePortResolver;
import org.apache.http.util.Args;

@ThreadSafe
public class BasicAuthCache
implements AuthCache {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Map<HttpHost, byte[]> map = new ConcurrentHashMap<HttpHost, byte[]>();
    private final SchemePortResolver schemePortResolver;

    /*
     * WARNING - void declaration
     */
    public BasicAuthCache(SchemePortResolver schemePortResolver) {
        void var1_1;
        this.schemePortResolver = schemePortResolver != null ? var1_1 : DefaultSchemePortResolver.INSTANCE;
    }

    public BasicAuthCache() {
        this(null);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpHost getKey(HttpHost host) {
        void var1_1;
        if (host.getPort() <= 0) {
            void var2_2;
            try {
                int port = this.schemePortResolver.resolve(host);
            }
            catch (UnsupportedSchemeException unsupportedSchemeException) {
                return host;
            }
            return new HttpHost(host.getHostName(), (int)var2_2, host.getSchemeName());
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void put(HttpHost host, AuthScheme authScheme) {
        Args.notNull((Object)host, (String)"HTTP host");
        if (authScheme == null) {
            return;
        }
        if (authScheme instanceof Serializable) {
            try {
                void var1_1;
                ByteArrayOutputStream buf = new ByteArrayOutputStream();
                ObjectOutputStream out = new ObjectOutputStream(buf);
                out.writeObject(authScheme);
                out.close();
                this.map.put(this.getKey((HttpHost)var1_1), buf.toByteArray());
                return;
            }
            catch (IOException ex) {
                if (this.log.isWarnEnabled()) {
                    void var3_4;
                    this.log.warn((Object)"Unexpected I/O error while serializing auth scheme", (Throwable)var3_4);
                }
                return;
            }
        }
        if (this.log.isDebugEnabled()) {
            void var2_2;
            this.log.debug((Object)("Auth scheme " + var2_2.getClass() + " is not serializable"));
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public AuthScheme get(HttpHost host) {
        Args.notNull((Object)host, (String)"HTTP host");
        byte[] bytes = this.map.get(this.getKey(host));
        if (bytes != null) {
            try {
                void var2_4;
                ByteArrayInputStream buf = new ByteArrayInputStream(bytes);
                ObjectInputStream in = new ObjectInputStream(buf);
                AuthScheme authScheme = (AuthScheme)in.readObject();
                in.close();
                return var2_4;
            }
            catch (IOException ex) {
                if (this.log.isWarnEnabled()) {
                    this.log.warn((Object)"Unexpected I/O error while de-serializing auth scheme", (Throwable)ex);
                }
                return null;
            }
            catch (ClassNotFoundException ex) {
                if (this.log.isWarnEnabled()) {
                    void var1_3;
                    this.log.warn((Object)"Unexpected error while de-serializing auth scheme", (Throwable)var1_3);
                }
                return null;
            }
        }
        return null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void remove(HttpHost host) {
        void var1_1;
        Args.notNull((Object)host, (String)"HTTP host");
        this.map.remove(this.getKey((HttpHost)var1_1));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

