/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.LinkedList;
import java.util.Locale;
import java.util.Map;
import java.util.Queue;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpResponse;
import org.apache.http.annotation.Immutable;
import org.apache.http.auth.AuthOption;
import org.apache.http.auth.AuthScheme;
import org.apache.http.auth.AuthScope;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.client.AuthCache;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.impl.client.BasicAuthCache;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;

@Deprecated
@Immutable
class AuthenticationStrategyAdaptor
implements AuthenticationStrategy {
    private final Log log = LogFactory.getLog(this.getClass());
    private final AuthenticationHandler handler;

    /*
     * WARNING - void declaration
     */
    public AuthenticationStrategyAdaptor(AuthenticationHandler handler) {
        void var1_1;
        this.handler = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public boolean isAuthenticationRequested(HttpHost authhost, HttpResponse response, HttpContext context) {
        void var3_3;
        void var2_2;
        return this.handler.isAuthenticationRequested((HttpResponse)var2_2, (HttpContext)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Map<String, Header> getChallenges(HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        void var3_3;
        void var2_2;
        return this.handler.getChallenges((HttpResponse)var2_2, (HttpContext)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Queue<AuthOption> select(Map<String, Header> challenges, HttpHost authhost, HttpResponse response, HttpContext context) throws MalformedChallengeException {
        void var2_2;
        AuthScheme authScheme;
        Args.notNull(challenges, (String)"Map of auth challenges");
        Args.notNull((Object)authhost, (String)"Host");
        Args.notNull((Object)response, (String)"HTTP response");
        Args.notNull((Object)context, (String)"HTTP context");
        LinkedList<AuthOption> options = new LinkedList<AuthOption>();
        CredentialsProvider credsProvider = (CredentialsProvider)context.getAttribute("http.auth.credentials-provider");
        if (credsProvider == null) {
            this.log.debug((Object)"Credentials provider not set in the context");
            return options;
        }
        try {
            authScheme = this.handler.selectScheme(challenges, response, context);
        }
        catch (AuthenticationException ex) {
            if (this.log.isWarnEnabled()) {
                this.log.warn((Object)ex.getMessage(), (Throwable)((Object)ex));
            }
            return options;
        }
        String id = authScheme.getSchemeName();
        Header challenge = challenges.get(id.toLowerCase(Locale.ROOT));
        authScheme.processChallenge(challenge);
        AuthScope authScope = new AuthScope(authhost.getHostName(), var2_2.getPort(), authScheme.getRealm(), authScheme.getSchemeName());
        Credentials credentials = credsProvider.getCredentials(authScope);
        if (credentials != null) {
            void var1_1;
            void var3_3;
            options.add(new AuthOption((AuthScheme)var3_3, (Credentials)var1_1));
        }
        return options;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void authSucceeded(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        if (this.isCachable(authScheme)) {
            void var2_2;
            void var1_1;
            if (authCache == null) {
                void var3_3;
                authCache = new BasicAuthCache();
                var3_3.setAttribute("http.auth.auth-cache", (Object)authCache);
            }
            if (this.log.isDebugEnabled()) {
                this.log.debug((Object)("Caching '" + authScheme.getSchemeName() + "' auth scheme for " + authhost));
            }
            authCache.put((HttpHost)var1_1, (AuthScheme)var2_2);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void authFailed(HttpHost authhost, AuthScheme authScheme, HttpContext context) {
        void var1_1;
        void var3_3;
        AuthCache authCache = (AuthCache)context.getAttribute("http.auth.auth-cache");
        if (authCache == null) {
            return;
        }
        if (this.log.isDebugEnabled()) {
            void var2_2;
            this.log.debug((Object)("Removing from cache '" + var2_2.getSchemeName() + "' auth scheme for " + authhost));
        }
        var3_3.remove((HttpHost)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    private boolean isCachable(AuthScheme authScheme) {
        void var1_1;
        if (authScheme == null || !authScheme.isComplete()) {
            return false;
        }
        String schemeName = authScheme.getSchemeName();
        return schemeName.equalsIgnoreCase("Basic") || var1_1.equalsIgnoreCase("Digest");
    }

    public AuthenticationHandler getHandler() {
        return this.handler;
    }
}

