/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.io.IOException;
import java.lang.reflect.UndeclaredThrowableException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.ConnectionReuseStrategy;
import org.apache.http.HttpException;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.HttpRequestInterceptor;
import org.apache.http.HttpResponseInterceptor;
import org.apache.http.annotation.GuardedBy;
import org.apache.http.annotation.ThreadSafe;
import org.apache.http.auth.AuthSchemeRegistry;
import org.apache.http.client.AuthenticationHandler;
import org.apache.http.client.AuthenticationStrategy;
import org.apache.http.client.BackoffManager;
import org.apache.http.client.ClientProtocolException;
import org.apache.http.client.ConnectionBackoffStrategy;
import org.apache.http.client.CookieStore;
import org.apache.http.client.CredentialsProvider;
import org.apache.http.client.HttpRequestRetryHandler;
import org.apache.http.client.RedirectHandler;
import org.apache.http.client.RedirectStrategy;
import org.apache.http.client.RequestDirector;
import org.apache.http.client.UserTokenHandler;
import org.apache.http.client.config.RequestConfig;
import org.apache.http.client.methods.CloseableHttpResponse;
import org.apache.http.client.params.HttpClientParamConfig;
import org.apache.http.conn.ClientConnectionManager;
import org.apache.http.conn.ClientConnectionManagerFactory;
import org.apache.http.conn.ConnectionKeepAliveStrategy;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.conn.routing.HttpRoutePlanner;
import org.apache.http.conn.scheme.SchemeRegistry;
import org.apache.http.cookie.CookieSpecRegistry;
import org.apache.http.impl.DefaultConnectionReuseStrategy;
import org.apache.http.impl.auth.BasicSchemeFactory;
import org.apache.http.impl.auth.DigestSchemeFactory;
import org.apache.http.impl.auth.KerberosSchemeFactory;
import org.apache.http.impl.auth.NTLMSchemeFactory;
import org.apache.http.impl.auth.SPNegoSchemeFactory;
import org.apache.http.impl.client.AuthenticationStrategyAdaptor;
import org.apache.http.impl.client.BasicCookieStore;
import org.apache.http.impl.client.BasicCredentialsProvider;
import org.apache.http.impl.client.ClientParamsStack;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.CloseableHttpResponseProxy;
import org.apache.http.impl.client.DefaultConnectionKeepAliveStrategy;
import org.apache.http.impl.client.DefaultHttpRequestRetryHandler;
import org.apache.http.impl.client.DefaultProxyAuthenticationHandler;
import org.apache.http.impl.client.DefaultRedirectHandler;
import org.apache.http.impl.client.DefaultRedirectStrategy;
import org.apache.http.impl.client.DefaultRedirectStrategyAdaptor;
import org.apache.http.impl.client.DefaultRequestDirector;
import org.apache.http.impl.client.DefaultTargetAuthenticationHandler;
import org.apache.http.impl.client.DefaultUserTokenHandler;
import org.apache.http.impl.client.ProxyAuthenticationStrategy;
import org.apache.http.impl.client.TargetAuthenticationStrategy;
import org.apache.http.impl.conn.BasicClientConnectionManager;
import org.apache.http.impl.conn.DefaultHttpRoutePlanner;
import org.apache.http.impl.conn.SchemeRegistryFactory;
import org.apache.http.impl.cookie.BestMatchSpecFactory;
import org.apache.http.impl.cookie.BrowserCompatSpecFactory;
import org.apache.http.impl.cookie.IgnoreSpecFactory;
import org.apache.http.impl.cookie.NetscapeDraftSpecFactory;
import org.apache.http.impl.cookie.RFC2109SpecFactory;
import org.apache.http.impl.cookie.RFC2965SpecFactory;
import org.apache.http.params.HttpParams;
import org.apache.http.protocol.BasicHttpContext;
import org.apache.http.protocol.BasicHttpProcessor;
import org.apache.http.protocol.DefaultedHttpContext;
import org.apache.http.protocol.HttpContext;
import org.apache.http.protocol.HttpProcessor;
import org.apache.http.protocol.HttpRequestExecutor;
import org.apache.http.protocol.ImmutableHttpProcessor;
import org.apache.http.util.Args;

@Deprecated
@ThreadSafe
public abstract class AbstractHttpClient
extends CloseableHttpClient {
    private final Log log = LogFactory.getLog(this.getClass());
    @GuardedBy(value="this")
    private HttpParams defaultParams;
    @GuardedBy(value="this")
    private HttpRequestExecutor requestExec;
    @GuardedBy(value="this")
    private ClientConnectionManager connManager;
    @GuardedBy(value="this")
    private ConnectionReuseStrategy reuseStrategy;
    @GuardedBy(value="this")
    private ConnectionKeepAliveStrategy keepAliveStrategy;
    @GuardedBy(value="this")
    private CookieSpecRegistry supportedCookieSpecs;
    @GuardedBy(value="this")
    private AuthSchemeRegistry supportedAuthSchemes;
    @GuardedBy(value="this")
    private BasicHttpProcessor mutableProcessor;
    @GuardedBy(value="this")
    private ImmutableHttpProcessor protocolProcessor;
    @GuardedBy(value="this")
    private HttpRequestRetryHandler retryHandler;
    @GuardedBy(value="this")
    private RedirectStrategy redirectStrategy;
    @GuardedBy(value="this")
    private AuthenticationStrategy targetAuthStrategy;
    @GuardedBy(value="this")
    private AuthenticationStrategy proxyAuthStrategy;
    @GuardedBy(value="this")
    private CookieStore cookieStore;
    @GuardedBy(value="this")
    private CredentialsProvider credsProvider;
    @GuardedBy(value="this")
    private HttpRoutePlanner routePlanner;
    @GuardedBy(value="this")
    private UserTokenHandler userTokenHandler;
    @GuardedBy(value="this")
    private ConnectionBackoffStrategy connectionBackoffStrategy;
    @GuardedBy(value="this")
    private BackoffManager backoffManager;

    /*
     * WARNING - void declaration
     */
    protected AbstractHttpClient(ClientConnectionManager conman, HttpParams params) {
        void var1_1;
        void var2_2;
        this.defaultParams = var2_2;
        this.connManager = var1_1;
    }

    protected abstract HttpParams createHttpParams();

    protected abstract BasicHttpProcessor createHttpProcessor();

    /*
     * WARNING - void declaration
     */
    protected HttpContext createHttpContext() {
        void var1_1;
        BasicHttpContext context = new BasicHttpContext();
        context.setAttribute("http.scheme-registry", (Object)this.getConnectionManager().getSchemeRegistry());
        context.setAttribute("http.authscheme-registry", (Object)this.getAuthSchemes());
        context.setAttribute("http.cookiespec-registry", (Object)this.getCookieSpecs());
        context.setAttribute("http.cookie-store", (Object)this.getCookieStore());
        context.setAttribute("http.auth.credentials-provider", (Object)this.getCredentialsProvider());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected ClientConnectionManager createClientConnectionManager() {
        void var1_1;
        ClientConnectionManager connManager;
        void var2_2;
        void var3_3;
        SchemeRegistry registry = SchemeRegistryFactory.createDefault();
        HttpParams params = this.getParams();
        Object factory = null;
        String className = (String)params.getParameter("http.connection-manager.factory-class-name");
        if (className != null) {
            try {
                factory = Class.forName(className);
                factory = (ClientConnectionManagerFactory)((Class)factory).newInstance();
            }
            catch (ClassNotFoundException classNotFoundException) {
                throw new IllegalStateException("Invalid class name: " + className);
            }
            catch (IllegalAccessException ex) {
                throw new IllegalAccessError(ex.getMessage());
            }
            catch (InstantiationException ex) {
                void var3_5;
                throw new InstantiationError(var3_5.getMessage());
            }
        }
        connManager = var3_3 != null ? var3_3.newInstance((HttpParams)var2_2, registry) : new BasicClientConnectionManager((SchemeRegistry)((Object)connManager));
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected AuthSchemeRegistry createAuthSchemeRegistry() {
        void var1_1;
        AuthSchemeRegistry registry = new AuthSchemeRegistry();
        registry.register("Basic", new BasicSchemeFactory());
        registry.register("Digest", new DigestSchemeFactory());
        registry.register("NTLM", new NTLMSchemeFactory());
        registry.register("Negotiate", new SPNegoSchemeFactory());
        registry.register("Kerberos", new KerberosSchemeFactory());
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    protected CookieSpecRegistry createCookieSpecRegistry() {
        void var1_1;
        CookieSpecRegistry registry = new CookieSpecRegistry();
        registry.register("default", new BestMatchSpecFactory());
        registry.register("best-match", new BestMatchSpecFactory());
        registry.register("compatibility", new BrowserCompatSpecFactory());
        registry.register("netscape", new NetscapeDraftSpecFactory());
        registry.register("rfc2109", new RFC2109SpecFactory());
        registry.register("rfc2965", new RFC2965SpecFactory());
        registry.register("ignoreCookies", new IgnoreSpecFactory());
        return var1_1;
    }

    protected HttpRequestExecutor createRequestExecutor() {
        return new HttpRequestExecutor();
    }

    protected ConnectionReuseStrategy createConnectionReuseStrategy() {
        return new DefaultConnectionReuseStrategy();
    }

    protected ConnectionKeepAliveStrategy createConnectionKeepAliveStrategy() {
        return new DefaultConnectionKeepAliveStrategy();
    }

    protected HttpRequestRetryHandler createHttpRequestRetryHandler() {
        return new DefaultHttpRequestRetryHandler();
    }

    @Deprecated
    protected RedirectHandler createRedirectHandler() {
        return new DefaultRedirectHandler();
    }

    protected AuthenticationStrategy createTargetAuthenticationStrategy() {
        return new TargetAuthenticationStrategy();
    }

    @Deprecated
    protected AuthenticationHandler createTargetAuthenticationHandler() {
        return new DefaultTargetAuthenticationHandler();
    }

    protected AuthenticationStrategy createProxyAuthenticationStrategy() {
        return new ProxyAuthenticationStrategy();
    }

    @Deprecated
    protected AuthenticationHandler createProxyAuthenticationHandler() {
        return new DefaultProxyAuthenticationHandler();
    }

    protected CookieStore createCookieStore() {
        return new BasicCookieStore();
    }

    protected CredentialsProvider createCredentialsProvider() {
        return new BasicCredentialsProvider();
    }

    protected HttpRoutePlanner createHttpRoutePlanner() {
        return new DefaultHttpRoutePlanner(this.getConnectionManager().getSchemeRegistry());
    }

    protected UserTokenHandler createUserTokenHandler() {
        return new DefaultUserTokenHandler();
    }

    @Override
    public final synchronized HttpParams getParams() {
        if (this.defaultParams == null) {
            this.defaultParams = this.createHttpParams();
        }
        return this.defaultParams;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setParams(HttpParams params) {
        void var1_1;
        this.defaultParams = var1_1;
    }

    @Override
    public final synchronized ClientConnectionManager getConnectionManager() {
        if (this.connManager == null) {
            this.connManager = this.createClientConnectionManager();
        }
        return this.connManager;
    }

    public final synchronized HttpRequestExecutor getRequestExecutor() {
        if (this.requestExec == null) {
            this.requestExec = this.createRequestExecutor();
        }
        return this.requestExec;
    }

    public final synchronized AuthSchemeRegistry getAuthSchemes() {
        if (this.supportedAuthSchemes == null) {
            this.supportedAuthSchemes = this.createAuthSchemeRegistry();
        }
        return this.supportedAuthSchemes;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setAuthSchemes(AuthSchemeRegistry registry) {
        void var1_1;
        this.supportedAuthSchemes = var1_1;
    }

    public final synchronized ConnectionBackoffStrategy getConnectionBackoffStrategy() {
        return this.connectionBackoffStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setConnectionBackoffStrategy(ConnectionBackoffStrategy strategy) {
        void var1_1;
        this.connectionBackoffStrategy = var1_1;
    }

    public final synchronized CookieSpecRegistry getCookieSpecs() {
        if (this.supportedCookieSpecs == null) {
            this.supportedCookieSpecs = this.createCookieSpecRegistry();
        }
        return this.supportedCookieSpecs;
    }

    public final synchronized BackoffManager getBackoffManager() {
        return this.backoffManager;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setBackoffManager(BackoffManager manager) {
        void var1_1;
        this.backoffManager = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setCookieSpecs(CookieSpecRegistry registry) {
        void var1_1;
        this.supportedCookieSpecs = var1_1;
    }

    public final synchronized ConnectionReuseStrategy getConnectionReuseStrategy() {
        if (this.reuseStrategy == null) {
            this.reuseStrategy = this.createConnectionReuseStrategy();
        }
        return this.reuseStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setReuseStrategy(ConnectionReuseStrategy strategy) {
        void var1_1;
        this.reuseStrategy = var1_1;
    }

    public final synchronized ConnectionKeepAliveStrategy getConnectionKeepAliveStrategy() {
        if (this.keepAliveStrategy == null) {
            this.keepAliveStrategy = this.createConnectionKeepAliveStrategy();
        }
        return this.keepAliveStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setKeepAliveStrategy(ConnectionKeepAliveStrategy strategy) {
        void var1_1;
        this.keepAliveStrategy = var1_1;
    }

    public final synchronized HttpRequestRetryHandler getHttpRequestRetryHandler() {
        if (this.retryHandler == null) {
            this.retryHandler = this.createHttpRequestRetryHandler();
        }
        return this.retryHandler;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setHttpRequestRetryHandler(HttpRequestRetryHandler handler) {
        void var1_1;
        this.retryHandler = var1_1;
    }

    @Deprecated
    public final synchronized RedirectHandler getRedirectHandler() {
        return this.createRedirectHandler();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public synchronized void setRedirectHandler(RedirectHandler handler) {
        void var1_1;
        this.redirectStrategy = new DefaultRedirectStrategyAdaptor((RedirectHandler)var1_1);
    }

    public final synchronized RedirectStrategy getRedirectStrategy() {
        if (this.redirectStrategy == null) {
            this.redirectStrategy = new DefaultRedirectStrategy();
        }
        return this.redirectStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setRedirectStrategy(RedirectStrategy strategy) {
        void var1_1;
        this.redirectStrategy = var1_1;
    }

    @Deprecated
    public final synchronized AuthenticationHandler getTargetAuthenticationHandler() {
        return this.createTargetAuthenticationHandler();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public synchronized void setTargetAuthenticationHandler(AuthenticationHandler handler) {
        void var1_1;
        this.targetAuthStrategy = new AuthenticationStrategyAdaptor((AuthenticationHandler)var1_1);
    }

    public final synchronized AuthenticationStrategy getTargetAuthenticationStrategy() {
        if (this.targetAuthStrategy == null) {
            this.targetAuthStrategy = this.createTargetAuthenticationStrategy();
        }
        return this.targetAuthStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setTargetAuthenticationStrategy(AuthenticationStrategy strategy) {
        void var1_1;
        this.targetAuthStrategy = var1_1;
    }

    @Deprecated
    public final synchronized AuthenticationHandler getProxyAuthenticationHandler() {
        return this.createProxyAuthenticationHandler();
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public synchronized void setProxyAuthenticationHandler(AuthenticationHandler handler) {
        void var1_1;
        this.proxyAuthStrategy = new AuthenticationStrategyAdaptor((AuthenticationHandler)var1_1);
    }

    public final synchronized AuthenticationStrategy getProxyAuthenticationStrategy() {
        if (this.proxyAuthStrategy == null) {
            this.proxyAuthStrategy = this.createProxyAuthenticationStrategy();
        }
        return this.proxyAuthStrategy;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setProxyAuthenticationStrategy(AuthenticationStrategy strategy) {
        void var1_1;
        this.proxyAuthStrategy = var1_1;
    }

    public final synchronized CookieStore getCookieStore() {
        if (this.cookieStore == null) {
            this.cookieStore = this.createCookieStore();
        }
        return this.cookieStore;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setCookieStore(CookieStore cookieStore) {
        void var1_1;
        this.cookieStore = var1_1;
    }

    public final synchronized CredentialsProvider getCredentialsProvider() {
        if (this.credsProvider == null) {
            this.credsProvider = this.createCredentialsProvider();
        }
        return this.credsProvider;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setCredentialsProvider(CredentialsProvider credsProvider) {
        void var1_1;
        this.credsProvider = var1_1;
    }

    public final synchronized HttpRoutePlanner getRoutePlanner() {
        if (this.routePlanner == null) {
            this.routePlanner = this.createHttpRoutePlanner();
        }
        return this.routePlanner;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setRoutePlanner(HttpRoutePlanner routePlanner) {
        void var1_1;
        this.routePlanner = var1_1;
    }

    public final synchronized UserTokenHandler getUserTokenHandler() {
        if (this.userTokenHandler == null) {
            this.userTokenHandler = this.createUserTokenHandler();
        }
        return this.userTokenHandler;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void setUserTokenHandler(UserTokenHandler handler) {
        void var1_1;
        this.userTokenHandler = var1_1;
    }

    protected final synchronized BasicHttpProcessor getHttpProcessor() {
        if (this.mutableProcessor == null) {
            this.mutableProcessor = this.createHttpProcessor();
        }
        return this.mutableProcessor;
    }

    /*
     * WARNING - void declaration
     */
    private synchronized HttpProcessor getProtocolProcessor() {
        if (this.protocolProcessor == null) {
            void var2_3;
            void var3_4;
            BasicHttpProcessor proc = this.getHttpProcessor();
            int reqc = proc.getRequestInterceptorCount();
            HttpRequestInterceptor[] reqinterceptors = new HttpRequestInterceptor[reqc];
            for (int i = 0; i < reqc; ++i) {
                reqinterceptors[i] = proc.getRequestInterceptor(i);
            }
            int resc = proc.getResponseInterceptorCount();
            HttpResponseInterceptor[] resinterceptors = new HttpResponseInterceptor[resc];
            for (int i = 0; i < resc; ++i) {
                resinterceptors[i] = proc.getResponseInterceptor(i);
            }
            this.protocolProcessor = new ImmutableHttpProcessor((HttpRequestInterceptor[])var3_4, (HttpResponseInterceptor[])var2_3);
        }
        return this.protocolProcessor;
    }

    public synchronized int getResponseInterceptorCount() {
        return this.getHttpProcessor().getResponseInterceptorCount();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized HttpResponseInterceptor getResponseInterceptor(int index) {
        void var1_1;
        return this.getHttpProcessor().getResponseInterceptor((int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    public synchronized HttpRequestInterceptor getRequestInterceptor(int index) {
        void var1_1;
        return this.getHttpProcessor().getRequestInterceptor((int)var1_1);
    }

    public synchronized int getRequestInterceptorCount() {
        return this.getHttpProcessor().getRequestInterceptorCount();
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addResponseInterceptor(HttpResponseInterceptor itcp) {
        void var1_1;
        this.getHttpProcessor().addInterceptor((HttpResponseInterceptor)var1_1);
        this.protocolProcessor = null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addResponseInterceptor(HttpResponseInterceptor itcp, int index) {
        void var2_2;
        void var1_1;
        this.getHttpProcessor().addInterceptor((HttpResponseInterceptor)var1_1, (int)var2_2);
        this.protocolProcessor = null;
    }

    public synchronized void clearResponseInterceptors() {
        this.getHttpProcessor().clearResponseInterceptors();
        this.protocolProcessor = null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeResponseInterceptorByClass(Class<? extends HttpResponseInterceptor> clazz) {
        void var1_1;
        this.getHttpProcessor().removeResponseInterceptorByClass((Class)var1_1);
        this.protocolProcessor = null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addRequestInterceptor(HttpRequestInterceptor itcp) {
        void var1_1;
        this.getHttpProcessor().addInterceptor((HttpRequestInterceptor)var1_1);
        this.protocolProcessor = null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void addRequestInterceptor(HttpRequestInterceptor itcp, int index) {
        void var2_2;
        void var1_1;
        this.getHttpProcessor().addInterceptor((HttpRequestInterceptor)var1_1, (int)var2_2);
        this.protocolProcessor = null;
    }

    public synchronized void clearRequestInterceptors() {
        this.getHttpProcessor().clearRequestInterceptors();
        this.protocolProcessor = null;
    }

    /*
     * WARNING - void declaration
     */
    public synchronized void removeRequestInterceptorByClass(Class<? extends HttpRequestInterceptor> clazz) {
        void var1_1;
        this.getHttpProcessor().removeRequestInterceptorByClass((Class)var1_1);
        this.protocolProcessor = null;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected final CloseableHttpResponse doExecute(HttpHost target, HttpRequest request, HttpContext context) throws IOException, ClientProtocolException {
        BackoffManager backoffManager;
        ConnectionBackoffStrategy connectionBackoffStrategy;
        HttpRoutePlanner routePlanner;
        RequestDirector director;
        Object execContext;
        Args.notNull((Object)request, (String)"HTTP request");
        AbstractHttpClient abstractHttpClient = this;
        synchronized (abstractHttpClient) {
            HttpContext defaultContext = this.createHttpContext();
            execContext = context == null ? defaultContext : new DefaultedHttpContext(execContext, defaultContext);
            HttpParams params = this.determineParams(request);
            RequestConfig config = HttpClientParamConfig.getRequestConfig(params);
            execContext.setAttribute("http.request-config", (Object)config);
            AbstractHttpClient abstractHttpClient2 = this;
            director = abstractHttpClient2.createClientRequestDirector(abstractHttpClient2.getRequestExecutor(), this.getConnectionManager(), this.getConnectionReuseStrategy(), this.getConnectionKeepAliveStrategy(), this.getRoutePlanner(), this.getProtocolProcessor(), this.getHttpRequestRetryHandler(), this.getRedirectStrategy(), this.getTargetAuthenticationStrategy(), this.getProxyAuthenticationStrategy(), this.getUserTokenHandler(), params);
            routePlanner = this.getRoutePlanner();
            connectionBackoffStrategy = this.getConnectionBackoffStrategy();
            backoffManager = this.getBackoffManager();
        }
        try {
            void var3_4;
            void var2_3;
            void var1_1;
            void var4_8;
            if (connectionBackoffStrategy != null && backoffManager != null) {
                CloseableHttpResponse out;
                HttpHost targetForRoute = target != null ? target : (HttpHost)this.determineParams(request).getParameter("http.default-host");
                HttpRoute route = routePlanner.determineRoute(targetForRoute, request, (HttpContext)execContext);
                try {
                    out = CloseableHttpResponseProxy.newProxy(director.execute(target, request, (HttpContext)execContext));
                }
                catch (RuntimeException re) {
                    if (connectionBackoffStrategy.shouldBackoff(re)) {
                        backoffManager.backOff(route);
                    }
                    throw re;
                }
                catch (Exception e) {
                    if (connectionBackoffStrategy.shouldBackoff(e)) {
                        backoffManager.backOff(route);
                    }
                    if (e instanceof HttpException) {
                        throw (HttpException)((Object)e);
                    }
                    if (e instanceof IOException) {
                        throw (IOException)e;
                    }
                    throw new UndeclaredThrowableException(e);
                }
                if (connectionBackoffStrategy.shouldBackoff(out)) {
                    backoffManager.backOff(route);
                } else {
                    backoffManager.probe(route);
                }
                return out;
            }
            return CloseableHttpResponseProxy.newProxy(var4_8.execute((HttpHost)var1_1, (HttpRequest)var2_3, (HttpContext)var3_4));
        }
        catch (HttpException httpException) {
            throw new ClientProtocolException(httpException);
        }
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectHandler redirectHandler, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultRequestDirector((HttpRequestExecutor)var1_1, (ClientConnectionManager)var2_2, (ConnectionReuseStrategy)var3_3, kastrat, rouplan, httpProcessor, retryHandler, redirectHandler, targetAuthHandler, proxyAuthHandler, userTokenHandler, params);
    }

    /*
     * WARNING - void declaration
     */
    @Deprecated
    protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationHandler targetAuthHandler, AuthenticationHandler proxyAuthHandler, UserTokenHandler userTokenHandler, HttpParams params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultRequestDirector(this.log, (HttpRequestExecutor)var1_1, (ClientConnectionManager)var2_2, (ConnectionReuseStrategy)var3_3, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, targetAuthHandler, proxyAuthHandler, userTokenHandler, params);
    }

    /*
     * WARNING - void declaration
     */
    protected RequestDirector createClientRequestDirector(HttpRequestExecutor requestExec, ClientConnectionManager conman, ConnectionReuseStrategy reustrat, ConnectionKeepAliveStrategy kastrat, HttpRoutePlanner rouplan, HttpProcessor httpProcessor, HttpRequestRetryHandler retryHandler, RedirectStrategy redirectStrategy, AuthenticationStrategy targetAuthStrategy, AuthenticationStrategy proxyAuthStrategy, UserTokenHandler userTokenHandler, HttpParams params) {
        void var3_3;
        void var2_2;
        void var1_1;
        return new DefaultRequestDirector(this.log, (HttpRequestExecutor)var1_1, (ClientConnectionManager)var2_2, (ConnectionReuseStrategy)var3_3, kastrat, rouplan, httpProcessor, retryHandler, redirectStrategy, targetAuthStrategy, proxyAuthStrategy, userTokenHandler, params);
    }

    /*
     * WARNING - void declaration
     */
    protected HttpParams determineParams(HttpRequest req) {
        void var1_1;
        return new ClientParamsStack(null, this.getParams(), var1_1.getParams(), null);
    }

    @Override
    public void close() {
        this.getConnectionManager().shutdown();
    }
}

