/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.client;

import java.util.HashMap;
import java.util.Map;
import org.apache.http.client.BackoffManager;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.client.Clock;
import org.apache.http.impl.client.SystemClock;
import org.apache.http.pool.ConnPoolControl;
import org.apache.http.util.Args;

public class AIMDBackoffManager
implements BackoffManager {
    private final ConnPoolControl<HttpRoute> connPerRoute;
    private final Clock clock;
    private final Map<HttpRoute, Long> lastRouteProbes;
    private final Map<HttpRoute, Long> lastRouteBackoffs;
    private long coolDown = 5000L;
    private double backoffFactor = 0.5;
    private int cap = 2;

    /*
     * WARNING - void declaration
     */
    public AIMDBackoffManager(ConnPoolControl<HttpRoute> connPerRoute) {
        this((ConnPoolControl<HttpRoute>)var1_1, new SystemClock());
        void var1_1;
    }

    /*
     * WARNING - void declaration
     */
    AIMDBackoffManager(ConnPoolControl<HttpRoute> connPerRoute, Clock clock) {
        void var1_1;
        void var2_2;
        this.clock = var2_2;
        this.connPerRoute = var1_1;
        this.lastRouteProbes = new HashMap<HttpRoute, Long>();
        this.lastRouteBackoffs = new HashMap<HttpRoute, Long>();
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void backOff(HttpRoute route) {
        ConnPoolControl<HttpRoute> connPoolControl = this.connPerRoute;
        synchronized (connPoolControl) {
            void var1_1;
            void var3_4;
            int curr = this.connPerRoute.getMaxPerRoute((Object)route);
            AIMDBackoffManager aIMDBackoffManager = this;
            Long lastUpdate = aIMDBackoffManager.getLastUpdate(aIMDBackoffManager.lastRouteBackoffs, route);
            long now = this.clock.getCurrentTime();
            if (now - lastUpdate < this.coolDown) {
                return;
            }
            this.connPerRoute.setMaxPerRoute((Object)route, this.getBackedOffPoolSize((int)var3_4));
            this.lastRouteBackoffs.put((HttpRoute)var1_1, now);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private int getBackedOffPoolSize(int curr) {
        void var1_1;
        if (curr <= 1) {
            return 1;
        }
        return (int)Math.floor(this.backoffFactor * (double)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public void probe(HttpRoute route) {
        ConnPoolControl<HttpRoute> connPoolControl = this.connPerRoute;
        synchronized (connPoolControl) {
            void var1_1;
            void var3_4;
            int curr = this.connPerRoute.getMaxPerRoute((Object)route);
            int max = curr >= this.cap ? this.cap : curr + 1;
            AIMDBackoffManager aIMDBackoffManager = this;
            Long lastProbe = aIMDBackoffManager.getLastUpdate(aIMDBackoffManager.lastRouteProbes, route);
            AIMDBackoffManager aIMDBackoffManager2 = this;
            Long lastBackoff = aIMDBackoffManager2.getLastUpdate(aIMDBackoffManager2.lastRouteBackoffs, route);
            long now = this.clock.getCurrentTime();
            if (now - lastProbe < this.coolDown || now - lastBackoff < this.coolDown) {
                return;
            }
            this.connPerRoute.setMaxPerRoute((Object)route, (int)var3_4);
            this.lastRouteProbes.put((HttpRoute)var1_1, now);
            return;
        }
    }

    /*
     * WARNING - void declaration
     */
    private Long getLastUpdate(Map<HttpRoute, Long> updates, HttpRoute route) {
        void var1_1;
        void var2_2;
        Long lastUpdate = updates.get(var2_2);
        if (lastUpdate == null) {
            lastUpdate = 0L;
        }
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setBackoffFactor(double d) {
        void var1_1;
        Args.check((d > 0.0 && d < 1.0 ? 1 : 0) != 0, (String)"Backoff factor must be 0.0 < f < 1.0");
        this.backoffFactor = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setCooldownMillis(long l) {
        void var1_1;
        Args.positive((long)this.coolDown, (String)"Cool down");
        this.coolDown = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public void setPerHostConnectionCap(int cap) {
        void var1_1;
        Args.positive((int)cap, (String)"Per host connection cap");
        this.cap = var1_1;
    }
}

