/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.ObjectStreamException;
import java.io.Serializable;
import java.nio.charset.Charset;
import java.util.HashMap;
import java.util.Locale;
import java.util.Map;
import org.apache.http.Consts;
import org.apache.http.HeaderElement;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.ChallengeState;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.message.BasicHeaderValueParser;
import org.apache.http.message.ParserCursor;
import org.apache.http.util.CharArrayBuffer;
import org.apache.http.util.CharsetUtils;

@NotThreadSafe
public abstract class RFC2617Scheme
extends AuthSchemeBase
implements Serializable {
    private static final long serialVersionUID = -2845454858205884623L;
    private final Map<String, String> params = new HashMap<String, String>();
    private transient Charset credentialsCharset;

    /*
     * WARNING - void declaration
     */
    @Deprecated
    public RFC2617Scheme(ChallengeState challengeState) {
        super((ChallengeState)var1_1);
        void var1_1;
        this.credentialsCharset = Consts.ASCII;
    }

    /*
     * WARNING - void declaration
     */
    public RFC2617Scheme(Charset credentialsCharset) {
        void var1_1;
        this.credentialsCharset = credentialsCharset != null ? var1_1 : Consts.ASCII;
    }

    public RFC2617Scheme() {
        this(Consts.ASCII);
    }

    public Charset getCredentialsCharset() {
        if (this.credentialsCharset != null) {
            return this.credentialsCharset;
        }
        return Consts.ASCII;
    }

    /*
     * WARNING - void declaration
     */
    String getCredentialsCharset(HttpRequest request) {
        void var1_1;
        String charset = (String)request.getParams().getParameter("http.auth.credential-charset");
        if (charset == null) {
            charset = this.getCredentialsCharset().name();
        }
        return var1_1;
    }

    @Override
    protected void parseChallenge(CharArrayBuffer buffer, int pos, int len) throws MalformedChallengeException {
        BasicHeaderValueParser parser = BasicHeaderValueParser.INSTANCE;
        ParserCursor cursor = new ParserCursor(pos, buffer.length());
        HeaderElement[] elements = parser.parseElements(buffer, cursor);
        this.params.clear();
        HeaderElement[] arr$ = elements;
        int len$ = elements.length;
        for (int i$ = 0; i$ < len$; ++i$) {
            HeaderElement element = arr$[i$];
            this.params.put(element.getName().toLowerCase(Locale.ROOT), element.getValue());
        }
    }

    protected Map<String, String> getParameters() {
        return this.params;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public String getParameter(String name) {
        void var1_1;
        if (name == null) {
            return null;
        }
        return this.params.get(var1_1.toLowerCase(Locale.ROOT));
    }

    @Override
    public String getRealm() {
        return this.getParameter("realm");
    }

    /*
     * WARNING - void declaration
     */
    private void writeObject(ObjectOutputStream out) throws IOException {
        void var1_1;
        out.defaultWriteObject();
        out.writeUTF(this.credentialsCharset.name());
        var1_1.writeObject((Object)this.challengeState);
    }

    /*
     * WARNING - void declaration
     */
    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        void var1_1;
        in.defaultReadObject();
        this.credentialsCharset = CharsetUtils.get((String)in.readUTF());
        if (this.credentialsCharset == null) {
            this.credentialsCharset = Consts.ASCII;
        }
        this.challengeState = (ChallengeState)((Object)var1_1.readObject());
    }

    private void readObjectNoData() throws ObjectStreamException {
    }
}

