/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpRequest;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.impl.auth.GGSSchemeBase;
import org.apache.http.impl.auth.SpnegoTokenGenerator;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.Oid;

@Deprecated
public class NegotiateScheme
extends GGSSchemeBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private static final String SPNEGO_OID = "1.3.6.1.5.5.2";
    private static final String KERBEROS_OID = "1.2.840.113554.1.2.2";
    private final SpnegoTokenGenerator spengoGenerator;

    /*
     * WARNING - void declaration
     */
    public NegotiateScheme(SpnegoTokenGenerator spengoGenerator, boolean stripPort) {
        super((boolean)var2_2);
        void var1_1;
        void var2_2;
        this.spengoGenerator = var1_1;
    }

    /*
     * WARNING - void declaration
     */
    public NegotiateScheme(SpnegoTokenGenerator spengoGenerator) {
        this((SpnegoTokenGenerator)var1_1, false);
        void var1_1;
    }

    public NegotiateScheme() {
        this(null, false);
    }

    @Override
    public String getSchemeName() {
        return "Negotiate";
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        void var2_2;
        void var1_1;
        return ((AuthSchemeBase)this).authenticate((Credentials)var1_1, (HttpRequest)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        void var3_3;
        void var2_2;
        void var1_1;
        return super.authenticate((Credentials)var1_1, (HttpRequest)var2_2, (HttpContext)var3_3);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        void var2_2;
        void var1_1;
        return super.generateToken((byte[])var1_1, (String)var2_2);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected byte[] generateToken(byte[] input, String authServer, Credentials credentials) throws GSSException {
        void var1_1;
        Object ex;
        byte[] token;
        Oid negotiationOid = new Oid(SPNEGO_OID);
        boolean tryKerberos = false;
        try {
            token = this.generateGSSToken(token, negotiationOid, authServer, credentials);
        }
        catch (GSSException gSSException) {
            ex = gSSException;
            if (gSSException.getMajor() == 2) {
                this.log.debug((Object)"GSSException BAD_MECH, retry with Kerberos MECH");
                tryKerberos = true;
            }
            throw ex;
        }
        if (tryKerberos) {
            void var3_3;
            void var2_2;
            this.log.debug((Object)"Using Kerberos MECH 1.2.840.113554.1.2.2");
            ex = new Oid(KERBEROS_OID);
            token = this.generateGSSToken(token, (Oid)ex, (String)var2_2, (Credentials)var3_3);
            if (token != null && this.spengoGenerator != null) {
                try {
                    token = this.spengoGenerator.generateSpnegoDERObject(token);
                }
                catch (IOException ex2) {
                    this.log.error((Object)ex2.getMessage(), (Throwable)ex2);
                }
            }
        }
        return var1_1;
    }

    @Override
    public String getParameter(String name) {
        Args.notNull((Object)name, (String)"Parameter name");
        return null;
    }

    @Override
    public String getRealm() {
        return null;
    }

    @Override
    public boolean isConnectionBased() {
        return true;
    }
}

