/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.io.UnsupportedEncodingException;
import java.nio.charset.Charset;
import java.security.Key;
import java.security.MessageDigest;
import java.security.SecureRandom;
import java.util.Arrays;
import java.util.Locale;
import javax.crypto.Cipher;
import javax.crypto.spec.SecretKeySpec;
import org.apache.commons.codec.binary.Base64;
import org.apache.http.Consts;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.impl.auth.NTLMEngine;
import org.apache.http.impl.auth.NTLMEngineException;
import org.apache.http.util.CharsetUtils;
import org.apache.http.util.EncodingUtils;

@NotThreadSafe
final class NTLMEngineImpl
implements NTLMEngine {
    private static final Charset UNICODE_LITTLE_UNMARKED = CharsetUtils.lookup((String)"UnicodeLittleUnmarked");
    private static final Charset DEFAULT_CHARSET = Consts.ASCII;
    protected static final int FLAG_REQUEST_UNICODE_ENCODING = 1;
    protected static final int FLAG_REQUEST_TARGET = 4;
    protected static final int FLAG_REQUEST_SIGN = 16;
    protected static final int FLAG_REQUEST_SEAL = 32;
    protected static final int FLAG_REQUEST_LAN_MANAGER_KEY = 128;
    protected static final int FLAG_REQUEST_NTLMv1 = 512;
    protected static final int FLAG_DOMAIN_PRESENT = 4096;
    protected static final int FLAG_WORKSTATION_PRESENT = 8192;
    protected static final int FLAG_REQUEST_ALWAYS_SIGN = 32768;
    protected static final int FLAG_REQUEST_NTLM2_SESSION = 524288;
    protected static final int FLAG_REQUEST_VERSION = 0x2000000;
    protected static final int FLAG_TARGETINFO_PRESENT = 0x800000;
    protected static final int FLAG_REQUEST_128BIT_KEY_EXCH = 0x20000000;
    protected static final int FLAG_REQUEST_EXPLICIT_KEY_EXCH = 0x40000000;
    protected static final int FLAG_REQUEST_56BIT_ENCRYPTION = Integer.MIN_VALUE;
    private static final SecureRandom RND_GEN;
    private static final byte[] SIGNATURE;
    private static final Type1Message TYPE_1_MESSAGE;

    NTLMEngineImpl() {
    }

    /*
     * WARNING - void declaration
     */
    static String getResponseFor(String message, String username, String password, String host, String domain) throws NTLMEngineException {
        Type2Message type2Message;
        Type2Message response;
        if (message == null || message.trim().equals("")) {
            response = NTLMEngineImpl.getType1Message(host, domain);
        } else {
            void var3_3;
            void var2_2;
            void var1_1;
            Type2Message t2m = new Type2Message((String)((Object)response));
            response = NTLMEngineImpl.getType3Message((String)var1_1, (String)var2_2, (String)var3_3, domain, t2m.getChallenge(), t2m.getFlags(), t2m.getTarget(), t2m.getTargetInfo());
        }
        return type2Message;
    }

    static String getType1Message(String host, String domain) throws NTLMEngineException {
        return TYPE_1_MESSAGE.getResponse();
    }

    /*
     * WARNING - void declaration
     */
    static String getType3Message(String user, String password, String host, String domain, byte[] nonce, int type2Flags, String target, byte[] targetInformation) throws NTLMEngineException {
        void var1_1;
        String string;
        void var2_2;
        void var3_3;
        return new Type3Message((String)var3_3, (String)var2_2, string, (String)var1_1, nonce, type2Flags, target, targetInformation).getResponse();
    }

    /*
     * WARNING - void declaration
     */
    private static String stripDotSuffix(String value) {
        String string;
        if (value == null) {
            return null;
        }
        int index = value.indexOf(".");
        if (index != -1) {
            void var1_1;
            return value.substring(0, (int)var1_1);
        }
        return string;
    }

    private static String convertHost(String host) {
        return NTLMEngineImpl.stripDotSuffix(host);
    }

    private static String convertDomain(String domain) {
        return NTLMEngineImpl.stripDotSuffix(domain);
    }

    /*
     * WARNING - void declaration
     */
    private static int readULong(byte[] src, int index) throws NTLMEngineException {
        void var1_1;
        byte[] byArray;
        if (src.length < index + 4) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for DWORD");
        }
        return src[index] & 0xFF | (src[index + 1] & 0xFF) << 8 | (src[index + 2] & 0xFF) << 16 | (byArray[var1_1 + 3] & 0xFF) << 24;
    }

    /*
     * WARNING - void declaration
     */
    private static int readUShort(byte[] src, int index) throws NTLMEngineException {
        void var1_1;
        byte[] byArray;
        if (src.length < index + 2) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for WORD");
        }
        return src[index] & 0xFF | (byArray[var1_1 + true] & 0xFF) << 8;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] readSecurityBuffer(byte[] src, int index) throws NTLMEngineException {
        void var3_3;
        void var2_2;
        void var1_1;
        byte[] byArray;
        int length = NTLMEngineImpl.readUShort(src, index);
        int offset = NTLMEngineImpl.readULong(src, index + 4);
        if (src.length < offset + length) {
            throw new NTLMEngineException("NTLM authentication - buffer too small for data item");
        }
        byte[] buffer = new byte[length];
        System.arraycopy(byArray, (int)var1_1, buffer, 0, (int)var2_2);
        return var3_3;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] makeRandomChallenge() throws NTLMEngineException {
        void var0;
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] rval = new byte[8];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(rval);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] makeSecondaryKey() throws NTLMEngineException {
        void var0;
        if (RND_GEN == null) {
            throw new NTLMEngineException("Random generator not available");
        }
        byte[] rval = new byte[16];
        SecureRandom secureRandom = RND_GEN;
        synchronized (secureRandom) {
            RND_GEN.nextBytes(rval);
        }
        return var0;
    }

    /*
     * WARNING - void declaration
     */
    static byte[] hmacMD5(byte[] value, byte[] key) throws NTLMEngineException {
        void var1_1;
        byte[] byArray;
        HMACMD5 hmacMD5 = new HMACMD5(key);
        hmacMD5.update(byArray);
        return var1_1.getOutput();
    }

    /*
     * WARNING - void declaration
     */
    static byte[] RC4(byte[] value, byte[] key) throws NTLMEngineException {
        try {
            byte[] byArray;
            void var1_1;
            Cipher rc4 = Cipher.getInstance("RC4");
            rc4.init(1, new SecretKeySpec((byte[])var1_1, "RC4"));
            return rc4.doFinal(byArray);
        }
        catch (Exception e) {
            void var2_3;
            throw new NTLMEngineException(e.getMessage(), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    static byte[] ntlm2SessionResponse(byte[] ntlmHash, byte[] challenge, byte[] clientChallenge) throws NTLMEngineException {
        try {
            void var2_2;
            byte[] byArray;
            void var1_1;
            MessageDigest md5 = MessageDigest.getInstance("MD5");
            md5.update(challenge);
            md5.update(clientChallenge);
            byte[] digest = md5.digest();
            byte[] sessionHash = new byte[8];
            System.arraycopy(var1_1, 0, sessionHash, 0, 8);
            return NTLMEngineImpl.lmResponse(byArray, (byte[])var2_2);
        }
        catch (Exception exception) {
            void var3_4;
            Exception e = exception;
            if (exception instanceof NTLMEngineException) {
                throw (NTLMEngineException)((Object)e);
            }
            throw new NTLMEngineException(e.getMessage(), (Throwable)var3_4);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] lmHash(String password) throws NTLMEngineException {
        try {
            void var2_4;
            void var1_3;
            void var3_5;
            byte[] byArray = password.toUpperCase(Locale.ROOT).getBytes(Consts.ASCII);
            Key oemPassword = (Key)byArray;
            int length = Math.min(byArray.length, 14);
            byte[] keyBytes = new byte[14];
            System.arraycopy(oemPassword, 0, keyBytes, 0, length);
            Key lowKey = NTLMEngineImpl.createDESKey(keyBytes, 0);
            Key highKey = NTLMEngineImpl.createDESKey(keyBytes, 7);
            byte[] magicConstant = "KGS!@#$%".getBytes(Consts.ASCII);
            Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
            des.init(1, lowKey);
            Key lowHash = (Key)des.doFinal(magicConstant);
            des.init(1, highKey);
            byte[] highHash = var3_5.doFinal(magicConstant);
            byte[] lmHash = new byte[16];
            System.arraycopy(lowHash, 0, lmHash, 0, 8);
            System.arraycopy(var1_3, 0, lmHash, 8, 8);
            return var2_4;
        }
        catch (Exception e) {
            void var0_1;
            throw new NTLMEngineException(e.getMessage(), (Throwable)var0_1);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] ntlmHash(String password) throws NTLMEngineException {
        void var1_1;
        Object object;
        if (UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        Object unicodePassword = password.getBytes(UNICODE_LITTLE_UNMARKED);
        MD4 md4 = new MD4();
        md4.update((byte[])object);
        return var1_1.getOutput();
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] lmv2Hash(String domain, String user, byte[] ntlmHash) throws NTLMEngineException {
        void var2_2;
        void var1_1;
        if (UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        HMACMD5 hmacMD5 = new HMACMD5(ntlmHash);
        hmacMD5.update(var1_1.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        if (domain != null) {
            String string;
            hmacMD5.update(string.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        }
        return var2_2.getOutput();
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] ntlmv2Hash(String domain, String user, byte[] ntlmHash) throws NTLMEngineException {
        void var2_2;
        void var1_1;
        if (UNICODE_LITTLE_UNMARKED == null) {
            throw new NTLMEngineException("Unicode not supported");
        }
        HMACMD5 hmacMD5 = new HMACMD5(ntlmHash);
        hmacMD5.update(var1_1.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED));
        if (domain != null) {
            String string;
            hmacMD5.update(string.getBytes(UNICODE_LITTLE_UNMARKED));
        }
        return var2_2.getOutput();
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] lmResponse(byte[] hash, byte[] challenge) throws NTLMEngineException {
        try {
            void var1_1;
            void var3_4;
            Object object;
            byte[] keyBytes = new byte[21];
            System.arraycopy(hash, 0, keyBytes, 0, 16);
            Object lowKey = NTLMEngineImpl.createDESKey(keyBytes, 0);
            Key middleKey = NTLMEngineImpl.createDESKey(keyBytes, 7);
            Key highKey = NTLMEngineImpl.createDESKey(keyBytes, 14);
            Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
            des.init(1, (Key)lowKey);
            Object lowResponse = des.doFinal(challenge);
            des.init(1, middleKey);
            byte[] middleResponse = des.doFinal(challenge);
            des.init(1, highKey);
            byte[] highResponse = des.doFinal(challenge);
            byte[] lmResponse = new byte[24];
            System.arraycopy(object, 0, lmResponse, 0, 8);
            System.arraycopy(var3_4, 0, lmResponse, 8, 8);
            System.arraycopy(var1_1, 0, lmResponse, 16, 8);
            return lmResponse;
        }
        catch (Exception e) {
            void var2_3;
            throw new NTLMEngineException(e.getMessage(), (Throwable)var2_3);
        }
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] lmv2Response(byte[] hash, byte[] challenge, byte[] clientData) throws NTLMEngineException {
        void var1_1;
        void var2_2;
        Object object;
        HMACMD5 hMACMD5 = new HMACMD5(hash);
        Object hmacMD5 = hMACMD5;
        hMACMD5.update(challenge);
        hmacMD5.update(clientData);
        byte[] byArray = hmacMD5.getOutput();
        Object mac = byArray;
        byte[] lmv2Response = new byte[byArray.length + clientData.length];
        System.arraycopy(mac, 0, lmv2Response, 0, ((byte[])mac).length);
        System.arraycopy(clientData, 0, lmv2Response, ((byte[])object).length, ((void)var2_2).length);
        return var1_1;
    }

    /*
     * WARNING - void declaration
     */
    private static byte[] createBlob(byte[] clientChallenge, byte[] targetInformation, byte[] timestamp) {
        void var2_3;
        void var1_1;
        byte[] byArray;
        void var3_4;
        byte[] blobSignature = new byte[]{1, 1, 0, 0};
        byte[] reserved = new byte[]{0, 0, 0, 0};
        byte[] unknown1 = new byte[]{0, 0, 0, 0};
        byte[] unknown2 = new byte[]{0, 0, 0, 0};
        int cfr_ignored_0 = blobSignature.length;
        int cfr_ignored_1 = reserved.length;
        byte[] blob = new byte[8 + timestamp.length + 8 + unknown1.length + targetInformation.length + unknown2.length];
        System.arraycopy(blobSignature, 0, blob, 0, blobSignature.length);
        int cfr_ignored_2 = ((void)var3_4).length;
        System.arraycopy(reserved, 0, blob, 4, reserved.length);
        int cfr_ignored_3 = reserved.length;
        System.arraycopy(timestamp, 0, blob, 8, timestamp.length);
        int offset = 8 + timestamp.length;
        System.arraycopy(byArray, 0, blob, offset, 8);
        System.arraycopy(unknown1, 0, blob, offset += 8, unknown1.length);
        System.arraycopy(targetInformation, 0, blob, offset += unknown1.length, targetInformation.length);
        offset += ((void)var1_1).length;
        System.arraycopy(unknown2, 0, blob, (int)var2_3, unknown2.length);
        int cfr_ignored_4 = unknown2.length;
        return blob;
    }

    /*
     * WARNING - void declaration
     */
    private static Key createDESKey(byte[] bytes, int offset) {
        byte[] byArray;
        void var2_2;
        void var1_1;
        byte[] keyBytes = new byte[7];
        System.arraycopy(bytes, (int)var1_1, keyBytes, 0, 7);
        byte[] byArray2 = new byte[8];
        byte[] material = byArray2;
        byArray2[0] = keyBytes[0];
        material[1] = (byte)(keyBytes[0] << 7 | (keyBytes[1] & 0xFF) >>> 1);
        material[2] = (byte)(keyBytes[1] << 6 | (keyBytes[2] & 0xFF) >>> 2);
        material[3] = (byte)(keyBytes[2] << 5 | (keyBytes[3] & 0xFF) >>> 3);
        material[4] = (byte)(keyBytes[3] << 4 | (keyBytes[4] & 0xFF) >>> 4);
        material[5] = (byte)(keyBytes[4] << 3 | (keyBytes[5] & 0xFF) >>> 5);
        material[6] = (byte)(keyBytes[5] << 2 | (keyBytes[6] & 0xFF) >>> 6);
        material[7] = (byte)(var2_2[6] << 1);
        NTLMEngineImpl.oddParity(material);
        return new SecretKeySpec(byArray, "DES");
    }

    private static void oddParity(byte[] bytes) {
        for (int i = 0; i < bytes.length; ++i) {
            boolean bl;
            byte b = bytes[i];
            if (bl = ((b >>> 7 ^ b >>> 6 ^ b >>> 5 ^ b >>> 4 ^ b >>> 3 ^ b >>> 2 ^ bl >>> 1) & 1) == 0) {
                int n = i;
                bytes[n] = (byte)(bytes[n] | 1);
                continue;
            }
            int n = i;
            bytes[n] = (byte)(bytes[n] & 0xFFFFFFFE);
        }
    }

    /*
     * WARNING - void declaration
     */
    static void writeULong(byte[] buffer, int value, int offset) {
        void var1_1;
        buffer[offset] = (byte)value;
        buffer[offset + 1] = (byte)(value >> 8);
        buffer[offset + 2] = (byte)(value >> 16);
        var0[var2_2 + 3] = (byte)(var1_1 >>> 24);
    }

    /*
     * WARNING - void declaration
     */
    static int F(int x, int y, int z) {
        void var2_2;
        int n;
        void var1_1;
        return x & var1_1 | ~n & var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int G(int x, int y, int z) {
        void var2_2;
        void var1_1;
        int n;
        return x & y | n & z | var1_1 & var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int H(int x, int y, int z) {
        void var2_2;
        void var1_1;
        return x ^ var1_1 ^ var2_2;
    }

    /*
     * WARNING - void declaration
     */
    static int rotintlft(int val, int numbits) {
        void var1_1;
        int n;
        return val << numbits | n >>> 32 - var1_1;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String generateType1Msg(String domain, String workstation) throws NTLMEngineException {
        void var1_1;
        return NTLMEngineImpl.getType1Message(workstation, (String)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public final String generateType3Msg(String username, String password, String domain, String workstation, String challenge) throws NTLMEngineException {
        void var3_3;
        void var2_2;
        void var1_1;
        Type2Message t2m = new Type2Message(challenge);
        return NTLMEngineImpl.getType3Message((String)var1_1, (String)var2_2, workstation, (String)var3_3, t2m.getChallenge(), t2m.getFlags(), t2m.getTarget(), t2m.getTargetInfo());
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$300(byte[] x0, byte[] x1) throws NTLMEngineException {
        void var1_1;
        return NTLMEngineImpl.lmResponse(x0, (byte[])var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$500(String x0, String x1, byte[] x2) throws NTLMEngineException {
        void var2_2;
        void var1_1;
        return NTLMEngineImpl.lmv2Hash(x0, (String)var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$600(String x0, String x1, byte[] x2) throws NTLMEngineException {
        void var2_2;
        void var1_1;
        return NTLMEngineImpl.ntlmv2Hash(x0, (String)var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$700(byte[] x0, byte[] x1, byte[] x2) {
        void var2_2;
        void var1_1;
        return NTLMEngineImpl.createBlob(x0, (byte[])var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$800(byte[] x0, byte[] x1, byte[] x2) throws NTLMEngineException {
        void var2_2;
        void var1_1;
        return NTLMEngineImpl.lmv2Response(x0, (byte[])var1_1, (byte[])var2_2);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ Key access$900(byte[] x0, int x1) {
        void var1_1;
        return NTLMEngineImpl.createDESKey(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1200(byte[] x0, int x1) throws NTLMEngineException {
        void var1_1;
        return NTLMEngineImpl.readUShort(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ int access$1300(byte[] x0, int x1) throws NTLMEngineException {
        void var1_1;
        return NTLMEngineImpl.readULong(x0, (int)var1_1);
    }

    /*
     * WARNING - void declaration
     */
    static /* synthetic */ byte[] access$1400(byte[] x0, int x1) throws NTLMEngineException {
        void var1_1;
        return NTLMEngineImpl.readSecurityBuffer(x0, (int)var1_1);
    }

    static {
        SecureRandom rnd = null;
        try {
            rnd = SecureRandom.getInstance("SHA1PRNG");
        }
        catch (Exception exception) {}
        RND_GEN = rnd;
        byte[] bytesWithoutNull = "NTLMSSP".getBytes(Consts.ASCII);
        SIGNATURE = new byte[bytesWithoutNull.length + 1];
        System.arraycopy(bytesWithoutNull, 0, SIGNATURE, 0, bytesWithoutNull.length);
        NTLMEngineImpl.SIGNATURE[((void)var0).length] = 0;
        TYPE_1_MESSAGE = new Type1Message();
    }

    static class HMACMD5 {
        protected byte[] ipad;
        protected byte[] opad;
        protected MessageDigest md5;

        HMACMD5(byte[] input) throws NTLMEngineException {
            int i;
            byte[] key;
            try {
                this.md5 = MessageDigest.getInstance("MD5");
            }
            catch (Exception ex) {
                throw new NTLMEngineException("Error getting md5 message digest implementation: " + ex.getMessage(), ex);
            }
            this.ipad = new byte[64];
            this.opad = new byte[64];
            int keyLength = key.length;
            if (keyLength > 64) {
                this.md5.update(key);
                key = this.md5.digest();
                keyLength = key.length;
            }
            for (i = 0; i < keyLength; ++i) {
                this.ipad[i] = (byte)(key[i] ^ 0x36);
                this.opad[i] = (byte)(key[i] ^ 0x5C);
            }
            while (i < 64) {
                this.ipad[i] = 54;
                this.opad[i] = 92;
                ++i;
            }
            this.md5.reset();
            this.md5.update(this.ipad);
        }

        /*
         * WARNING - void declaration
         */
        byte[] getOutput() {
            void var1_1;
            byte[] digest = this.md5.digest();
            this.md5.update(this.opad);
            return this.md5.digest((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        void update(byte[] input) {
            void var1_1;
            this.md5.update((byte[])var1_1);
        }

        /*
         * WARNING - void declaration
         */
        void update(byte[] input, int offset, int length) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.md5.update((byte[])var1_1, (int)var2_2, (int)var3_3);
        }
    }

    static class MD4 {
        protected int A = 1732584193;
        protected int B = -271733879;
        protected int C = -1732584194;
        protected int D = 271733878;
        protected long count = 0L;
        protected byte[] dataBuffer = new byte[64];

        MD4() {
        }

        /*
         * WARNING - void declaration
         */
        void update(byte[] input) {
            int transferAmt;
            int curBufferPos = (int)(this.count & 0x3FL);
            int inputIndex = 0;
            while (input.length - inputIndex + curBufferPos >= this.dataBuffer.length) {
                transferAmt = this.dataBuffer.length - curBufferPos;
                System.arraycopy(input, inputIndex, this.dataBuffer, curBufferPos, transferAmt);
                this.count += (long)transferAmt;
                curBufferPos = 0;
                inputIndex += transferAmt;
                this.processBuffer();
            }
            if (inputIndex < input.length) {
                void var2_2;
                void var3_3;
                void var1_1;
                transferAmt = input.length - inputIndex;
                System.arraycopy(var1_1, (int)var3_3, this.dataBuffer, (int)var2_2, transferAmt);
                this.count += (long)transferAmt;
            }
        }

        /*
         * WARNING - void declaration
         */
        byte[] getOutput() {
            void var3_4;
            void var2_2;
            int bufferIndex = (int)(this.count & 0x3FL);
            int padLen = bufferIndex < 56 ? 56 - bufferIndex : 120 - bufferIndex;
            byte[] byArray = new byte[padLen + 8];
            byte[] postBytes = byArray;
            byArray[0] = -128;
            for (int i = 0; i < 8; ++i) {
                postBytes[padLen + i] = (byte)(this.count << 3 >>> i * 8);
            }
            this.update((byte[])var2_2);
            byte[] result = new byte[16];
            NTLMEngineImpl.writeULong(result, this.A, 0);
            NTLMEngineImpl.writeULong(result, this.B, 4);
            NTLMEngineImpl.writeULong(result, this.C, 8);
            NTLMEngineImpl.writeULong(result, this.D, 12);
            return var3_4;
        }

        /*
         * WARNING - void declaration
         */
        protected void processBuffer() {
            void var3_3;
            void var2_2;
            void var1_1;
            int[] d = new int[16];
            for (int i = 0; i < 16; ++i) {
                d[i] = (this.dataBuffer[i << 2] & 0xFF) + ((this.dataBuffer[(i << 2) + 1] & 0xFF) << 8) + ((this.dataBuffer[(i << 2) + 2] & 0xFF) << 16) + ((this.dataBuffer[(i << 2) + 3] & 0xFF) << 24);
            }
            int AA = this.A;
            int BB = this.B;
            int CC = this.C;
            int DD = this.D;
            this.round1(d);
            this.round2(d);
            this.round3((int[])var1_1);
            this.A += var2_2;
            this.B += var3_3;
            this.C += CC;
            this.D += DD;
        }

        /*
         * WARNING - void declaration
         */
        protected void round1(int[] d) {
            void var1_1;
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + d[0], 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + d[1], 7);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + d[2], 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + d[3], 19);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + d[4], 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + d[5], 7);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + d[6], 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + d[7], 19);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + d[8], 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + d[9], 7);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + d[10], 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + d[11], 19);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.F(this.B, this.C, this.D) + d[12], 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.F(this.A, this.B, this.C) + d[13], 7);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.F(this.D, this.A, this.B) + d[14], 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.F(this.C, this.D, this.A) + var1_1[15], 19);
        }

        /*
         * WARNING - void declaration
         */
        protected void round2(int[] d) {
            void var1_1;
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + d[0] + 1518500249, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + d[4] + 1518500249, 5);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + d[8] + 1518500249, 9);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + d[12] + 1518500249, 13);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + d[1] + 1518500249, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + d[5] + 1518500249, 5);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + d[9] + 1518500249, 9);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + d[13] + 1518500249, 13);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + d[2] + 1518500249, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + d[6] + 1518500249, 5);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + d[10] + 1518500249, 9);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + d[14] + 1518500249, 13);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.G(this.B, this.C, this.D) + d[3] + 1518500249, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.G(this.A, this.B, this.C) + d[7] + 1518500249, 5);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.G(this.D, this.A, this.B) + d[11] + 1518500249, 9);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.G(this.C, this.D, this.A) + var1_1[15] + 1518500249, 13);
        }

        /*
         * WARNING - void declaration
         */
        protected void round3(int[] d) {
            void var1_1;
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + d[0] + 1859775393, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + d[8] + 1859775393, 9);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + d[4] + 1859775393, 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + d[12] + 1859775393, 15);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + d[2] + 1859775393, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + d[10] + 1859775393, 9);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + d[6] + 1859775393, 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + d[14] + 1859775393, 15);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + d[1] + 1859775393, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + d[9] + 1859775393, 9);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + d[5] + 1859775393, 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + d[13] + 1859775393, 15);
            this.A = NTLMEngineImpl.rotintlft(this.A + NTLMEngineImpl.H(this.B, this.C, this.D) + d[3] + 1859775393, 3);
            this.D = NTLMEngineImpl.rotintlft(this.D + NTLMEngineImpl.H(this.A, this.B, this.C) + d[11] + 1859775393, 9);
            this.C = NTLMEngineImpl.rotintlft(this.C + NTLMEngineImpl.H(this.D, this.A, this.B) + d[7] + 1859775393, 11);
            this.B = NTLMEngineImpl.rotintlft(this.B + NTLMEngineImpl.H(this.C, this.D, this.A) + var1_1[15] + 1859775393, 15);
        }
    }

    static class Type3Message
    extends NTLMMessage {
        protected int type2Flags;
        protected byte[] domainBytes;
        protected byte[] hostBytes;
        protected byte[] userBytes;
        protected byte[] lmResp;
        protected byte[] ntResp;
        protected byte[] sessionKey;

        /*
         * WARNING - void declaration
         */
        Type3Message(String domain, String host, String user, String password, byte[] nonce, int type2Flags, String target, byte[] targetInformation) throws NTLMEngineException {
            void var3_3;
            void var1_1;
            void var2_2;
            byte[] userSessionKey;
            this.type2Flags = type2Flags;
            String unqualifiedHost = NTLMEngineImpl.convertHost(host);
            String unqualifiedDomain = NTLMEngineImpl.convertDomain(domain);
            CipherGen gen = new CipherGen(unqualifiedDomain, user, password, nonce, target, targetInformation);
            try {
                if ((type2Flags & 0x800000) != 0 && targetInformation != null && target != null) {
                    this.ntResp = gen.getNTLMv2Response();
                    this.lmResp = gen.getLMv2Response();
                    userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLMv2UserSessionKey();
                } else if ((type2Flags & 0x80000) != 0) {
                    this.ntResp = gen.getNTLM2SessionResponse();
                    this.lmResp = gen.getLM2SessionResponse();
                    userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLM2SessionResponseUserSessionKey();
                } else {
                    this.ntResp = gen.getNTLMResponse();
                    this.lmResp = gen.getLMResponse();
                    userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getNTLMUserSessionKey();
                }
            }
            catch (NTLMEngineException nTLMEngineException) {
                this.ntResp = new byte[0];
                this.lmResp = gen.getLMResponse();
                userSessionKey = (type2Flags & 0x80) != 0 ? gen.getLanManagerSessionKey() : gen.getLMUserSessionKey();
            }
            this.sessionKey = (byte[])((type2Flags & 0x10) != 0 ? ((type2Flags & 0x40000000) != 0 ? NTLMEngineImpl.RC4(gen.getSecondaryKey(), userSessionKey) : userSessionKey) : null);
            if (UNICODE_LITTLE_UNMARKED == null) {
                throw new NTLMEngineException("Unicode not supported");
            }
            this.hostBytes = unqualifiedHost != null ? var2_2.getBytes(UNICODE_LITTLE_UNMARKED) : null;
            this.domainBytes = unqualifiedDomain != null ? var1_1.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED) : null;
            this.userBytes = var3_3.getBytes(UNICODE_LITTLE_UNMARKED);
        }

        /*
         * WARNING - void declaration
         */
        @Override
        String getResponse() {
            void var3_3;
            void var1_1;
            void var2_2;
            int ntRespLen = this.ntResp.length;
            int lmRespLen = this.lmResp.length;
            int domainLen = this.domainBytes != null ? this.domainBytes.length : 0;
            int hostLen = this.hostBytes != null ? this.hostBytes.length : 0;
            int userLen = this.userBytes.length;
            int sessionKeyLen = this.sessionKey != null ? this.sessionKey.length : 0;
            int ntRespOffset = lmRespLen + 72;
            int domainOffset = ntRespOffset + ntRespLen;
            int userOffset = domainOffset + domainLen;
            int hostOffset = userOffset + userLen;
            int sessionKeyOffset = hostOffset + hostLen;
            int finalLength = sessionKeyOffset + sessionKeyLen;
            this.prepareResponse(finalLength, 3);
            this.addUShort(lmRespLen);
            this.addUShort((int)var2_2);
            this.addULong(72);
            this.addUShort(ntRespLen);
            this.addUShort((int)var1_1);
            this.addULong(ntRespOffset);
            this.addUShort(domainLen);
            this.addUShort((int)var3_3);
            this.addULong(domainOffset);
            this.addUShort(userLen);
            this.addUShort(userLen);
            this.addULong(userOffset);
            this.addUShort(hostLen);
            this.addUShort(hostLen);
            this.addULong(hostOffset);
            this.addUShort(sessionKeyLen);
            this.addUShort(sessionKeyLen);
            this.addULong(sessionKeyOffset);
            Type3Message type3Message = this;
            type3Message.addULong(type3Message.type2Flags & 0x80 | this.type2Flags & 0x200 | this.type2Flags & 0x80000 | 0x2000000 | this.type2Flags & 0x8000 | this.type2Flags & 0x20 | this.type2Flags & 0x10 | this.type2Flags & 0x20000000 | this.type2Flags & Integer.MIN_VALUE | this.type2Flags & 0x40000000 | this.type2Flags & 0x800000 | this.type2Flags & 1 | this.type2Flags & 4);
            this.addUShort(261);
            this.addULong(2600);
            this.addUShort(3840);
            Type3Message type3Message2 = this;
            type3Message2.addBytes(type3Message2.lmResp);
            Type3Message type3Message3 = this;
            type3Message3.addBytes(type3Message3.ntResp);
            Type3Message type3Message4 = this;
            type3Message4.addBytes(type3Message4.domainBytes);
            Type3Message type3Message5 = this;
            type3Message5.addBytes(type3Message5.userBytes);
            Type3Message type3Message6 = this;
            type3Message6.addBytes(type3Message6.hostBytes);
            if (this.sessionKey != null) {
                Type3Message type3Message7 = this;
                type3Message7.addBytes(type3Message7.sessionKey);
            }
            return super.getResponse();
        }
    }

    static class Type2Message
    extends NTLMMessage {
        protected byte[] challenge = new byte[8];
        protected String target;
        protected byte[] targetInfo;
        protected int flags;

        /*
         * WARNING - void declaration
         */
        Type2Message(String message) throws NTLMEngineException {
            super(message, 2);
            byte[] bytes;
            Type2Message type2Message = this;
            type2Message.readBytes(type2Message.challenge, 24);
            this.flags = this.readULong(20);
            if ((this.flags & 1) == 0) {
                throw new NTLMEngineException("NTLM type 2 message indicates no support for Unicode. Flags are: " + Integer.toString(this.flags));
            }
            this.target = null;
            if (this.getMessageLength() >= 20 && (bytes = this.readSecurityBuffer(12)).length != 0) {
                try {
                    this.target = new String(bytes, "UnicodeLittleUnmarked");
                }
                catch (UnsupportedEncodingException e) {
                    throw new NTLMEngineException(e.getMessage(), e);
                }
            }
            this.targetInfo = null;
            if (this.getMessageLength() >= 48 && (bytes = this.readSecurityBuffer(40)).length != 0) {
                void var1_1;
                this.targetInfo = var1_1;
            }
        }

        byte[] getChallenge() {
            return this.challenge;
        }

        String getTarget() {
            return this.target;
        }

        byte[] getTargetInfo() {
            return this.targetInfo;
        }

        int getFlags() {
            return this.flags;
        }
    }

    static class Type1Message
    extends NTLMMessage {
        private final byte[] hostBytes;
        private final byte[] domainBytes;

        /*
         * WARNING - void declaration
         */
        Type1Message(String domain, String host) throws NTLMEngineException {
            void var1_1;
            void var2_2;
            if (UNICODE_LITTLE_UNMARKED == null) {
                throw new NTLMEngineException("Unicode not supported");
            }
            String unqualifiedHost = NTLMEngineImpl.convertHost(host);
            String unqualifiedDomain = NTLMEngineImpl.convertDomain(domain);
            this.hostBytes = unqualifiedHost != null ? var2_2.getBytes(UNICODE_LITTLE_UNMARKED) : null;
            this.domainBytes = unqualifiedDomain != null ? var1_1.toUpperCase(Locale.ROOT).getBytes(UNICODE_LITTLE_UNMARKED) : null;
        }

        Type1Message() {
            this.hostBytes = null;
            this.domainBytes = null;
        }

        @Override
        String getResponse() {
            this.prepareResponse(40, 1);
            this.addULong(-1576500735);
            this.addUShort(0);
            this.addUShort(0);
            this.addULong(40);
            this.addUShort(0);
            this.addUShort(0);
            this.addULong(40);
            this.addUShort(261);
            this.addULong(2600);
            this.addUShort(3840);
            if (this.hostBytes != null) {
                Type1Message type1Message = this;
                type1Message.addBytes(type1Message.hostBytes);
            }
            if (this.domainBytes != null) {
                Type1Message type1Message = this;
                type1Message.addBytes(type1Message.domainBytes);
            }
            return super.getResponse();
        }
    }

    static class NTLMMessage {
        private byte[] messageContents = null;
        private int currentOutputPosition = 0;

        NTLMMessage() {
        }

        /*
         * WARNING - void declaration
         */
        NTLMMessage(String messageBody, int expectedType) throws NTLMEngineException {
            this.messageContents = Base64.decodeBase64((byte[])messageBody.getBytes(DEFAULT_CHARSET));
            if (this.messageContents.length < SIGNATURE.length) {
                throw new NTLMEngineException("NTLM message decoding error - packet too short");
            }
            for (int i = 0; i < SIGNATURE.length; ++i) {
                if (this.messageContents[i] == SIGNATURE[i]) continue;
                throw new NTLMEngineException("NTLM message expected - instead got unrecognized bytes");
            }
            int type = this.readULong(SIGNATURE.length);
            if (type != expectedType) {
                void var1_2;
                void var2_3;
                throw new NTLMEngineException("NTLM type " + Integer.toString((int)var2_3) + " message expected - instead got type " + Integer.toString((int)var1_2));
            }
            this.currentOutputPosition = this.messageContents.length;
        }

        protected int getPreambleLength() {
            return SIGNATURE.length + 4;
        }

        protected int getMessageLength() {
            return this.currentOutputPosition;
        }

        /*
         * WARNING - void declaration
         */
        protected byte readByte(int position) throws NTLMEngineException {
            void var1_1;
            if (this.messageContents.length < position + 1) {
                throw new NTLMEngineException("NTLM: Message too short");
            }
            return this.messageContents[var1_1];
        }

        /*
         * WARNING - void declaration
         */
        protected void readBytes(byte[] buffer, int position) throws NTLMEngineException {
            void var1_1;
            void var2_2;
            if (this.messageContents.length < position + buffer.length) {
                throw new NTLMEngineException("NTLM: Message too short");
            }
            System.arraycopy(this.messageContents, (int)var2_2, buffer, 0, ((void)var1_1).length);
        }

        /*
         * WARNING - void declaration
         */
        protected int readUShort(int position) throws NTLMEngineException {
            void var1_1;
            return NTLMEngineImpl.access$1200(this.messageContents, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected int readULong(int position) throws NTLMEngineException {
            void var1_1;
            return NTLMEngineImpl.access$1300(this.messageContents, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected byte[] readSecurityBuffer(int position) throws NTLMEngineException {
            void var1_1;
            return NTLMEngineImpl.access$1400(this.messageContents, (int)var1_1);
        }

        /*
         * WARNING - void declaration
         */
        protected void prepareResponse(int maxlength, int messageType) {
            void var2_2;
            void var1_1;
            this.messageContents = new byte[var1_1];
            this.currentOutputPosition = 0;
            this.addBytes(SIGNATURE);
            this.addULong((int)var2_2);
        }

        /*
         * WARNING - void declaration
         */
        protected void addByte(byte b) {
            void var1_1;
            this.messageContents[this.currentOutputPosition] = var1_1;
            ++this.currentOutputPosition;
        }

        protected void addBytes(byte[] bytes) {
            if (bytes == null) {
                return;
            }
            byte[] arr$ = bytes;
            int len$ = bytes.length;
            for (int i$ = 0; i$ < len$; ++i$) {
                byte b;
                this.messageContents[this.currentOutputPosition] = b = arr$[i$];
                ++this.currentOutputPosition;
            }
        }

        /*
         * WARNING - void declaration
         */
        protected void addUShort(int value) {
            void var1_1;
            this.addByte((byte)value);
            this.addByte((byte)(var1_1 >> 8));
        }

        /*
         * WARNING - void declaration
         */
        protected void addULong(int value) {
            void var1_1;
            this.addByte((byte)value);
            this.addByte((byte)(value >> 8));
            this.addByte((byte)(value >> 16));
            this.addByte((byte)(var1_1 >>> 24));
        }

        /*
         * WARNING - void declaration
         */
        String getResponse() {
            void var1_1;
            if (this.messageContents.length > this.currentOutputPosition) {
                byte[] tmp = new byte[this.currentOutputPosition];
                System.arraycopy(this.messageContents, 0, tmp, 0, this.currentOutputPosition);
            } else {
                byte[] resp = this.messageContents;
            }
            return EncodingUtils.getAsciiString((byte[])Base64.encodeBase64((byte[])var1_1));
        }
    }

    protected static class CipherGen {
        protected final String domain;
        protected final String user;
        protected final String password;
        protected final byte[] challenge;
        protected final String target;
        protected final byte[] targetInformation;
        protected byte[] clientChallenge;
        protected byte[] clientChallenge2;
        protected byte[] secondaryKey;
        protected byte[] timestamp;
        protected byte[] lmHash = null;
        protected byte[] lmResponse = null;
        protected byte[] ntlmHash = null;
        protected byte[] ntlmResponse = null;
        protected byte[] ntlmv2Hash = null;
        protected byte[] lmv2Hash = null;
        protected byte[] lmv2Response = null;
        protected byte[] ntlmv2Blob = null;
        protected byte[] ntlmv2Response = null;
        protected byte[] ntlm2SessionResponse = null;
        protected byte[] lm2SessionResponse = null;
        protected byte[] lmUserSessionKey = null;
        protected byte[] ntlmUserSessionKey = null;
        protected byte[] ntlmv2UserSessionKey = null;
        protected byte[] ntlm2SessionResponseUserSessionKey = null;
        protected byte[] lanManagerSessionKey = null;

        /*
         * WARNING - void declaration
         */
        public CipherGen(String domain, String user, String password, byte[] challenge, String target, byte[] targetInformation, byte[] clientChallenge, byte[] clientChallenge2, byte[] secondaryKey, byte[] timestamp) {
            void var3_3;
            void var2_2;
            void var1_1;
            this.domain = var1_1;
            this.target = target;
            this.user = var2_2;
            this.password = var3_3;
            this.challenge = challenge;
            this.targetInformation = targetInformation;
            this.clientChallenge = clientChallenge;
            this.clientChallenge2 = clientChallenge2;
            this.secondaryKey = secondaryKey;
            this.timestamp = timestamp;
        }

        /*
         * WARNING - void declaration
         */
        public CipherGen(String domain, String user, String password, byte[] challenge, String target, byte[] targetInformation) {
            this((String)var1_1, (String)var2_2, (String)var3_3, challenge, target, targetInformation, null, null, null, null);
            void var3_3;
            void var2_2;
            void var1_1;
        }

        public byte[] getClientChallenge() throws NTLMEngineException {
            if (this.clientChallenge == null) {
                this.clientChallenge = NTLMEngineImpl.makeRandomChallenge();
            }
            return this.clientChallenge;
        }

        public byte[] getClientChallenge2() throws NTLMEngineException {
            if (this.clientChallenge2 == null) {
                this.clientChallenge2 = NTLMEngineImpl.makeRandomChallenge();
            }
            return this.clientChallenge2;
        }

        public byte[] getSecondaryKey() throws NTLMEngineException {
            if (this.secondaryKey == null) {
                this.secondaryKey = NTLMEngineImpl.makeSecondaryKey();
            }
            return this.secondaryKey;
        }

        public byte[] getLMHash() throws NTLMEngineException {
            if (this.lmHash == null) {
                this.lmHash = NTLMEngineImpl.lmHash(this.password);
            }
            return this.lmHash;
        }

        public byte[] getLMResponse() throws NTLMEngineException {
            if (this.lmResponse == null) {
                this.lmResponse = NTLMEngineImpl.access$300(this.getLMHash(), this.challenge);
            }
            return this.lmResponse;
        }

        public byte[] getNTLMHash() throws NTLMEngineException {
            if (this.ntlmHash == null) {
                this.ntlmHash = NTLMEngineImpl.ntlmHash(this.password);
            }
            return this.ntlmHash;
        }

        public byte[] getNTLMResponse() throws NTLMEngineException {
            if (this.ntlmResponse == null) {
                this.ntlmResponse = NTLMEngineImpl.access$300(this.getNTLMHash(), this.challenge);
            }
            return this.ntlmResponse;
        }

        public byte[] getLMv2Hash() throws NTLMEngineException {
            if (this.lmv2Hash == null) {
                this.lmv2Hash = NTLMEngineImpl.access$500(this.domain, this.user, this.getNTLMHash());
            }
            return this.lmv2Hash;
        }

        public byte[] getNTLMv2Hash() throws NTLMEngineException {
            if (this.ntlmv2Hash == null) {
                this.ntlmv2Hash = NTLMEngineImpl.access$600(this.domain, this.user, this.getNTLMHash());
            }
            return this.ntlmv2Hash;
        }

        public byte[] getTimestamp() {
            if (this.timestamp == null) {
                long l = System.currentTimeMillis();
                long time = (l += 11644473600000L) * 10000L;
                this.timestamp = new byte[8];
                for (int i = 0; i < 8; ++i) {
                    this.timestamp[i] = (byte)time;
                    time >>>= 8;
                }
            }
            return this.timestamp;
        }

        public byte[] getNTLMv2Blob() throws NTLMEngineException {
            if (this.ntlmv2Blob == null) {
                this.ntlmv2Blob = NTLMEngineImpl.access$700(this.getClientChallenge2(), this.targetInformation, this.getTimestamp());
            }
            return this.ntlmv2Blob;
        }

        public byte[] getNTLMv2Response() throws NTLMEngineException {
            if (this.ntlmv2Response == null) {
                this.ntlmv2Response = NTLMEngineImpl.access$800(this.getNTLMv2Hash(), this.challenge, this.getNTLMv2Blob());
            }
            return this.ntlmv2Response;
        }

        public byte[] getLMv2Response() throws NTLMEngineException {
            if (this.lmv2Response == null) {
                this.lmv2Response = NTLMEngineImpl.access$800(this.getLMv2Hash(), this.challenge, this.getClientChallenge());
            }
            return this.lmv2Response;
        }

        public byte[] getNTLM2SessionResponse() throws NTLMEngineException {
            if (this.ntlm2SessionResponse == null) {
                this.ntlm2SessionResponse = NTLMEngineImpl.ntlm2SessionResponse(this.getNTLMHash(), this.challenge, this.getClientChallenge());
            }
            return this.ntlm2SessionResponse;
        }

        /*
         * WARNING - void declaration
         */
        public byte[] getLM2SessionResponse() throws NTLMEngineException {
            if (this.lm2SessionResponse == null) {
                void var1_1;
                byte[] clntChallenge = this.getClientChallenge();
                this.lm2SessionResponse = new byte[24];
                System.arraycopy(clntChallenge, 0, this.lm2SessionResponse, 0, clntChallenge.length);
                Arrays.fill(this.lm2SessionResponse, ((void)var1_1).length, this.lm2SessionResponse.length, (byte)0);
            }
            return this.lm2SessionResponse;
        }

        public byte[] getLMUserSessionKey() throws NTLMEngineException {
            if (this.lmUserSessionKey == null) {
                this.lmUserSessionKey = new byte[16];
                System.arraycopy(this.getLMHash(), 0, this.lmUserSessionKey, 0, 8);
                Arrays.fill(this.lmUserSessionKey, 8, 16, (byte)0);
            }
            return this.lmUserSessionKey;
        }

        /*
         * WARNING - void declaration
         */
        public byte[] getNTLMUserSessionKey() throws NTLMEngineException {
            if (this.ntlmUserSessionKey == null) {
                void var1_1;
                MD4 md4 = new MD4();
                md4.update(this.getNTLMHash());
                this.ntlmUserSessionKey = var1_1.getOutput();
            }
            return this.ntlmUserSessionKey;
        }

        /*
         * WARNING - void declaration
         */
        public byte[] getNTLMv2UserSessionKey() throws NTLMEngineException {
            if (this.ntlmv2UserSessionKey == null) {
                void var1_1;
                void var2_2;
                byte[] ntlmv2hash = this.getNTLMv2Hash();
                byte[] truncatedResponse = new byte[16];
                System.arraycopy(this.getNTLMv2Response(), 0, truncatedResponse, 0, 16);
                this.ntlmv2UserSessionKey = NTLMEngineImpl.hmacMD5((byte[])var2_2, (byte[])var1_1);
            }
            return this.ntlmv2UserSessionKey;
        }

        /*
         * WARNING - void declaration
         */
        public byte[] getNTLM2SessionResponseUserSessionKey() throws NTLMEngineException {
            if (this.ntlm2SessionResponseUserSessionKey == null) {
                void var2_2;
                void var1_1;
                byte[] ntlm2SessionResponseNonce = this.getLM2SessionResponse();
                byte[] sessionNonce = new byte[this.challenge.length + ntlm2SessionResponseNonce.length];
                System.arraycopy(this.challenge, 0, sessionNonce, 0, this.challenge.length);
                System.arraycopy(ntlm2SessionResponseNonce, 0, sessionNonce, this.challenge.length, ((void)var1_1).length);
                this.ntlm2SessionResponseUserSessionKey = NTLMEngineImpl.hmacMD5((byte[])var2_2, this.getNTLMUserSessionKey());
            }
            return this.ntlm2SessionResponseUserSessionKey;
        }

        /*
         * WARNING - void declaration
         */
        public byte[] getLanManagerSessionKey() throws NTLMEngineException {
            if (this.lanManagerSessionKey == null) {
                try {
                    void var2_3;
                    void var3_4;
                    byte[] keyBytes = new byte[14];
                    System.arraycopy(this.getLMHash(), 0, keyBytes, 0, 8);
                    Arrays.fill(keyBytes, 8, keyBytes.length, (byte)-67);
                    Key lowKey = NTLMEngineImpl.access$900(keyBytes, 0);
                    Key highKey = NTLMEngineImpl.access$900(keyBytes, 7);
                    byte[] truncatedResponse = new byte[8];
                    System.arraycopy(this.getLMResponse(), 0, truncatedResponse, 0, truncatedResponse.length);
                    Cipher des = Cipher.getInstance("DES/ECB/NoPadding");
                    des.init(1, lowKey);
                    byte[] lowPart = des.doFinal(truncatedResponse);
                    des = Cipher.getInstance("DES/ECB/NoPadding");
                    des.init(1, highKey);
                    byte[] highPart = des.doFinal((byte[])var3_4);
                    this.lanManagerSessionKey = new byte[16];
                    System.arraycopy(lowPart, 0, this.lanManagerSessionKey, 0, lowPart.length);
                    System.arraycopy(highPart, 0, this.lanManagerSessionKey, ((void)var2_3).length, highPart.length);
                }
                catch (Exception e) {
                    void var1_2;
                    throw new NTLMEngineException(e.getMessage(), (Throwable)var1_2);
                }
            }
            return this.lanManagerSessionKey;
        }
    }
}

