/*
 * Decompiled with CFR 0.152.
 */
package org.apache.http.impl.auth;

import java.net.InetAddress;
import java.net.UnknownHostException;
import org.apache.commons.codec.binary.Base64;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.http.Header;
import org.apache.http.HttpHost;
import org.apache.http.HttpRequest;
import org.apache.http.annotation.NotThreadSafe;
import org.apache.http.auth.AuthenticationException;
import org.apache.http.auth.Credentials;
import org.apache.http.auth.InvalidCredentialsException;
import org.apache.http.auth.KerberosCredentials;
import org.apache.http.auth.MalformedChallengeException;
import org.apache.http.conn.routing.HttpRoute;
import org.apache.http.impl.auth.AuthSchemeBase;
import org.apache.http.message.BufferedHeader;
import org.apache.http.protocol.HttpContext;
import org.apache.http.util.Args;
import org.apache.http.util.CharArrayBuffer;
import org.ietf.jgss.GSSContext;
import org.ietf.jgss.GSSCredential;
import org.ietf.jgss.GSSException;
import org.ietf.jgss.GSSManager;
import org.ietf.jgss.GSSName;
import org.ietf.jgss.Oid;

@NotThreadSafe
public abstract class GGSSchemeBase
extends AuthSchemeBase {
    private final Log log = LogFactory.getLog(this.getClass());
    private final Base64 base64codec = new Base64(0);
    private final boolean stripPort;
    private final boolean useCanonicalHostname;
    private State state;
    private byte[] token;

    /*
     * WARNING - void declaration
     */
    GGSSchemeBase(boolean stripPort, boolean useCanonicalHostname) {
        void var2_2;
        void var1_1;
        this.stripPort = var1_1;
        this.useCanonicalHostname = var2_2;
        this.state = State.UNINITIATED;
    }

    /*
     * WARNING - void declaration
     */
    GGSSchemeBase(boolean stripPort) {
        this((boolean)var1_1, true);
        void var1_1;
    }

    GGSSchemeBase() {
        this(true, true);
    }

    protected GSSManager getManager() {
        return GSSManager.getInstance();
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer) throws GSSException {
        void var3_3;
        void var2_2;
        void var1_1;
        return this.generateGSSToken((byte[])var1_1, (Oid)var2_2, (String)var3_3, null);
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] generateGSSToken(byte[] input, Oid oid, String authServer, Credentials credentials) throws GSSException {
        void var1_1;
        void var2_2;
        void var3_3;
        byte[] inputBuff = input;
        if (input == null) {
            inputBuff = new byte[]{};
        }
        GSSManager manager = this.getManager();
        GSSName serverName = manager.createName("HTTP@" + authServer, GSSName.NT_HOSTBASED_SERVICE);
        GSSCredential gssCredential = credentials instanceof KerberosCredentials ? ((KerberosCredentials)credentials).getGSSCredential() : null;
        GSSContext gssContext = manager.createContext(var3_3.canonicalize(oid), oid, gssCredential, 0);
        gssContext.requestMutualAuth(true);
        gssContext.requestCredDeleg(true);
        return var2_2.initSecContext(inputBuff, 0, ((void)var1_1).length);
    }

    @Deprecated
    protected byte[] generateToken(byte[] input, String authServer) throws GSSException {
        return null;
    }

    /*
     * WARNING - void declaration
     */
    protected byte[] generateToken(byte[] input, String authServer, Credentials credentials) throws GSSException {
        void var2_2;
        void var1_1;
        return this.generateToken((byte[])var1_1, (String)var2_2);
    }

    @Override
    public boolean isComplete() {
        return this.state == State.TOKEN_GENERATED || this.state == State.FAILED;
    }

    /*
     * WARNING - void declaration
     */
    @Override
    @Deprecated
    public Header authenticate(Credentials credentials, HttpRequest request) throws AuthenticationException {
        void var2_2;
        void var1_1;
        return ((AuthSchemeBase)this).authenticate((Credentials)var1_1, (HttpRequest)var2_2, null);
    }

    /*
     * WARNING - void declaration
     */
    @Override
    public Header authenticate(Credentials credentials, HttpRequest request, HttpContext context) throws AuthenticationException {
        Args.notNull((Object)request, (String)"HTTP request");
        switch (this.state) {
            case UNINITIATED: {
                throw new AuthenticationException(this.getSchemeName() + " authentication has not been initiated");
            }
            case FAILED: {
                throw new AuthenticationException(this.getSchemeName() + " authentication has failed");
            }
            case CHALLENGE_RECEIVED: {
                try {
                    void var1_1;
                    String authServer;
                    HttpHost host;
                    HttpRoute route = (HttpRoute)context.getAttribute("http.route");
                    if (route == null) {
                        throw new AuthenticationException("Connection route is not available");
                    }
                    if (!this.isProxy() || (host = route.getProxyHost()) == null) {
                        host = route.getTargetHost();
                    }
                    String hostname = host.getHostName();
                    if (this.useCanonicalHostname) {
                        try {
                            hostname = this.resolveCanonicalHostname(hostname);
                        }
                        catch (UnknownHostException unknownHostException) {}
                    }
                    if (!this.stripPort) {
                        authServer = authServer + ":" + host.getPort();
                    }
                    if (this.log.isDebugEnabled()) {
                        this.log.debug((Object)("init " + authServer));
                    }
                    this.token = this.generateToken(this.token, authServer, (Credentials)var1_1);
                    this.state = State.TOKEN_GENERATED;
                }
                catch (GSSException gsse) {
                    this.state = State.FAILED;
                    if (gsse.getMajor() == 9 || gsse.getMajor() == 8) {
                        throw new InvalidCredentialsException(gsse.getMessage(), gsse);
                    }
                    if (gsse.getMajor() == 13) {
                        throw new InvalidCredentialsException(gsse.getMessage(), gsse);
                    }
                    if (gsse.getMajor() == 10 || gsse.getMajor() == 19 || gsse.getMajor() == 20) {
                        throw new AuthenticationException(gsse.getMessage(), gsse);
                    }
                    throw new AuthenticationException(gsse.getMessage());
                }
            }
            case TOKEN_GENERATED: {
                void var3_4;
                void var2_2;
                String tokenstr = new String(this.base64codec.encode(this.token));
                if (this.log.isDebugEnabled()) {
                    this.log.debug((Object)("Sending response '" + tokenstr + "' back to the auth server"));
                }
                CharArrayBuffer buffer = new CharArrayBuffer(32);
                if (this.isProxy()) {
                    buffer.append("Proxy-Authorization");
                } else {
                    buffer.append("Authorization");
                }
                buffer.append(": Negotiate ");
                buffer.append((String)var2_2);
                return new BufferedHeader((CharArrayBuffer)var3_4);
            }
        }
        throw new IllegalStateException("Illegal state: " + (Object)((Object)this.state));
    }

    /*
     * WARNING - void declaration
     */
    @Override
    protected void parseChallenge(CharArrayBuffer buffer, int beginIndex, int endIndex) throws MalformedChallengeException {
        void var3_3;
        void var2_2;
        String challenge = buffer.substringTrimmed((int)var2_2, (int)var3_3);
        if (this.log.isDebugEnabled()) {
            this.log.debug((Object)("Received challenge '" + challenge + "' from the auth server"));
        }
        if (this.state == State.UNINITIATED) {
            void var1_1;
            this.token = Base64.decodeBase64((byte[])var1_1.getBytes());
            this.state = State.CHALLENGE_RECEIVED;
            return;
        }
        this.log.debug((Object)"Authentication already attempted");
        this.state = State.FAILED;
    }

    /*
     * WARNING - void declaration
     */
    private String resolveCanonicalHostname(String host) throws UnknownHostException {
        void var3_3;
        void var2_2;
        InetAddress in = InetAddress.getByName(host);
        String canonicalServer = in.getCanonicalHostName();
        if (var2_2.getHostAddress().contentEquals(canonicalServer)) {
            void var1_1;
            return var1_1;
        }
        return var3_3;
    }

    static enum State {
        UNINITIATED,
        CHALLENGE_RECEIVED,
        TOKEN_GENERATED,
        FAILED;

    }
}

